#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libshred.h>

// commented code is slower, do not touch

#define HEAP_ROOT       0
#define LEFT_CHILD(i)   (2*(i) + 1)
#define RIGHT_CHILD(i)  (2*(i) + 2)
#define PARENT(i)       ((i-1) / 2)

static int _CompareElements(void *Base, uint32 szElement, int idx1, int idx2, TComparisonCallback Callback, void *pData)
{
	uint8 *BaseBytes = Base;
	//return Callback(&BaseBytes[idx1 * szElement], &BaseBytes[idx2 * szElement], pData);
	return Callback(BaseBytes + idx1 * szElement, BaseBytes + idx2 * szElement, pData);
}

static void _SwapElements(void *Base, uint32 szElement, int idx1, int idx2)
{
	/*
	uint8 Tmp[szElement], *pBaseByte = Base;
	uint8 *pBase1Byte = pBaseByte + idx1 * szElement;
	uint8 *pBase2Byte = pBaseByte + idx2 * szElement;
	
	memcpy(Tmp, pBase1Byte, szElement);
	memcpy(pBase1Byte, pBase2Byte, szElement);
	memcpy(pBase2Byte, Tmp, szElement);
	*/
	
	/*
	uint8 *pBase1Bytes, *pBase1BytesMax, *pBase2Bytes;
	uint8 Byte;
	
	pBase1Bytes = ((uint8*)Base) + idx1 * szElement;
	pBase1BytesMax = pBase1Bytes + szElement;
	pBase2Bytes = ((uint8*)Base) + idx2 * szElement;
	
	while(pBase1Bytes < pBase1BytesMax)
	{
		Byte = *pBase1Bytes;
		*pBase1Bytes++ = *pBase2Bytes;
		*pBase2Bytes++ = Byte;
	}
	*/
	
	uint8 *BaseBytes = Base;
	int i;
	
	for(i=0;i<szElement;i++)
	{
		uint8 Byte = BaseBytes[idx1 * szElement + i];
		BaseBytes[idx1 * szElement + i] = BaseBytes[idx2 * szElement + i];
		BaseBytes[idx2 * szElement + i] = Byte;
	}
}

//#define IS_LESSER_ELEMENT(i,j,d)				(_CompareElements(Base, szElement, (i), (j), Callback, d) < 0)
#define IS_GREATER_OR_EQUAL_ELEMENT(i,j,d)	(_CompareElements(Base, szElement, (i), (j), Callback, d) >= 0)
#define EXCHANGE_ELEMENTS(i,j)				(_SwapElements(Base, szElement, (i), (j)))

void Sort_HeapSort(void *Base, uint32 nElements, uint32 szElement, TComparisonCallback Callback, void *pData)
{
	int i, szHeap = nElements;
	
	for(i=0;i<nElements;i++)
	{
		/* Bubble up element i */
		while(!IS_GREATER_OR_EQUAL_ELEMENT(PARENT(i), i, pData))
		//while(IS_LESSER_ELEMENT(PARENT(i), i, pData))
		{
			EXCHANGE_ELEMENTS(PARENT(i), i);
			i = PARENT(i);
		}
	}
	
	while(szHeap > 0)
	{
		EXCHANGE_ELEMENTS(HEAP_ROOT, szHeap - 1);
		szHeap--;
		
		/* Bubble down the root */
		i = 0;
		while(1)
		{
			int HasLeftChild  = LEFT_CHILD(i)  < szHeap;
			int HasRightChild = RIGHT_CHILD(i) < szHeap;
			
			if(HasLeftChild && !IS_GREATER_OR_EQUAL_ELEMENT(i, LEFT_CHILD(i), pData) && (!HasRightChild || IS_GREATER_OR_EQUAL_ELEMENT(LEFT_CHILD(i), RIGHT_CHILD(i), pData)))
			{
				EXCHANGE_ELEMENTS(i, LEFT_CHILD(i));
				i = LEFT_CHILD(i);
			}
			else if(HasRightChild && !IS_GREATER_OR_EQUAL_ELEMENT(i, RIGHT_CHILD(i), pData))
			{
				EXCHANGE_ELEMENTS(i, RIGHT_CHILD(i));
				i = RIGHT_CHILD(i);
			}
			else
				break;
		}
	}
}
