#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libshred.h>


void Test_NestedArray(int Dump)
{
	TDictionary *Dict;
	int i;
	char **Keys = NULL;
	int lKeys = 0;
	
	
	Dict = Dictionary_Create();
	
	// fill with various data
	Dictionary_Set_Int32(Dict, "Net.Interface.Default", 0);
	
	Dictionary_Set(Dict, "Net.Interface.0.Name", "eth0");
	Dictionary_Set(Dict, "Net.Interface.0.IP.0.Addr", "192.168.0.1");
	Dictionary_Set(Dict, "Net.Interface.0.IP.0.Netmask", "255.255.255.0");
	Dictionary_Set(Dict, "Net.Interface.0.IP.1.Addr", "192.168.1.1");
	Dictionary_Set(Dict, "Net.Interface.0.IP.1.Netmask", "255.255.255.0");
	
	Dictionary_Set(Dict, "Net.Interface.1.Name", "eth1");
	Dictionary_Set(Dict, "Net.Interface.1.IP.0.Addr", "192.168.2.1");
	Dictionary_Set(Dict, "Net.Interface.1.IP.0.Netmask", "255.255.255.0");
	
	Dictionary_Set(Dict, "Net.Interface.3.Name", "ra0");
	
	Dictionary_Set(Dict, "Net.Interface.33Name", "ra555");
	Dictionary_Set(Dict, "Net.Interface.33N.a.m.e", "ra555");
	Dictionary_Set(Dict, "Net.Interface.33", "ra555");
	Dictionary_Set(Dict, "Net.Interface.Other.0.Name", "error");
	
	
	{
		char TmpBuf[256];
		char *Path = "Net.Interface";
		int lInterfaces;
		
		lInterfaces = Dictionary_Count(Dict, Path);
		if(Dump)
			LOG_DEBUG("interfaces: %d", lInterfaces);
		for(i=0;i<lInterfaces;i++)
		{
			char Path2[256];
			
			snprintf(Path2, sizeof(Path2) - 1, "%s.%d.Name", Path, i);
			if(Dump)
				LOG_DEBUG("  [%d] [%s]", i, Dictionary_GetValue(Dict, Path2, TmpBuf, sizeof(TmpBuf)));
			if(TmpBuf[0])
			{
				int j, lIP;
				
				snprintf(Path2, sizeof(Path2) - 1, "%s.%d.IP", Path, i);
				lIP = Dictionary_Count(Dict, Path2);
				if(Dump)
					LOG_DEBUG("  ip addresses: %d", lIP);
				for(j=0;j<lIP;j++)
				{
					char Path3[256];
					char IP[32], Netmask[32];
					
					snprintf(Path3, sizeof(Path3) - 1, "%s.%d.Addr", Path2, j);
					Dictionary_GetValue(Dict, Path3, IP, sizeof(IP));
					snprintf(Path3, sizeof(Path3) - 1, "%s.%d.Netmask", Path2, j);
					Dictionary_GetValue(Dict, Path3, Netmask, sizeof(Netmask));
					if(Dump)
						LOG_DEBUG("    %s / %s", IP, Netmask);
				}
			}
		}
	}
	
	// dump keys
	Dictionary_GetKeys(Dict, &Keys, &lKeys);
	if(Dump)
	{
		LOG_DEBUG("dictionary size: %d", lKeys);
		for(i=0;i<lKeys;i++)
			LOG_DEBUG("[%4d] [%s]", i, Keys[i]);
	}
	StringArray_Free(&Keys, &lKeys);
	
	Dictionary_Destroy(Dict);
	Dict = NULL;
}


int main(void)
{
	Test_NestedArray(1);
	
	// speed test
	{
		uint32 TickStart, TickElapsed;
		int i, n;
		
		n = 10*1000;
		TickStart = Time_GetTick();
		
		for(i=0;i<n;i++)
			Test_NestedArray(0);
		
		TickElapsed = Time_GetElapsedTick(TickStart);
		
		LOG_DEBUG("total time: %d ms", TickElapsed);
		LOG_DEBUG("time for 1 loop: %d micro-s.", (1000 * TickElapsed) / n);
	}
	return 0;
}
