#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libshred.h>

#include <UnitTest.h>


#define INPUT_STRING_NULL			((void*)0)
#define INPUT_STRING_NULL_CRC32		"00000000"
#define INPUT_STRING_NULL_SQLITE	"?"
#define INPUT_STRING_NULL_MD5		"d41d8cd98f00b204e9800998ecf8427e"
#define INPUT_STRING_NULL_SHA1		"da39a3ee5e6b4b0d3255bfef95601890afd80709"

#define INPUT_STRING_EMPTY			""
#define INPUT_STRING_EMPTY_CRC32	INPUT_STRING_NULL_CRC32
#define INPUT_STRING_EMPTY_SQLITE	INPUT_STRING_NULL_SQLITE
#define INPUT_STRING_EMPTY_MD5		INPUT_STRING_NULL_MD5
#define INPUT_STRING_EMPTY_SHA1		INPUT_STRING_NULL_SHA1

#define INPUT_STRING0			"ix6vh2tjai00bjh111kxql7znxligu6rlp7iczir2ic59p8f2ly1ab60"
#define INPUT_STRING0_CRC32		"1061d0fa"
#define INPUT_STRING0_SQLITE	"4133bc53"
#define INPUT_STRING0_MD5		"f976d61edd4cfb8968658ff774087ba6"
#define INPUT_STRING0_SHA1		"624497892dc1b045c89c50c8ae63ac5161b8d635"

#define INPUT_STRING1			"ieq5kdeaabtcuw0m4e4di50dtld1i49sjhvrris0rduuba81kv40g4glypmj3v23c0qtce6a86"
#define INPUT_STRING1_CRC32		"1cf8a638"
#define INPUT_STRING1_SQLITE	"14b6944b"
#define INPUT_STRING1_MD5		"31e9b1884146e8fb2de9f4fabd989ba1"
#define INPUT_STRING1_SHA1		"f904169cae038e8ed1b22a2110007d6e726f76d2"



// simple macros !
#define TESTCASE_FUNCTION_NAME(type,input) TestSingle_Hash##type##_##input
#define TESTCASE_DECLARE_FUNCTION(type,input) \
int TESTCASE_FUNCTION_NAME(type,input)(void *Param) \
{ \
	return TestSingle_Hash##type##_Core((uint8*)INPUT_##input, strlen((INPUT_##input ? INPUT_##input : "")), INPUT_##input##_##type); \
}


int TestSingle_HashCRC32_Core(uint8 *BufferIn, int lBufferIn, char *ExpectedStringDigest)
{
	char StringDigest[20];
	uint32 Hash;
	
	Hash = Hash_CRC32(BufferIn, lBufferIn);
	Hash_UINT32_DigestToString(Hash, StringDigest);
	//printf("%s\n", StringDigest);
	return (strcmp(StringDigest, ExpectedStringDigest) == 0);
}

int TestSingle_HashSHA1_Core(uint8 *BufferIn, int lBufferIn, char *ExpectedStringDigest)
{
	uint8 RawDigest[SHA1_DIGEST_SIZE];
	char StringDigest[SHA1_DIGEST_STRING_SIZE];
	void *Ctx;
	
	Ctx = Hash_SHA1_Init();
	Hash_SHA1_Update(Ctx, BufferIn, lBufferIn);
	Hash_SHA1_Final(Ctx, RawDigest);
	Hash_SHA1_DigestToString(RawDigest, StringDigest);
	//printf("%s\n", StringDigest);
	return (strcmp(StringDigest, ExpectedStringDigest) == 0);
}

int TestSingle_HashMD5_Core(uint8 *BufferIn, int lBufferIn, char *ExpectedStringDigest)
{
	uint8 RawDigest[MD5_DIGEST_SIZE];
	char StringDigest[MD5_DIGEST_STRING_SIZE];
	void *Ctx;
	
	Ctx = Hash_MD5_Init();
	Hash_MD5_Update(Ctx, BufferIn, lBufferIn);
	Hash_MD5_Final(Ctx, RawDigest);
	Hash_MD5_DigestToString(RawDigest, StringDigest);
	//printf("%s\n", StringDigest);
	return (strcmp(StringDigest, ExpectedStringDigest) == 0);
}


TESTCASE_DECLARE_FUNCTION(SHA1, STRING0);
TESTCASE_DECLARE_FUNCTION(SHA1, STRING1);
TESTCASE_DECLARE_FUNCTION(SHA1, STRING_NULL);
TESTCASE_DECLARE_FUNCTION(SHA1, STRING_EMPTY);

TESTCASE_DECLARE_FUNCTION(MD5, STRING0);
TESTCASE_DECLARE_FUNCTION(MD5, STRING1);
TESTCASE_DECLARE_FUNCTION(MD5, STRING_NULL);
TESTCASE_DECLARE_FUNCTION(MD5, STRING_EMPTY);

TESTCASE_DECLARE_FUNCTION(CRC32, STRING0);
TESTCASE_DECLARE_FUNCTION(CRC32, STRING1);
TESTCASE_DECLARE_FUNCTION(CRC32, STRING_NULL);
TESTCASE_DECLARE_FUNCTION(CRC32, STRING_EMPTY);


int main(void)
{
	int Success = 1;
	
	{
		TTestSuite *TestSuite = TestSuite_Create("HashSHA1");
		
		TestSuite_AddTestCase(TestSuite, "STRING_NULL", NULL, TESTCASE_FUNCTION_NAME(SHA1, STRING_NULL), NULL, 1);
		TestSuite_AddTestCase(TestSuite, "STRING_EMPTY", NULL, TESTCASE_FUNCTION_NAME(SHA1, STRING_EMPTY), NULL, 1);
		TestSuite_AddTestCase(TestSuite, "STRING0", NULL, TESTCASE_FUNCTION_NAME(SHA1, STRING0), NULL, 1);
		TestSuite_AddTestCase(TestSuite, "STRING1", NULL, TESTCASE_FUNCTION_NAME(SHA1, STRING1), NULL, 1);
		Success &= TestSuite_Run(TestSuite);
		
		TestSuite_Destroy(TestSuite);
	}
	
	{
		TTestSuite *TestSuite = TestSuite_Create("HashMD5");
		
		TestSuite_AddTestCase(TestSuite, "STRING_NULL", NULL, TESTCASE_FUNCTION_NAME(MD5, STRING_NULL), NULL, 1);
		TestSuite_AddTestCase(TestSuite, "STRING_EMPTY", NULL, TESTCASE_FUNCTION_NAME(MD5, STRING_EMPTY), NULL, 1);
		TestSuite_AddTestCase(TestSuite, "STRING0", NULL, TESTCASE_FUNCTION_NAME(MD5, STRING0), NULL, 1);
		TestSuite_AddTestCase(TestSuite, "STRING1", NULL, TESTCASE_FUNCTION_NAME(MD5, STRING1), NULL, 1);
		Success &= TestSuite_Run(TestSuite);
		
		TestSuite_Destroy(TestSuite);
	}
	
	{
		TTestSuite *TestSuite = TestSuite_Create("HashCRC32");
		
		TestSuite_AddTestCase(TestSuite, "STRING_NULL", NULL, TESTCASE_FUNCTION_NAME(CRC32, STRING_NULL), NULL, 1);
		TestSuite_AddTestCase(TestSuite, "STRING_EMPTY", NULL, TESTCASE_FUNCTION_NAME(CRC32, STRING_EMPTY), NULL, 1);
		TestSuite_AddTestCase(TestSuite, "STRING0", NULL, TESTCASE_FUNCTION_NAME(CRC32, STRING0), NULL, 1);
		TestSuite_AddTestCase(TestSuite, "STRING1", NULL, TESTCASE_FUNCTION_NAME(CRC32, STRING1), NULL, 1);
		Success &= TestSuite_Run(TestSuite);
		
		TestSuite_Destroy(TestSuite);
	}
	
	return (Success == 0);
}
