#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef WIN32
#include <fcntl.h>
#include <io.h>
#endif

#include <libshred.h>


#define MAX_BUFFER_SIZE	(1024 * 1024)


int Cmd_Decode(char **Args, int nArgs)
{
	char *Input = NULL;
	TCliParserOption Options[] = {
		{"-i", "--input", "input", "string:string,stdin:", &Input, ARG_TYPE_STRING, 1},
		{NULL,	NULL,	NULL, NULL, 0, 0}
	};
	char **Array;
	int lArray, DoFile = 0, DoString = 0, DoStdin = 0;
	
	
	if(!CliParser_DoOptions(Options, Args, nArgs))
		return 0;
	
	if(!String_Split(Input, ':', &Array, &lArray) || !Array || lArray != 2)
	{
		printf("error: malformed input argument '%s'\n", Input);
		return 0;
	}
	
	if(strcmp(Array[0], "file") == 0)
		DoFile = 1;
	
	if(strcmp(Array[0], "string") == 0)
		DoString = 1;
	
	if(strcmp(Array[0], "stdin") == 0)
		DoStdin = 1;
	
#ifdef WIN32
	_setmode(_fileno(stdout), _O_BINARY);
#endif
	
	if(DoString)
	{
		int lB64, szBuffer;
		uint8 *Buffer, *B64;	
		
		Buffer = (uint8*)Array[1];
		szBuffer = strlen((char*)Buffer);
		
		if(szBuffer >= MAX_BUFFER_SIZE)
		{
			printf("error: string size exceeded: %d/%d bytes\n", szBuffer, MAX_BUFFER_SIZE);
			return -1;
		}
		
		B64 = NULL;
		lB64 = 0;
		if(!String_Base64Decode((char*)Buffer, szBuffer, &B64, &lB64))
		{
			printf("error: String_Base64Decode()\n");
			return -1;
		}
		
		fwrite(B64, 1, lB64, stdout);
		fprintf(stdout, "\n");
		
		if(B64)
			free(B64);
	}
	else if(DoFile || DoStdin)
	{
		FILE *File;
		int lB64, szBuffer, lBuffer;
		uint8 *Buffer, *B64;	
		
		
		if(DoFile)
		{
			char *Filename = Array[1];
			
			File = fopen(Filename, "r");
			if(!File)
			{
				printf("error: opening file '%s'\n", Filename);
				return -1;
			}
		}
		else
		{
			File = stdin;
		}
		
		szBuffer = 1024;
		Buffer = malloc(szBuffer);
		B64 = NULL;
		lB64 = 0;
		
		while(!feof(File))
		{
			if(!fgets((char*)Buffer, szBuffer, File))
				break;
			
			lBuffer = String_Trim((char*)Buffer);
			
			if(!String_Base64Decode((char*)Buffer, lBuffer, &B64, &lB64))
				return -1;
			
			fwrite(B64, 1, lB64, stdout);
		}
		
		if(B64)
			free(B64);
		
		if(Buffer)
			free(Buffer);
		
		if(DoFile)
			fclose(File);
	}
	
	StringArray_Free(&Array, &lArray);
	
	return 1;
}


int Cmd_Encode(char **Args, int nArgs)
{
	char *Input = NULL;
	TCliParserOption Options[] = {
		{"-i", "--input", "input", "file:filename,string:string,stdin:", &Input, ARG_TYPE_STRING, 1},
		{NULL,	NULL,	NULL, NULL, 0, 0}
	};
	char **Array;
	int lArray, DoFile = 0, DoString = 0, DoStdin = 0;
	
	
	if(!CliParser_DoOptions(Options, Args, nArgs))
		return 0;
	
	if(!String_Split(Input, ':', &Array, &lArray) || !Array || lArray != 2)
	{
		printf("error: malformed input argument '%s'\n", Input);
		return 0;
	}
	
	if(strcmp(Array[0], "file") == 0)
		DoFile = 1;
	
	if(strcmp(Array[0], "string") == 0)
		DoString = 1;
	
	if(strcmp(Array[0], "stdin") == 0)
		DoStdin = 1;
	
#ifdef WIN32
	_setmode(_fileno(stdout), _O_BINARY);
#endif
	
	if(DoFile || DoStdin)
	{
		FILE *File;
		int lB64, szBuffer, szRead;
		uint8 *Buffer;
		char *B64;	
		
		
		if(DoFile)
		{
			char *Filename = Array[1];
			
			File = fopen(Filename, "rb");
			if(!File)
			{
				printf("error: opening file '%s'\n", Filename);
				return -1;
			}
		}
		else
		{
#ifdef WIN32
			_setmode(_fileno(stdin), _O_BINARY);
#endif
			File = stdin;
		}
		
		//	N3q8ryccAALqs8yh9gkWAAAAAAAlAAAAAAAAAHNSoKcAEej/QUw8IX9r8DSed0RGIEq/wDo9N7L9
		szBuffer = String_Base64EncodeInputSize(76);	// as for mail
		Buffer = malloc(szBuffer);
		B64 = malloc(80);
		
		while(!feof(File))
		{
			szRead = fread(Buffer, 1, szBuffer, File);
			if(szRead <= 0)
				break;
			
			lB64 = 80;
			if(!String_Base64Encode(Buffer, szRead, &B64, &lB64))
				return -1;
			
			fwrite(B64, 1, lB64, stdout);
			fprintf(stdout, "\n");
		}
		free(B64);
		
		if(Buffer)
			free(Buffer);
		
		if(DoFile)
			fclose(File);
	}
	else if(DoString)
	{
		int lB64, szBuffer;
		uint8 *Buffer;
		char *B64;	
		
		
		Buffer = (uint8*)Array[1];
		szBuffer = strlen((char*)Buffer);
		
		if(szBuffer >= MAX_BUFFER_SIZE)
		{
			printf("error: string size exceeded: %d/%d bytes\n", szBuffer, MAX_BUFFER_SIZE);
			return -1;
		}
		
		// we must set the parameters accordingly...
		B64 = NULL;
		lB64 = 0;
		if(!String_Base64Encode(Buffer, szBuffer, &B64, &lB64))
			return -1;
		
		fwrite(B64, 1, lB64, stdout);
		fprintf(stdout, "\n");
		
		if(B64)
			free(B64);
	}
	else
	{
		printf("error: invalid argument '%s'\n", Array[0]);
		return -1;
	}
	
	StringArray_Free(&Array, &lArray);
	
	return 0;
}


int main(int nArgs, char **Args)
{
	TCliParserCommand Commands[] = {
		{"encode", Cmd_Encode},
		{"decode", Cmd_Decode},
		{NULL, NULL}
	};
	
	return CliParser_DoCommands(Commands, Args + 1, nArgs - 1, Args[0]);
}
