#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libshred.h>


int MKFile(int ID, int iPadding, char *Prefix, uint8 *Buffer, int szBuffer)
{
	char Filename[256];
	char Format[64];
	
	
	// we want format to be %s%06d
	snprintf(Format, sizeof(Format) - 1, "%%s%%0%dd", iPadding);
	snprintf(Filename, sizeof(Filename) - 1, Format, Prefix, ID);
	//printf("%s\n", Filename);
	return FileSystem_BufferToFile(Buffer, szBuffer, Filename);
}


int main(int nArgs, char **Args)
{
	int FileSize = 0;
	int Number = 0;
	char *Prefix = "";
	int DoRandom = 0;
	TCliParserOption Options[] = {
		{"-s", "--size", "file size (in octet)", "1024", &FileSize, ARG_TYPE_INT, 1},
		{"-n", "--number", "number of file to write", "100", &Number, ARG_TYPE_INT, 1},
		{"-p", "--prefix", "prefix of files", "prefix-", &Prefix, ARG_TYPE_STRING, 0},
		{"-r", "--random", "store random data into files", "", &DoRandom, ARG_TYPE_FLAG, 0},
		{NULL,	NULL,	NULL, NULL, 0, 0}
	};
	uint8 *Buffer = NULL;
	int i, iPadding;
	
	
	if(!CliParser_DoOptions(Options, Args + 1, nArgs - 1))
		return 0;
	
	if(FileSize <= 0)
	{
		printf("error: invalid file size\n");
		return 0;
	}
	if(Number <= 0)
	{
		printf("error: invalid file number\n");
		return 0;
	}
	
	Buffer = malloc(FileSize);
	memset(Buffer, 0, FileSize);
	{
		int k;
		
		iPadding = 0;
		k = Number - 1;
		while(k > 0)
		{
			k /= 10;
			iPadding++;
		}
	}
	
	if(DoRandom)
	{
		uint32 k = Random_PRNG();
		for(i=0;i<FileSize;i++)
			Buffer[i] = (uint8)(((k & 0x000000ff) * ((i ^ 3) + 7) ^ i) % 256);
	}
	
	for(i=0;i<Number;i++)
	{
		if(i % 10 == 0)
			printf("writing file %d/%d\r", i + 1, Number);
		
		if(DoRandom)
		{
			uint8 k = Buffer[0];
			int j;
			
			for(j=0;j<FileSize;j++)
				Buffer[j] ^= (uint8)((k * (j + 1) * 13) % 256);
		}
		MKFile(i, iPadding, Prefix, Buffer, FileSize);
	}
	
	free(Buffer);
	
	printf("written %d files of %d bytes\n", Number, FileSize);
	
	return 0;
}
