#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libshred.h>


int main(void)
{
	TProcessInfo *ProcessList = NULL;
	int i, j, lProcessList = 0;
	
	if(System_GetProcessList(&ProcessList, &lProcessList))
	{
		for(i=0;i<lProcessList;i++)
		{
			TProcessInfo *pProcess = &ProcessList[i];
			char SepLeft, SepRight;
			
			SepLeft = '[';
			SepRight = ']';
			if(pProcess->IsKernelModule)
			{
				SepLeft = '<';
				SepRight = '>';
			}
			
			LOG_DEBUG("%c%d%c", SepLeft, pProcess->PID, SepRight);
			LOG_DEBUG("  Name:            %s", pProcess->Name);
			LOG_DEBUG("  PID:             %d", pProcess->PID);
			LOG_DEBUG("  ParentPID:       %d", pProcess->ParentPID);
			LOG_DEBUG("  nThreads:        %d", pProcess->nThreads);
			LOG_DEBUG("  State:           %s", pProcess->State);
			LOG_DEBUG("  CmdLine:         (%d)", pProcess->CmdLine.lArgs);
			for(j=0;j<pProcess->CmdLine.lArgs;j++)
				LOG_DEBUG("    [%s]", pProcess->CmdLine.Args[j]);
		}
	}
	System_DestroyProcessList(ProcessList, lProcessList);
	
	return 0;
}
