#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libshred.h>


int main(int nArgs, char **Args)
{
	int DoUTC = 0;
	int DoDate = 0;
	TCliParserOption Options[] = {
		{"-u", "--utc", "work in UTC (don't convert to local time)", "", &DoUTC, ARG_TYPE_FLAG, 0},
		{"-d", "--date", "show date instead of timestamp", "", &DoDate, ARG_TYPE_FLAG, 0},
		{NULL,	NULL,	NULL, NULL, 0, 0}
	};
	uint32 Sec, MicroSec;
	
	if(!CliParser_DoOptions(Options, Args + 1, nArgs - 1))
		return 0;
	
	if(!DoDate)
	{
		Time_GetTimestamp(&Sec, &MicroSec);
		printf("%u.%03u\n", Sec, MicroSec / 1000);
	}
	else
	{
		char TimeString[64];
		TTime Time;
		
		if(DoUTC)
			Time_GetUTCTime(&Time);
		else
			Time_GetLocalTime(&Time);
		
		snprintf(TimeString, sizeof(TimeString), "%04d/%02d/%02d %02d:%02d:%02d.%03d", Time.Year, Time.Month, Time.Day, Time.Hour, Time.Minute, Time.Second, Time.Milliseconds);
		printf("%s\n", TimeString);
	}
	
	return 0;
}
