/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/list.h>
#include <linux/device.h>
#include <linux/slab.h>
#include <linux/string.h>
#include <linux/sysdev.h>
#include <asm/mach/time.h>
#include <linux/clocksource.h>
#include <linux/ata_platform.h>
#include <mach/hardware.h>
#include <mach/feroceon-kw.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/setup.h>
#include <asm/mach-types.h>

#include <asm/mach/arch.h>
#include <asm/mach/flash.h>
#include <asm/mach/irq.h>
#include <asm/mach/map.h>
#include <mach/system.h>

#include <linux/tty.h>
#include <linux/platform_device.h>
#include <linux/serial_core.h>
#include <linux/serial.h>
#include <linux/serial_8250.h>
#include <linux/serial_reg.h>
#include <linux/mv643xx_eth.h>
#include <linux/spi/orion_spi.h>
#include <asm/serial.h>
#include <plat/cache-feroceon-l2.h>

#include <mach/serial.h>

#include "ctrlEnv/mvCtrlEnvLib.h"
#include "ctrlEnv/sys/mvCpuIf.h"
#include "boardEnv/mvBoardEnvLib.h"
#include "mvDebug.h"
#include "mvSysHwConfig.h"
#include "pex/mvPexRegs.h"
#include "cntmr/mvCntmr.h"
#include "gpp/mvGpp.h"
#include "plat/gpio.h"

#if defined(CONFIG_MV_INCLUDE_SDIO)
#include "ctrlEnv/sys/mvSysSdmmc.h"
#include <plat/mvsdio.h>
#endif
#if defined(CONFIG_MV_INCLUDE_CESA)
#include "cesa/mvCesa.h"
#endif
#if defined(CONFIG_MV_INCLUDE_AUDIO)
#include <plat/i2s-orion.h>
#endif

#include <plat/orion_nand.h>
#include <plat/orion_wdt.h>
#include <plat/mv_xor.h>

/* I2C */
#include <linux/i2c.h>	
#include <linux/mv643xx_i2c.h>
#include "ctrlEnv/mvCtrlEnvSpec.h"

#include "core.h"
#include "mpp.h"

/* for debug putstr */
#include <mach/uncompress.h> 
static char arr[256];

#ifdef MV_INCLUDE_EARLY_PRINTK
extern void putstr(const char *ptr);
void mv_early_printk(char *fmt,...)
{
	va_list args;
	va_start(args, fmt);
	vsprintf(arr,fmt,args);
	va_end(args);
	putstr(arr);
}
#endif

extern MV_CPU_DEC_WIN* mv_sys_map(void);

#if defined(CONFIG_MV_INCLUDE_CESA)
extern u32 mv_crypto_base_get(void);
#endif
unsigned int support_wait_for_interrupt = 0x1;

u32 mvTclk = 166666667;
u32 mvSysclk = 200000000;
u32 mvIsUsbHost = 1;


#ifdef CONFIG_MV_ETHERNET
u8	mvMacAddr[CONFIG_MV_ETH_PORTS_NUM][6];
u16	mvMtu[CONFIG_MV_ETH_PORTS_NUM] = {0};
#endif
extern MV_U32 gBoardId; 
extern unsigned int elf_hwcap;

#ifdef CONFIG_MV_NAND
extern unsigned int mv_nand_ecc;
#endif
 
static int __init parse_tag_mv_uboot(const struct tag *tag)
{
    	unsigned int mvUbootVer = 0;
	int i = 0;
 
	mvUbootVer = tag->u.mv_uboot.uboot_version;
	mvIsUsbHost = tag->u.mv_uboot.isUsbHost;
	mvTclk = tag->u.mv_uboot.tclk;
	mvSysclk = tag->u.mv_uboot.sysclk;

        printk("Using UBoot passing parameters structure\n");
  
	gBoardId =  (mvUbootVer & 0xff);
#ifdef CONFIG_MV_ETHERNET
	for (i = 0; i < CONFIG_MV_ETH_PORTS_NUM; i++) {
#if defined (CONFIG_OVERRIDE_ETH_CMDLINE)
		memset(mvMacAddr[i], 0, 6);
		mvMtu[i] = 0;
#else			
		memcpy(mvMacAddr[i], tag->u.mv_uboot.macAddr[i], 6);
		mvMtu[i] = tag->u.mv_uboot.mtu[i];
#endif
	}
#endif /* CONFIG_MV_ETHERNET */
#ifdef CONFIG_MV_NAND
               /* get NAND ECC type(1-bit or 4-bit) */
               if((mvUbootVer >> 8) >= 0x3040c)
                       mv_nand_ecc = tag->u.mv_uboot.nand_ecc;
               else
                       mv_nand_ecc = 1; /* fallback to 1-bit ECC */
#endif  
	return 0;
}
                                                                                                                             
__tagtable(ATAG_MV_UBOOT, parse_tag_mv_uboot);

#ifdef CONFIG_MV_INCLUDE_CESA
unsigned char*  mv_sram_usage_get(int* sram_size_ptr)
{
    int used_size = 0;

#if defined(CONFIG_MV_CESA)
    used_size = sizeof(MV_CESA_SRAM_MAP);
#endif

    if(sram_size_ptr != NULL)
        *sram_size_ptr = _8K - used_size;

    return (char *)(mv_crypto_base_get() + used_size);
}
#endif


void print_board_info(void)
{
    char name_buff[50];
    printk("\n  Marvell Development Board (LSP Version %s)",LSP_VERSION);

    mvBoardNameGet(name_buff);
    printk("-- %s ",name_buff);

    mvCtrlModelRevNameGet(name_buff);
    printk(" Soc: %s",  name_buff);
#if defined(MV_CPU_LE)
	printk(" LE");
#else
	printk(" BE");
#endif
    printk("\n\n");
    printk(" Detected Tclk %d and SysClk %d \n",mvTclk, mvSysclk);
}

/*****************************************************************************
 * I/O Address Mapping
 ****************************************************************************/
static struct map_desc feroceon_kw_io_desc[] __initdata = {
	{
		.virtual	= FEROCEON_KW_PCIE_IO_VIRT_BASE,
		.pfn		= __phys_to_pfn(FEROCEON_KW_PCIE_IO_PHYS_BASE),
		.length		= FEROCEON_KW_PCIE_IO_SIZE,
		.type		= MT_DEVICE,
	}, {
		.virtual	= FEROCEON_KW_PCIE1_IO_VIRT_BASE,
		.pfn		= __phys_to_pfn(FEROCEON_KW_PCIE1_IO_PHYS_BASE),
		.length		= FEROCEON_KW_PCIE1_IO_SIZE,
		.type		= MT_DEVICE,
	}, {
		.virtual	= FEROCEON_KW_REGS_VIRT_BASE,
		.pfn		= __phys_to_pfn(FEROCEON_KW_REGS_PHYS_BASE),
		.length		= FEROCEON_KW_REGS_SIZE,
		.type		= MT_DEVICE,
	},
};

void __init feroceon_kw_map_io(void)
{
	iotable_init(feroceon_kw_io_desc, ARRAY_SIZE(feroceon_kw_io_desc));
}

/*****************************************************************************
 * SPI
 ****************************************************************************/
static struct orion_spi_info feroceon_kw_spi_plat_data;

static struct resource feroceon_kw_spi_resources[] = {
	{
		.start	= SPI_PHYS_BASE,
		.end	= SPI_PHYS_BASE + SZ_512 - 1,
		.flags	= IORESOURCE_MEM,
	},
};

static struct platform_device feroceon_kw_spi = {
	.name		= "orion_spi",
	.id		= 0,
	.resource	= feroceon_kw_spi_resources,
	.dev		= {
		.platform_data	= &feroceon_kw_spi_plat_data,
	},
	.num_resources	= ARRAY_SIZE(feroceon_kw_spi_resources),
};

void __init feroceon_kw_spi_init()
{
#if 0
	feroceon_kw_clk_ctrl |= CGC_RUNIT;
#endif
	feroceon_kw_spi_plat_data.tclk = mvTclk;
	platform_device_register(&feroceon_kw_spi);
}

/*****************************************************************************
 * I2C(TWSI)
 ****************************************************************************/

/*Platform devices list*/

static struct mv64xxx_i2c_pdata kw_i2c_pdata = {
       .freq_m         = 8, /* assumes 166 MHz TCLK */
       .freq_n         = 3,
       .timeout        = 1000, /* Default timeout of 1 second */
};

static struct resource kw_i2c_resources[] = {
       {
               .name   = "i2c base",
               .start  = INTER_REGS_BASE + TWSI_SLAVE_ADDR_REG(0),
               .end    = INTER_REGS_BASE + TWSI_SLAVE_ADDR_REG(0) + 0x20 -1,
               .flags  = IORESOURCE_MEM,
       },
       {
               .name   = "i2c irq",
               .start  = IRQ_TWSI,
               .end    = IRQ_TWSI,
               .flags  = IORESOURCE_IRQ,
       },
};

static struct platform_device kw_i2c = {
       .name           = MV64XXX_I2C_CTLR_NAME,
       .id             = 0,
       .num_resources  = ARRAY_SIZE(kw_i2c_resources),
       .resource       = kw_i2c_resources,
       .dev            = {
               .platform_data = &kw_i2c_pdata,
       },
};

/*****************************************************************************
 * UART
 ****************************************************************************/
static struct resource mv_uart0_resources[] = {
	{
		.start		= PORT0_BASE,
		.end		= PORT0_BASE + 0xff,
		.flags		= IORESOURCE_MEM,
	},
	{
		.start          = IRQ_UART0,
		.end            = IRQ_UART0,
		.flags          = IORESOURCE_IRQ,
	},
};

static struct resource mv_uart1_resources[] = {
	{
		.start		= PORT1_BASE,
		.end		= PORT1_BASE + 0xff,
		.flags		= IORESOURCE_MEM,
	},
	{
		.start          = IRQ_UART1,
		.end            = IRQ_UART1,
		.flags          = IORESOURCE_IRQ,
	},
};

static struct plat_serial8250_port mv_uart0_data[] = {
	{
		.mapbase	= PORT0_BASE,
		.membase	= (char *)PORT0_BASE,
		.irq		= IRQ_UART0,
		.flags		= UPF_SKIP_TEST | UPF_BOOT_AUTOCONF,
		.iotype		= UPIO_MEM,
		.regshift	= 2,
	},
	{ },
};

static struct plat_serial8250_port mv_uart1_data[] = {
	{
		.mapbase	= PORT1_BASE,
		.membase	= (char *)PORT1_BASE,
		.irq		= IRQ_UART1,
		.flags		= UPF_SKIP_TEST | UPF_BOOT_AUTOCONF,
		.iotype		= UPIO_MEM,
		.regshift	= 2,
	},
	{ },
};

static struct platform_device mv_uart = {
	.name			= "serial8250",
	.id			= PLAT8250_DEV_PLATFORM,
	.dev			= {
		.platform_data	= mv_uart0_data,
	},
	.num_resources		= 2, /*ARRAY_SIZE(mv_uart_resources),*/
	.resource		= mv_uart0_resources,
};


static void serial_initialize(void)
{
	mv_uart0_data[0].uartclk = mv_uart1_data[0].uartclk = mvTclk;
	if(mvBoardIdGet() == DB_88F6280A_BP_ID)
	{
		mv_uart.dev.platform_data = mv_uart1_data;
		mv_uart.resource = mv_uart1_resources;
	}
	platform_device_register(&mv_uart);
}

#ifdef CONFIG_MV_INCLUDE_AUDIO

/*****************************************************************************
 * I2S/SPDIF
 ****************************************************************************/
static struct resource mv_i2s_resources[] = {
	[0] = {
		.start	= INTER_REGS_BASE + AUDIO_REG_BASE(0),
		.end	= INTER_REGS_BASE + AUDIO_REG_BASE(0) + SZ_16K -1,
		.flags	= IORESOURCE_MEM,
	},
	[1] = {
		.start	= IRQ_AUDIO_INT,
		.end	= IRQ_AUDIO_INT,
		.flags	= IORESOURCE_IRQ,
	},
};

static u64 mv_i2s0_dmamask = 0xFFFFFFFFUL;

static struct orion_i2s_platform_data mv_i2s_plat_data = {
	.dram	= NULL,
	.spdif_rec = 1,
	.spdif_play = 1,
	.i2s_rec = 1,
	.i2s_play = 1,
};


static struct platform_device mv_i2s = {
	.name           = "mv88fx_snd",
	.id             = 0,
	.dev            = {
		.dma_mask = &mv_i2s0_dmamask,
		.coherent_dma_mask = 0xFFFFFFFF,
		.platform_data	= &mv_i2s_plat_data,
	},
	.num_resources  = ARRAY_SIZE(mv_i2s_resources),
	.resource       = mv_i2s_resources,
};

static struct platform_device mv_mv88fx_i2s = {
	.name           = "mv88fx-i2s",
	.id             = -1,
};

/*****************************************************************************
 * A2D on I2C bus
 ****************************************************************************/
static struct i2c_board_info __initdata i2c_a2d = {
	I2C_BOARD_INFO("i2s_i2c", 0x4A),
};

void __init mv_i2s_init(void)
{
	platform_device_register(&mv_mv88fx_i2s);
	platform_device_register(&mv_i2s);
	return;
}



#endif /* #ifdef CONFIG_MV_INCLUDE_AUDIO */

#if defined(CONFIG_MV_INCLUDE_SDIO)

static struct resource mvsdio_resources[] = {
	[0] = {
		.start	= INTER_REGS_BASE + MV_SDIO_REG_BASE,
		.end	= INTER_REGS_BASE + MV_SDIO_REG_BASE + SZ_1K -1,
		.flags	= IORESOURCE_MEM,
	},
	[1] = {
		.start	= SDIO_IRQ_NUM,
		.end	= SDIO_IRQ_NUM,
		.flags	= IORESOURCE_IRQ,
	},

};

static u64 mvsdio_dmamask = 0xffffffffUL;

static struct mvsdio_platform_data mvsdio_data = {
	.gpio_write_protect	= 0,
	.gpio_card_detect	= 0,
	.dram			= NULL,
};

static struct platform_device mv_sdio_plat = {
	.name		= "mvsdio",
	.id		= -1,
	.dev		= {
		.dma_mask = &mvsdio_dmamask,
		.coherent_dma_mask = 0xffffffff,
		.platform_data	= &mvsdio_data,
	},
	.num_resources	= ARRAY_SIZE(mvsdio_resources),
	.resource	= mvsdio_resources,
};


#endif /* #if defined(CONFIG_MV_INCLUDE_SDIO) */

#ifdef CONFIG_MV_ETHERNET
/*****************************************************************************
 * Ethernet
 ****************************************************************************/
static struct platform_device mv88fx_eth = {
	.name		= "mv88fx_eth",
	.id		= 0,
	.num_resources	= 0,
};
#endif

#ifdef CONFIG_MV643XX_ETH
/*****************************************************************************
 * GE00
 ****************************************************************************/
struct mv643xx_eth_shared_platform_data feroceon_kw_ge00_shared_data = {
	.dram		= &feroceon_kw_mbus_dram_info,
};

static struct resource feroceon_kw_ge00_shared_resources[] = {
	{
		.name	= "ge00 base",
		.start	= GE00_PHYS_BASE + 0x2000,
		.end	= GE00_PHYS_BASE + 0x3fff,
		.flags	= IORESOURCE_MEM,
	}, {
		.name	= "ge00 err irq",
		.start	= IRQ_ETH_ERR(0),
		.end	= IRQ_ETH_ERR(0),
		.flags	= IORESOURCE_IRQ,
	},
};

static struct platform_device feroceon_kw_ge00_shared = {
	.name		= MV643XX_ETH_SHARED_NAME,
	.id		= 0,
	.dev		= {
		.platform_data	= &feroceon_kw_ge00_shared_data,
	},
	.num_resources	= ARRAY_SIZE(feroceon_kw_ge00_shared_resources),
	.resource	= feroceon_kw_ge00_shared_resources,
};

static struct resource feroceon_kw_ge00_resources[] = {
	{
		.name	= "ge00 irq",
		.start	= ETH_PORT_IRQ_NUM(0),
		.end	= ETH_PORT_IRQ_NUM(0),
		.flags	= IORESOURCE_IRQ,
	},
};

static struct platform_device feroceon_kw_ge00 = {
	.name		= MV643XX_ETH_NAME,
	.id		= 0,
	.num_resources	= 1,
	.resource	= feroceon_kw_ge00_resources,
	.dev		= {
		.coherent_dma_mask	= 0xffffffff,
	},
};

void __init feroceon_kw_ge00_init(struct mv643xx_eth_platform_data *eth_data)
{
#if 0
	feroceon_kw_clk_ctrl |= (1 << 0) /* CGC_GE0 */;
#endif
	feroceon_kw_ge00_shared_data.t_clk = mvTclk;

	eth_data->shared = &feroceon_kw_ge00_shared;
	feroceon_kw_ge00.dev.platform_data = eth_data;

	platform_device_register(&feroceon_kw_ge00_shared);
	platform_device_register(&feroceon_kw_ge00);
}


/*****************************************************************************
 * GE01
 ****************************************************************************/
struct mv643xx_eth_shared_platform_data feroceon_kw_ge01_shared_data = {
	.dram		= &feroceon_kw_mbus_dram_info,
	.shared_smi	= &feroceon_kw_ge00_shared,
};

static struct resource feroceon_kw_ge01_shared_resources[] = {
	{
		.name	= "ge01 base",
		.start	= GE01_PHYS_BASE + 0x2000,
		.end	= GE01_PHYS_BASE + 0x3fff,
		.flags	= IORESOURCE_MEM,
	}, {
		.name	= "ge01 err irq",
		.start	= IRQ_ETH_ERR(1),
		.end	= IRQ_ETH_ERR(1),
		.flags	= IORESOURCE_IRQ,
	},
};

static struct platform_device feroceon_kw_ge01_shared = {
	.name		= MV643XX_ETH_SHARED_NAME,
	.id		= 1,
	.dev		= {
		.platform_data	= &feroceon_kw_ge01_shared_data,
	},
	.num_resources	= ARRAY_SIZE(feroceon_kw_ge01_shared_resources),
	.resource	= feroceon_kw_ge01_shared_resources,
};

static struct resource feroceon_kw_ge01_resources[] = {
	{
		.name	= "ge01 irq",
		.start	= ETH_PORT_IRQ_NUM(1),
		.end	= ETH_PORT_IRQ_NUM(1),
		.flags	= IORESOURCE_IRQ,
	},
};

static struct platform_device feroceon_kw_ge01 = {
	.name		= MV643XX_ETH_NAME,
	.id		= 1,
	.num_resources	= 1,
	.resource	= feroceon_kw_ge01_resources,
	.dev		= {
		.coherent_dma_mask	= 0xffffffff,
	},
};

void __init feroceon_kw_ge01_init(struct mv643xx_eth_platform_data *eth_data)
{
#if 0
	feroceon_kw_clk_ctrl |= (1 << 19) /* CGC_GE1 */;
#endif
	feroceon_kw_ge01_shared_data.t_clk = mvTclk;

	eth_data->shared = &feroceon_kw_ge01_shared;
	feroceon_kw_ge01.dev.platform_data = eth_data;

	platform_device_register(&feroceon_kw_ge01_shared);
	platform_device_register(&feroceon_kw_ge01);
}
#endif /* CONFIG_MV643XX_ETH */

static void __init kirkwood_l2_init(void)
{
#ifdef CONFIG_CACHE_FEROCEON_L2_WRITETHROUGH
	MV_REG_BIT_SET(CPU_L2_CONFIG_REG, 0x10);
	feroceon_l2_init(1);
#else
	MV_REG_BIT_RESET(CPU_L2_CONFIG_REG, 0x10);
	feroceon_l2_init(0);
#endif
}

/*****************************************************************************
 * WATCHDOG
 ****************************************************************************/

/* the orion watchdog device data structure */
static struct orion_wdt_platform_data mv_wdt_data = {
	.tclk		= 0,
};

/* the watchdog device structure */
static struct platform_device mv_wdt_device = {
	.name		= "orion_wdt",
	.id		= -1,
	.dev		= {
		.platform_data	= &mv_wdt_data,
	},
	.num_resources	= 0,
};

/* init the watchdog device */
static void __init mv_wdt_init(void)
{
	mv_wdt_data.tclk = mvTclk;
	platform_device_register(&mv_wdt_device);
}

/*****************************************************************************
 * SoC RTC
 ****************************************************************************/
static struct resource feroceon_kw_rtc_resource = {
	.start	= RTC_PHYS_BASE,
	.end	= RTC_PHYS_BASE + SZ_16 - 1,
	.flags	= IORESOURCE_MEM,
};

static void __init feroceon_kw_rtc_init(void)
{
	platform_device_register_simple("rtc-mv", -1,
					&feroceon_kw_rtc_resource, 1);
}

/*****************************************************************************
 * NAND
 ****************************************************************************/
static struct resource feroceon_kw_nand_resource = {
	.flags		= IORESOURCE_MEM,
	.start		= FEROCEON_KW_NAND_MEM_PHYS_BASE,
	.end		= FEROCEON_KW_NAND_MEM_PHYS_BASE +
				FEROCEON_KW_NAND_MEM_SIZE - 1,
};

static struct orion_nand_data feroceon_kw_nand_data = {
	.cle		= 0,
	.ale		= 1,
	.width		= 8,
};

static struct platform_device feroceon_kw_nand_flash = {
	.name		= "orion_nand",
	.id		= -1,
	.dev		= {
		.platform_data	= &feroceon_kw_nand_data,
	},
	.resource	= &feroceon_kw_nand_resource,
	.num_resources	= 1,
};

void __init feroceon_kw_nand_init(struct mtd_partition *parts, int nr_parts,
				  int chip_delay)
{
#if 0
	feroceon_kw_clk_ctrl |= CGC_RUNIT;
#endif
	feroceon_kw_nand_data.parts = parts;
	feroceon_kw_nand_data.nr_parts = nr_parts;
	feroceon_kw_nand_data.chip_delay = chip_delay;
	platform_device_register(&feroceon_kw_nand_flash);
}

#ifdef CONFIG_SATA_MV
/*****************************************************************************
 * SATA
 ****************************************************************************/
static struct resource feroceon_kw_sata_resources[] = {
	{
		.name	= "sata base",
		.start	= SATA_PHYS_BASE,
		.end	= SATA_PHYS_BASE + 0x5000 - 1,
		.flags	= IORESOURCE_MEM,
	}, {
		.name	= "sata irq",
		.start	= SATA_IRQ_NUM,
		.end	= SATA_IRQ_NUM,
		.flags	= IORESOURCE_IRQ,
	},
};

static struct platform_device feroceon_kw_sata = {
	.name		= "sata_mv",
	.id		= 0,
	.dev		= {
		.coherent_dma_mask	= 0xffffffff,
	},
	.num_resources	= ARRAY_SIZE(feroceon_kw_sata_resources),
	.resource	= feroceon_kw_sata_resources,
};

void __init feroceon_kw_sata_init(struct mv_sata_platform_data *sata_data)
{
#if 0
	feroceon_kw_clk_ctrl |= CGC_SATA0;
	if (sata_data->n_ports > 1)
		feroceon_kw_clk_ctrl |= CGC_SATA1;
#endif
	sata_data->dram = &feroceon_kw_mbus_dram_info;
	feroceon_kw_sata.dev.platform_data = sata_data;
	platform_device_register(&feroceon_kw_sata);
}
#endif /* CONFIG_SATA_MV */

#ifdef CONFIG_MV_XOR
/*****************************************************************************
 * XOR
 ****************************************************************************/
static struct mv_xor_platform_shared_data feroceon_kw_xor_shared_data = {
	.dram		= &feroceon_kw_mbus_dram_info,
};

static u64 feroceon_kw_xor_dmamask = DMA_BIT_MASK(32);


/*****************************************************************************
 * XOR0
 ****************************************************************************/
static struct resource feroceon_kw_xor0_shared_resources[] = {
	{
		.name	= "xor 0 low",
		.start	= XOR0_PHYS_BASE,
		.end	= XOR0_PHYS_BASE + 0xff,
		.flags	= IORESOURCE_MEM,
	}, {
		.name	= "xor 0 high",
		.start	= XOR0_HIGH_PHYS_BASE,
		.end	= XOR0_HIGH_PHYS_BASE + 0xff,
		.flags	= IORESOURCE_MEM,
	},
};

static struct platform_device feroceon_kw_xor0_shared = {
	.name		= MV_XOR_SHARED_NAME,
	.id		= 0,
	.dev		= {
		.platform_data = &feroceon_kw_xor_shared_data,
	},
	.num_resources	= ARRAY_SIZE(feroceon_kw_xor0_shared_resources),
	.resource	= feroceon_kw_xor0_shared_resources,
};

static struct resource feroceon_kw_xor00_resources[] = {
	[0] = {
		.start	= IRQ_FEROCEON_KW_XOR_00,
		.end	= IRQ_FEROCEON_KW_XOR_00,
		.flags	= IORESOURCE_IRQ,
	},
};

static struct mv_xor_platform_data feroceon_kw_xor00_data = {
	.shared		= &feroceon_kw_xor0_shared,
	.hw_id		= 0,
	.pool_size	= PAGE_SIZE,
};

static struct platform_device feroceon_kw_xor00_channel = {
	.name		= MV_XOR_NAME,
	.id		= 0,
	.num_resources	= ARRAY_SIZE(feroceon_kw_xor00_resources),
	.resource	= feroceon_kw_xor00_resources,
	.dev		= {
		.dma_mask		= &feroceon_kw_xor_dmamask,
		.coherent_dma_mask	= DMA_BIT_MASK(64),
		.platform_data		= (void *)&feroceon_kw_xor00_data,
	},
};

static struct resource feroceon_kw_xor01_resources[] = {
	[0] = {
		.start	= IRQ_FEROCEON_KW_XOR_01,
		.end	= IRQ_FEROCEON_KW_XOR_01,
		.flags	= IORESOURCE_IRQ,
	},
};

static struct mv_xor_platform_data feroceon_kw_xor01_data = {
	.shared		= &feroceon_kw_xor0_shared,
	.hw_id		= 1,
	.pool_size	= PAGE_SIZE,
};

static struct platform_device feroceon_kw_xor01_channel = {
	.name		= MV_XOR_NAME,
	.id		= 1,
	.num_resources	= ARRAY_SIZE(feroceon_kw_xor01_resources),
	.resource	= feroceon_kw_xor01_resources,
	.dev		= {
		.dma_mask		= &feroceon_kw_xor_dmamask,
		.coherent_dma_mask	= DMA_BIT_MASK(64),
		.platform_data		= (void *)&feroceon_kw_xor01_data,
	},
};

static void __init feroceon_kw_xor0_init(void)
{
	/* feroceon_kw_clk_ctrl |= CGC_XOR0; */
	platform_device_register(&feroceon_kw_xor0_shared);

	/*
	 * two engines can't do memset simultaneously, this limitation
	 * satisfied by removing memset support from one of the engines.
	 */
	dma_cap_set(DMA_MEMCPY, feroceon_kw_xor00_data.cap_mask);
	dma_cap_set(DMA_XOR, feroceon_kw_xor00_data.cap_mask);
	platform_device_register(&feroceon_kw_xor00_channel);

	dma_cap_set(DMA_MEMCPY, feroceon_kw_xor01_data.cap_mask);
	dma_cap_set(DMA_MEMSET, feroceon_kw_xor01_data.cap_mask);
	dma_cap_set(DMA_XOR, feroceon_kw_xor01_data.cap_mask);
	platform_device_register(&feroceon_kw_xor01_channel);
}


/*****************************************************************************
 * XOR1
 ****************************************************************************/
static struct resource feroceon_kw_xor1_shared_resources[] = {
	{
		.name	= "xor 1 low",
		.start	= XOR1_PHYS_BASE,
		.end	= XOR1_PHYS_BASE + 0xff,
		.flags	= IORESOURCE_MEM,
	}, {
		.name	= "xor 1 high",
		.start	= XOR1_HIGH_PHYS_BASE,
		.end	= XOR1_HIGH_PHYS_BASE + 0xff,
		.flags	= IORESOURCE_MEM,
	},
};

static struct platform_device feroceon_kw_xor1_shared = {
	.name		= MV_XOR_SHARED_NAME,
	.id		= 1,
	.dev		= {
		.platform_data = &feroceon_kw_xor_shared_data,
	},
	.num_resources	= ARRAY_SIZE(feroceon_kw_xor1_shared_resources),
	.resource	= feroceon_kw_xor1_shared_resources,
};

static struct resource feroceon_kw_xor10_resources[] = {
	[0] = {
		.start	= IRQ_FEROCEON_KW_XOR_10,
		.end	= IRQ_FEROCEON_KW_XOR_10,
		.flags	= IORESOURCE_IRQ,
	},
};

static struct mv_xor_platform_data feroceon_kw_xor10_data = {
	.shared		= &feroceon_kw_xor1_shared,
	.hw_id		= 0,
	.pool_size	= PAGE_SIZE,
};

static struct platform_device feroceon_kw_xor10_channel = {
	.name		= MV_XOR_NAME,
	.id		= 2,
	.num_resources	= ARRAY_SIZE(feroceon_kw_xor10_resources),
	.resource	= feroceon_kw_xor10_resources,
	.dev		= {
		.dma_mask		= &feroceon_kw_xor_dmamask,
		.coherent_dma_mask	= DMA_BIT_MASK(64),
		.platform_data		= (void *)&feroceon_kw_xor10_data,
	},
};

static struct resource feroceon_kw_xor11_resources[] = {
	[0] = {
		.start	= IRQ_FEROCEON_KW_XOR_11,
		.end	= IRQ_FEROCEON_KW_XOR_11,
		.flags	= IORESOURCE_IRQ,
	},
};

static struct mv_xor_platform_data feroceon_kw_xor11_data = {
	.shared		= &feroceon_kw_xor1_shared,
	.hw_id		= 1,
	.pool_size	= PAGE_SIZE,
};

static struct platform_device feroceon_kw_xor11_channel = {
	.name		= MV_XOR_NAME,
	.id		= 3,
	.num_resources	= ARRAY_SIZE(feroceon_kw_xor11_resources),
	.resource	= feroceon_kw_xor11_resources,
	.dev		= {
		.dma_mask		= &feroceon_kw_xor_dmamask,
		.coherent_dma_mask	= DMA_BIT_MASK(64),
		.platform_data		= (void *)&feroceon_kw_xor11_data,
	},
};

static void __init feroceon_kw_xor1_init(void)
{
	/* feroceon_kw_clk_ctrl |= CGC_XOR1; */
	platform_device_register(&feroceon_kw_xor1_shared);

	/*
	 * two engines can't do memset simultaneously, this limitation
	 * satisfied by removing memset support from one of the engines.
	 */
	dma_cap_set(DMA_MEMCPY, feroceon_kw_xor10_data.cap_mask);
	dma_cap_set(DMA_XOR, feroceon_kw_xor10_data.cap_mask);
	platform_device_register(&feroceon_kw_xor10_channel);

	dma_cap_set(DMA_MEMCPY, feroceon_kw_xor11_data.cap_mask);
	dma_cap_set(DMA_MEMSET, feroceon_kw_xor11_data.cap_mask);
	dma_cap_set(DMA_XOR, feroceon_kw_xor11_data.cap_mask);
	platform_device_register(&feroceon_kw_xor11_channel);
}
#endif /* CONFIG_MV_XOR */

void __init mv_init(void)
{
#ifdef CONFIG_CACHE_FEROCEON_L2
	kirkwood_l2_init();
#endif

        /* init the Board environment */
       	mvBoardEnvInit();

        /* init the controller environment */
        if( mvCtrlEnvInit() ) {
            printk( "Controller env initialization failed.\n" );
            return;
        }

	/* Init the CPU windows setting and the access protection windows. */
	if( mvCpuIfInit(mv_sys_map()) ) {

		printk( "Cpu Interface initialization failed.\n" );
		return;
	}

        if(mvBoardIdGet() == RD_88F6281A_ID) {
		mvBoardHDDPowerControl(1);
		mvBoardFanPowerControl(1);
#if defined(CONFIG_MV_INCLUDE_AUDIO)
		/* SPDIF only */
		mv_i2s_plat_data.i2s_rec = mv_i2s_plat_data.i2s_play = 0;	
#endif
	}

        support_wait_for_interrupt = 1;
  
#ifdef CONFIG_JTAG_DEBUG
            support_wait_for_interrupt = 0; /*  for Lauterbach */
#endif

	elf_hwcap &= ~HWCAP_JAVA;

   	serial_initialize();

	/* At this point, the CPU windows are configured according to default definitions in mvSysHwConfig.h */
	/* and cpuAddrWinMap table in mvCpuIf.c. Now it's time to change defaults for each platform.         */
	mvCpuIfAddDecShow();

    	print_board_info();

	feroceon_kw_setup_dram_target();

	feroceon_kw_mpp_conf();

	/* I2C */
	platform_device_register(&kw_i2c);

#if defined(CONFIG_MV_INCLUDE_SDIO)
       if (MV_TRUE == mvCtrlPwrClckGet(SDIO_UNIT_ID, 0)) 
       {
		int irq_detect = mvBoardSDIOGpioPinGet();
		
		if (irq_detect != MV_ERROR) {
			mvsdio_data.gpio_card_detect = irq_detect;
			set_irq_type(irq_detect + IRQ_GPP_START,
				     IRQ_TYPE_LEVEL_LOW);
		}
		if (MV_OK == mvSdmmcWinInit()) {
			mvsdio_data.clock = mvTclk;
			platform_device_register(&mv_sdio_plat);
		}
       }

#endif

#if defined(CONFIG_MV_INCLUDE_AUDIO)
       if (MV_TRUE == mvCtrlPwrClckGet(AUDIO_UNIT_ID, 0)) 
       {
		platform_device_register(&mv_mv88fx_i2s);
		platform_device_register(&mv_i2s);
		i2c_register_board_info(0, &i2c_a2d, 1);
       }

#endif


#ifdef CONFIG_MV_ETHERNET
       /* ethernet */
       platform_device_register(&mv88fx_eth);
#endif

	feroceon_kw_rtc_init();
#ifdef CONFIG_MV_XOR
	feroceon_kw_xor0_init();
	feroceon_kw_xor1_init();
#endif

       /* WATCHDOG */
	mv_wdt_init();

    return;
}

/*
 * Feroceon-KW machine: Marvell boards support.
 */

/* SATA ports */
static struct mv_sata_platform_data feroceon_kw_sata_data = {
	.n_ports = 2,
};

static void __init feroceon_kw_init(void)
{
	mv_init();
	feroceon_kw_sata_init(&feroceon_kw_sata_data);
}

static int __init feroceon_kw_pci_init(void)
{
	if (machine_is_feroceon_kw())
		feroceon_kw_pcie_init(KW_PCIE0 | KW_PCIE1);
	return 0;
}
subsys_initcall(feroceon_kw_pci_init);

MACHINE_START(FEROCEON_KW ,"Feroceon-KW")
    /* MAINTAINER("MARVELL") */
    .phys_io = FEROCEON_KW_REGS_PHYS_BASE,
    .io_pg_offst = ((FEROCEON_KW_REGS_VIRT_BASE) >> 18) & 0xfffc,
    .boot_params = 0x00000100,
    .map_io = feroceon_kw_map_io,
    .init_irq = feroceon_kw_init_irq,
    .timer = &mv_timer,
    .init_machine = feroceon_kw_init,
MACHINE_END
