/*
 * arch/arm/mach-feroceon-kw/core.h
 *
 * Core functions for Marvell Feroceon Kirkwood SoCs
 *
 * This file is licensed under the terms of the GNU General Public
 * License version 2.  This program is licensed "as is" without any
 * warranty of any kind, whether express or implied.
 */

#ifndef __ARCH_FEROCEON_KW_CORE_H
#define __ARCH_FEROCEON_KW_CORE_H

struct mv_sata_platform_data;
struct mv643xx_eth_platform_data;
struct mtd_partition;

void mv_map_io(void);
void mv_init(void);

void feroceon_kw_init_irq(void);

void feroceon_kw_nand_init(struct mtd_partition *parts, int nr_parts,
			   int chip_delay);

#define KW_PCIE0	(1 << 0)
#define KW_PCIE1	(1 << 1)
void feroceon_kw_enable_pcie(void);
void feroceon_kw_pcie_id(u32 *dev, u32 *rev);
void feroceon_kw_pcie_init(unsigned int portmask);

#ifdef CONFIG_SATA_MV
void feroceon_kw_sata_init(struct mv_sata_platform_data *sata_data);
#else
static inline void
feroceon_kw_sata_init(struct mv_sata_platform_data *sata_data) { }
#endif

#ifdef CONFIG_MV643XX_ETH
void feroceon_kw_ge00_init(struct mv643xx_eth_platform_data *eth_data);
void feroceon_kw_ge01_init(struct mv643xx_eth_platform_data *eth_data);
#else
static inline void
feroceon_kw_ge00_init(struct mv643xx_eth_platform_data *eth_data) { }
static inline void
feroceon_kw_ge01_init(struct mv643xx_eth_platform_data *eth_data) { }
#endif

void feroceon_kw_spi_init(void);

void feroceon_kw_setup_dram_target(void);
extern struct mbus_dram_target_info feroceon_kw_mbus_dram_info;

int mv_usb_init(void);

extern struct sys_timer mv_timer;

#endif
