/*
 * arch/asm-arm/mach-feroceon-kw/include/mach/gpio.h
 *
 * This file is licensed under the terms of the GNU General Public
 * License version 2.  This program is licensed "as is" without any
 * warranty of any kind, whether express or implied.
 */

#ifndef __ASM_ARCH_GPIO_H
#define __ASM_ARCH_GPIO_H

#include <mach/irqs.h>
#include <plat/gpio.h>
#include <asm-generic/gpio.h>		/* cansleep wrappers */

#define GPIO_MAX		50
#define GPIO_OFF(pin)		(((pin) >> 5) ? 0x10140 : 0x10100)
#define GPIO_OUT(pin)		(INTER_REGS_BASE + GPIO_OFF(pin) + 0x00)
#define GPIO_IO_CONF(pin)	(INTER_REGS_BASE + GPIO_OFF(pin) + 0x04)
#define GPIO_BLINK_EN(pin)	(INTER_REGS_BASE + GPIO_OFF(pin) + 0x08)
#define GPIO_IN_POL(pin)	(INTER_REGS_BASE + GPIO_OFF(pin) + 0x0c)
#define GPIO_DATA_IN(pin)	(INTER_REGS_BASE + GPIO_OFF(pin) + 0x10)
#define GPIO_EDGE_CAUSE(pin)	(INTER_REGS_BASE + GPIO_OFF(pin) + 0x14)
#define GPIO_EDGE_MASK(pin)	(INTER_REGS_BASE + GPIO_OFF(pin) + 0x18)
#define GPIO_LEVEL_MASK(pin)	(INTER_REGS_BASE + GPIO_OFF(pin) + 0x1c)

static inline int gpio_to_irq(int pin)
{
	return pin + IRQ_GPP_START;
}

static inline int irq_to_gpio(int irq)
{
	return irq - IRQ_GPP_START;
}
#endif
