/*
 * arch/arm/mach-feroceon-kw/lacie/boardenv/d2net_v2-boardenv.h
 *
 * LaCie d2 Network v2 board description.
 *
 * Copyright (c) 2009 LaCie
 *	Simon Guinot <sguinot@lacie.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __ARCH_FEROCEON_KW_D2NET_V2_BOARDENV_H
#define __ARCH_FEROCEON_KW_D2NET_V2_BOARDENV_H

#include <linux/bitops.h>
#include "common-boardenv.h"

/*
 * The LaCie d2 Network v2 board is based on a Marvell Kirkwood SoC 88F6281.
 */

/*
 * MPP configuration
 */

#define D2NET_V2_MPP0_7			COMMON_MPP0_7
#define D2NET_V2_MPP8_15		COMMON_MPP8_15
#define D2NET_V2_MPP16_23		COMMON_MPP16_23
#define D2NET_V2_MPP24_31		COMMON_MPP24_31
#define D2NET_V2_MPP32_39		COMMON_MPP32_39
#define D2NET_V2_MPP40_47		COMMON_MPP40_47
#define D2NET_V2_MPP48_55		COMMON_MPP48_55

/*
 * GPIO configuration
 */

#define D2NET_V2_GPIO_OE_LOW		COMMON_GPIO_OE_LOW
#define D2NET_V2_GPIO_OE_VAL_LOW	COMMON_GPIO_OE_VAL_LOW
#define D2NET_V2_GPIO_OE_HIGH		COMMON_GPIO_OE_HIGH
#define D2NET_V2_GPIO_OE_VAL_HIGH	COMMON_GPIO_OE_VAL_HIGH
#define D2NET_V2_GPIO_IN_POL_LOW	COMMON_GPIO_IN_POL_LOW
#define D2NET_V2_GPIO_IN_POL_HIGH	COMMON_GPIO_IN_POL_HIGH

/*
 * Export some GPIO pin number (especially those used for the
 * platform device registration)
 */

/* Buttons */
#define D2NET_V2_GPIO_SWITCH_POWER_ON	13
#define D2NET_V2_GPIO_SWITCH_POWER_OFF	15
#define D2NET_V2_GPIO_PUSH_BUTTON	34

/* LEDs */
#define D2NET_V2_GPIO_LED_RED		12
#define D2NET_V2_GPIO_LED_BLUE_SLOW	29
#define D2NET_V2_GPIO_LED_BLUE_CMD	30

/* USB switch */
#define D2NET_V2_GPIO_USB_FUSE		14
#define D2NET_V2_GPIO_USB_MODE		24
#define D2NET_V2_GPIO_USB_VBUS_IN	26
#define D2NET_V2_GPIO_USB_VBUS_OUT	28

/* harddisk power */
#define D2NET_V2_GPIO_HD0_POWER		16

/* Board power off */
#define D2NET_V2_GPIO_POWER_OFF		7
#define D2NET_V2_GPIO_INHIBIT_POWER_OFF	35

/*
 * Keep some output GPIOs already configured by U-Boot: LEDs
 */
#define D2NET_V2_GPIO_OUT_KEEP_LOW	\
	(				\
		BIT_MASK(12) |		\
		BIT_MASK(29) |		\
		BIT_MASK(30)		\
	)
#define D2NET_V2_GPIO_OUT_KEEP_HIGH	0L

/*
 * Functions related with the Marvell board environment
 */
void d2net_v2_boardenv_early_init(void);

#endif /* __ARCH_FEROCEON_KW_D2NET_V2_BOARDENV_H */
