/*
 * arch/arm/mach-feroceon-kw/lacie/boardenv/net2big_v2-boardenv.h
 *
 * LaCie Network 2Big v2 board description.
 *
 * Copyright (c) 2009 LaCie
 *	Simon Guinot <sguinot@lacie.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __ARCH_FEROCEON_KW_NET2BIG_V2_BOARDENV_H
#define __ARCH_FEROCEON_KW_NET2BIG_V2_BOARDENV_H

#include <linux/bitops.h>
#include "common-boardenv.h"

/*
 * The LaCie Network 2Big v2 board is based on a Marvell Kirkwood SoC 88F6281.
 */

/*
 * NAND configuration
 */
#define NET2BIG_NAND_V2_READ_PARAM_REG		0x003E07CF
#define NET2BIG_NAND_V2_WRITE_PARAM_REG		0x000F0F0F
#define NET2BIG_NAND_V2_CTRL_REG		0x01C7D943


/*
 * MPP configuration
 */

#define NET2BIG_V2_MPP0_7		COMMON_MPP0_7
/* Alternate configuration for 2Big boards with a NAND flash. */
#define NET2BIG_V2_NAND_MPP0_7		0x01111111
#define NET2BIG_V2_MPP8_15		COMMON_MPP8_15
#define NET2BIG_V2_MPP16_23		COMMON_MPP16_23
#define NET2BIG_V2_MPP24_31		COMMON_MPP24_31
#define NET2BIG_V2_MPP32_39		COMMON_MPP32_39
#define NET2BIG_V2_MPP40_47		COMMON_MPP40_47
#define NET2BIG_V2_MPP48_55		COMMON_MPP48_55

/*
 * GPIO configuration
 */

#define NET2BIG_V2_GPIO_OE_LOW		COMMON_GPIO_OE_LOW
#define NET2BIG_V2_GPIO_OE_VAL_LOW	COMMON_GPIO_OE_VAL_LOW
#define NET2BIG_V2_GPIO_OE_HIGH		COMMON_GPIO_OE_HIGH
#define NET2BIG_V2_GPIO_OE_VAL_HIGH	COMMON_GPIO_OE_VAL_HIGH
#define NET2BIG_V2_GPIO_IN_POL_LOW	COMMON_GPIO_IN_POL_LOW
#define NET2BIG_V2_GPIO_IN_POL_HIGH	COMMON_GPIO_IN_POL_HIGH

/*
 * Export some GPIO pin number (especially those used for the
 * platform device registration)
 */

/* Buttons */
#define NET2BIG_V2_GPIO_SWITCH_POWER_ON		13
#define NET2BIG_V2_GPIO_SWITCH_POWER_OFF	15
#define NET2BIG_V2_GPIO_PUSH_BUTTON		34

/* LEDs */
#define NET2BIG_V2_GPIO_LED_ACT_HD1		21

/* USB switch */
#define NET2BIG_V2_GPIO_USB_FUSE		14
#define NET2BIG_V2_GPIO_USB_MODE		24
#define NET2BIG_V2_GPIO_USB_VBUS_IN		26
#define NET2BIG_V2_GPIO_USB_VBUS_OUT		28

/* GPIO fan */
#define NET2BIG_V2_GPIO_FAN_FAIL		25

/* harddisk power */
#define NET2BIG_V2_GPIO_HD0_POWER 		16
#define NET2BIG_V2_GPIO_HD1_POWER 		17
#define NET2BIG_V2_GPIO_HD0_PRES 		36
#define NET2BIG_V2_GPIO_HD1_PRES 		37
#define NET2BIG_V2_GPIO_ESATA_PRES		40

/* Board power off */
#define NET2BIG_V2_GPIO_POWER_OFF		7
#define NET2BIG_V2_GPIO_INHIBIT_POWER_OFF	35

/* GPIO extention */
#define NET2BIG_V2_GPIO_EXT_ENABLE		29
#define NET2BIG_V2_GPIO_EXT_DATA0		44
#define NET2BIG_V2_GPIO_EXT_DATA1		45
#define NET2BIG_V2_GPIO_EXT_DATA2		46
#define NET2BIG_V2_GPIO_EXT_ADDR0		47
#define NET2BIG_V2_GPIO_EXT_ADDR1		48
#define NET2BIG_V2_GPIO_EXT_ADDR2		49

/*
 * Keep some output GPIOs already configured by U-Boot: LEDs and HD power
 */
#define NET2BIG_V2_GPIO_OUT_KEEP_LOW		\
	(					\
		BIT_MASK(16) |			\
		BIT_MASK(17) |			\
		BIT_MASK(29)			\
	)
#define NET2BIG_V2_GPIO_OUT_KEEP_HIGH		\
	(					\
		BIT_MASK(12) |			\
		BIT_MASK(13) |			\
		BIT_MASK(14) |			\
		BIT_MASK(15) |			\
		BIT_MASK(16) |			\
		BIT_MASK(17)			\
	)

/*
 * Functions related with the Marvell board environment
 */
void net2big_v2_boardenv_early_init(void);

#endif /* __ARCH_FEROCEON_KW_NET2BIG_V2_BOARDENV_H */
