/*
 * arch/arm/mach-feroceon-kw/lacie/boardenv/net5big_v2-boardenv.c
 *
 * LaCie Network 5Big v2 board description.
 *
 * Copyright (c) 2009 LaCie
 *
 * Author: Simon Guinot <sguinot@lacie.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <asm/mach-types.h>
#include "net5big_v2-boardenv.h"
#include "mvCommon.h"
#include "twsi/mvTwsi.h"

MV_U8 net5big_v2_BoardDebugLedIf[0];

/*
 * PHY device configuration
 */
MV_BOARD_MAC_INFO net5big_v2_BoardMacInfo[] = {
	/* PHY devices are located on SMI address 0x8 and 0x9 and have auto
	 * speed capabilities. */
	{ BOARD_MAC_SPEED_AUTO, 0x8 },
	{ BOARD_MAC_SPEED_AUTO, 0x0 },
};

/*
 * TWSI devices definition
 */
MV_BOARD_TWSI_INFO net5big_v2_BoardTwsiDev[0];

/*
 * GPP connection definition
 *
 * Example with USB VBUS detection connected on GPP pin 1:
 * {{BOARD_DEV_USB_VBUS, 1}}
 */
MV_BOARD_GPP_INFO net5big_v2_GppInfo[0];

/* Set the MPP type information to MV_BOARD_OTHER. No autodetection is
 * needed because the MPP configuration is fully supplied. */
MV_BOARD_MPP_TYPE_INFO net5big_v2_BoardMppTypeInfo[] = {
	{ MV_BOARD_OTHER, MV_BOARD_OTHER },
};

/*
 * Device bus configuration
 */
MV_DEV_CS_INFO net5big_v2_BoardDeCsInfo[] = {
	{ 1, N_A, BOARD_DEV_SPI_FLASH, 8 },
};

MV_BOARD_MPP_INFO net5big_v2_BoardMppConfigValue[] = {
	{
		{
			NET5BIG_V2_MPP0_7,
			NET5BIG_V2_MPP8_15,
			NET5BIG_V2_MPP16_23,
			NET5BIG_V2_MPP24_31,
			NET5BIG_V2_MPP32_39,
			NET5BIG_V2_MPP40_47,
			NET5BIG_V2_MPP48_55,
		},
	},
};

MV_BOARD_INFO net5big_v2_Info = {
	/* Board name */
	"net5big_v2",
	/* MPP group types */
	ARRAY_SIZE(net5big_v2_BoardMppTypeInfo),
	net5big_v2_BoardMppTypeInfo,
	/* Board MPP config */
	ARRAY_SIZE(net5big_v2_BoardMppConfigValue),
	net5big_v2_BoardMppConfigValue,
	/* Interrupts GPP mask low */
	0,
	/* Interrupts GPP mask high */
	0,
	/* Device bus configuration */
	ARRAY_SIZE(net5big_v2_BoardDeCsInfo),
	net5big_v2_BoardDeCsInfo,
	/* TWSI devices definition */
	ARRAY_SIZE(net5big_v2_BoardTwsiDev),
	net5big_v2_BoardTwsiDev,
	/* PHY devices configuration */
	ARRAY_SIZE(net5big_v2_BoardMacInfo),
	net5big_v2_BoardMacInfo,
	/* GPP connection definition */
	ARRAY_SIZE(net5big_v2_GppInfo),
	net5big_v2_GppInfo,
	/* LED configuration */
	0,
	NULL,
	0,
	/* GPIO data out enable control register */
	NET5BIG_V2_GPIO_OE_LOW,
	NET5BIG_V2_GPIO_OE_HIGH,
	/* GPIO data out register */
	NET5BIG_V2_GPIO_OE_VAL_LOW,
	NET5BIG_V2_GPIO_OE_VAL_HIGH,
	/* GPIO data in Polarity register */
	NET5BIG_V2_GPIO_IN_POL_LOW,
	NET5BIG_V2_GPIO_IN_POL_HIGH,
	/* Switch info */
	NULL,
	/* Initial values for NAND flash registers (read, write and control) */
	0,
	0,
	0,
};

u32 __initdata net5big_v2_gpio_out_keep_map[2] = {
	NET5BIG_V2_GPIO_OUT_KEEP_LOW,
	NET5BIG_V2_GPIO_OUT_KEEP_HIGH,
};

void __init net5big_v2_boardenv_early_init(void)
{
	u32 boardId = mvBoardIdGet();

	/*
	 * Replace SPI flash with NAND flash on 5big Network NAND v2
	 */
	if (machine_is_net5big_nand_v2()) {
		net5big_v2_BoardDeCsInfo[0].devClass = BOARD_DEV_NAND_FLASH;
		net5big_v2_Info.nandFlashReadParams =
			NET5BIG_NAND_V2_READ_PARAM_REG;
		net5big_v2_Info.nandFlashWriteParams =
			NET5BIG_NAND_V2_WRITE_PARAM_REG;
		net5big_v2_Info.nandFlashControl = NET5BIG_NAND_V2_CTRL_REG;
	}

	gpio_out_keep_values(boardId, net5big_v2_gpio_out_keep_map);
}
