/*
 * arch/arm/mach-feroceon-kw/lacie/netspace_lite_v2-setup.c
 *
 * LaCie Network Space Lite v2 board setup.
 *
 * Copyright (C) 2010 LaCie
 *
 * Author: Simon Guinot <sguinot@lacie.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <linux/kernel.h>
#include <linux/platform_device.h>
#include <linux/i2c.h>
#include <linux/input.h>
#include <linux/gpio_keys.h>
#include <linux/leds.h>
#include <linux/ata_platform.h>
#include <linux/gpio.h>
#include <linux/mv643xx_eth.h>
#include <asm/mach-types.h>
#include <asm/mach/arch.h>

#include "core.h"
#include "lacie_v2-common.h"
#include "marvell_boardenv/netspace_lite_v2-boardenv.h"
#include "lacie/common.h"
#include "lacie/drivers/leds-ns2l.h"
#include "lacie/drivers/gpio-hd-power.h"
#include "lacie/drivers/gpio-usb.h"

extern struct lacie_disk_map *lacie_disk_map;

/* Ethernet */

static struct mv643xx_eth_platform_data netspace_lite_v2_ge00_data = {
	.phy_addr	= MV643XX_ETH_PHY_ADDR(0),
};

/* GPIO buttons */

static struct gpio_keys_button netspace_lite_v2_buttons[] = {
	[0] = {
		.code		= KEY_POWER,
		.gpio		= NETSPACE_LITE_V2_GPIO_KEY_POWER,
		.desc		= "Back push power button",
		.active_low	= 0,
	},
};

static struct gpio_keys_platform_data netspace_lite_v2_button_data = {
	.buttons	= netspace_lite_v2_buttons,
	.nbuttons	= ARRAY_SIZE(netspace_lite_v2_buttons),
};

static struct platform_device netspace_lite_v2_gpio_buttons = {
	.name		= "gpio-keys",
	.id		= -1,
	.dev		= {
		.platform_data 	= &netspace_lite_v2_button_data,
	},
};

/* GPIO LEDs */

static struct gpio_led netspace_lite_v2_gpio_led_pins[] = {
	[0] = {
		.name		= "ns_lite_v2:red:fail",
		.gpio		= NETSPACE_LITE_V2_GPIO_LED_RED,
		.default_state	= LEDS_GPIO_DEFSTATE_KEEP,
	},
};

static struct gpio_led_platform_data netspace_lite_v2_gpio_leds_data = {
	.num_leds	= ARRAY_SIZE(netspace_lite_v2_gpio_led_pins),
	.leds		= netspace_lite_v2_gpio_led_pins,
};

static struct platform_device netspace_lite_v2_gpio_leds = {
	.name		= "leds-gpio",
	.id		= -1,
	.dev		= {
		.platform_data	= &netspace_lite_v2_gpio_leds_data,
	},
};

/* Netwok Space Lite v2 LEDs */

static struct ns2l_led netspace_lite_v2_led_pins[] = {
	[0] = {
		.name		= "ns_lite_v2:blue:sata",
		.mpp		= NETSPACE_LITE_V2_GPIO_LED_BLUE,
		.gpio_sel	= 0,
		.sata_sel	= 5,
	},
};

static struct ns2l_led_platform_data netspace_lite_v2_leds_data = {
	.num_leds	= ARRAY_SIZE(netspace_lite_v2_led_pins),
	.leds		= netspace_lite_v2_led_pins,
};

static struct platform_device netspace_lite_v2_leds = {
	.name		= "leds-ns2l",
	.id		= -1,
	.dev		= {
		.platform_data	= &netspace_lite_v2_leds_data,
	},
};

/* GPIO USB (with on the go fakery) */

static struct gpio_usb netspace_lite_v2_gpio_usb_port0[] = {
	[0] = {
		.name	= "fuse",
		.type	= GPIO_USB_FUSE,
		.num	= NETSPACE_LITE_V2_GPIO_USB_FUSE,
		.act_low = 1,
	},
	[1] = {
		.name	= "mode",
		.type	= GPIO_USB_MODE,
		.num	= NETSPACE_LITE_V2_GPIO_USB_MODE,
	},
	[2] = {
		.name	= "vbus-in",
		.type	= GPIO_USB_VBUS_IN,
		.num	= NETSPACE_LITE_V2_GPIO_USB_VBUS_IN,
	},
	[3] = {
		.name	= "vbus-out",
		.type	= GPIO_USB_VBUS_OUT,
		.num	= NETSPACE_LITE_V2_GPIO_USB_VBUS_OUT,
	},
};

static struct gpio_usb_port netspace_lite_v2_gpio_usb_ports[] = {
	[0] = {
		.name		= "port0",
		.gpio		= netspace_lite_v2_gpio_usb_port0,
		.num_gpio	= ARRAY_SIZE(netspace_lite_v2_gpio_usb_port0),
		.reload_delay	= 10000,
		.spurious_delay	= 100,
	},
};

struct gpio_usb_platform_data netspace_lite_v2_lacie_gpio_usb_data = {
	.port		= netspace_lite_v2_gpio_usb_ports,
	.num_port	= ARRAY_SIZE(netspace_lite_v2_gpio_usb_ports),
};

static struct platform_device netspace_lite_v2_gpio_usb = {
	.name		= "gpio-usb",
	.id		= -1,
	.dev		= {
		.platform_data	= &netspace_lite_v2_lacie_gpio_usb_data,
	},
};

/* GPIO hard disk power */

static struct gpio_hd_power netspace_lite_v2_hd_power[] = {
	[0] = {
		.name		= "hd0",
		.power_pin	= NETSPACE_LITE_V2_GPIO_HD0_POWER,
		.have_power_pin	= 1,
	},
};

static struct gpio_hd_power_platform_data netspace_lite_v2_hd_power_data = {
	.hd		= netspace_lite_v2_hd_power,
	.num_hds	= ARRAY_SIZE(netspace_lite_v2_hd_power),
};

static struct platform_device netspace_lite_v2_gpio_hd_power = {
	.name		= "gpio-hd-power",
	.id		= -1,
	.dev		= {
		.platform_data 	= &netspace_lite_v2_hd_power_data,
	},
};

/* I2C eeprom */

static struct i2c_board_info netspace_lite_v2_i2c_info[] = {
	{
		I2C_BOARD_INFO("at24", 0x50),
		.type = "24c04",
	},
};

/* internal disk map */

static struct lacie_disk netspace_lite_v2_disks[] = {
	{
		.host_no = 0,
		.channel = 0,
		.id 	 = 0,
		.letter  = 'a',
	},
};

static struct lacie_disk_map netspace_lite_v2_disk_map = {
	.disks = netspace_lite_v2_disks,
	.num_disks = ARRAY_SIZE(netspace_lite_v2_disks),
};

/* USB storage id's */

static struct lacie_usb_storage_id netspace_lite_v2_usb_storage_id = {
	.idVendor 	= 0x059f,
	.idProduct 	= 0x1047,
	.manufacturer	= "LaCie S.A.",
	.product	= "Network Space Lite v2 NAS",
};

/* SATA ports */

static struct mv_sata_platform_data netspace_lite_v2_sata_data = {
	.n_ports = 1,
};

/* Registration */

static struct platform_device *netspace_lite_v2_gpio_devices[] __initdata = {
	&netspace_lite_v2_gpio_buttons,
	&netspace_lite_v2_gpio_hd_power,
	&netspace_lite_v2_leds,
	&netspace_lite_v2_gpio_leds,
	&netspace_lite_v2_gpio_usb,
};

static inline void __init netspace_lite_v2_gpio_init(void)
{
        platform_add_devices(netspace_lite_v2_gpio_devices,
				ARRAY_SIZE(netspace_lite_v2_gpio_devices));
}

static inline void __init netspace_lite_v2_i2c_eeprom_init(void)
{
	i2c_register_board_info(0, netspace_lite_v2_i2c_info,
				ARRAY_SIZE(netspace_lite_v2_i2c_info));
}

static inline void __init netspace_lite_v2_disk_map_init(void)
{
	lacie_disk_map = &netspace_lite_v2_disk_map;
}

static inline void __init netspace_lite_v2_usb_storage_id_init(void)
{
	lacie_usb_storage_id = &netspace_lite_v2_usb_storage_id;
}

static void netspace_lite_v2_power_off(void)
{
	gpio_set_value(NETSPACE_LITE_V2_GPIO_POWER_OFF, 1);
}

void __init netspace_lite_v2_init(void)
{
	int err;

	/*
	 * Basic setup. Needs to be called early.
	 */
	netspace_lite_v2_boardenv_early_init();
	mv_init();

	feroceon_kw_sata_init(&netspace_lite_v2_sata_data);
	feroceon_kw_ge00_init(&netspace_lite_v2_ge00_data);
	mv_usb_init();
	lacie_v2_sf_init();

	netspace_lite_v2_gpio_init();
	netspace_lite_v2_i2c_eeprom_init();
	netspace_lite_v2_disk_map_init();
	netspace_lite_v2_usb_storage_id_init();

	err = gpio_request(NETSPACE_LITE_V2_GPIO_POWER_OFF, "power-off");
	if (err == 0) {
		err = gpio_direction_output(NETSPACE_LITE_V2_GPIO_POWER_OFF, 0);
		if (err)
			gpio_free(NETSPACE_LITE_V2_GPIO_POWER_OFF);
	}
	if (err)
		pr_err("netspace_lite_v2: failed to configure power-off GPIO\n");

	pm_power_off = netspace_lite_v2_power_off;

	return;
}

MACHINE_START(NETSPACE_LITE_V2, "netspace_lite_v2")
	.phys_io = 0xf1000000,
	.io_pg_offst = ((0xf1000000) >> 18) & 0xfffc,
	.boot_params = 0x00000100,
	.init_machine = netspace_lite_v2_init,
	.map_io = mv_map_io,
	.init_irq = feroceon_kw_init_irq,
	.timer = &mv_timer,
MACHINE_END
