/*
 * lacie/lacie-common.h
 *
 * Copyright (c) 2009 LaCie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __LACIE_COMMON_H
#define __LACIE_COMMON_H

struct lacie_disk {
	unsigned int host_no;
	unsigned int channel;
	unsigned int id;
	unsigned int letter; /* letter of an internal sata disk ex 'a' for /dev/sda */
};

struct lacie_disk_map {
	struct lacie_disk *disks; /* contains only internal sata disks */
	int num_disks;
};

struct lacie_usb_storage_id {
	unsigned short idVendor;
	unsigned short idProduct;
	char *manufacturer;
	char *product;
	char *serial;
};

extern struct lacie_usb_storage_id *lacie_usb_storage_id;

#endif
