#!/bin/bash
# -----------------------------------------------------------------------------
# Requirements, this script:
#
# - Shall be executed in the LaCie SBS build system
# - Shall be able to access the LAPKG framework (For this, the project's 
#   environment variable LA_LAPKG_DIR must be defined  with the LAPKG 
#   framework's absolute patch)
# -----------------------------------------------------------------------------

# Define global constants
G_COMPONENT_NAME=$(basename ${LA_COMPONENT_DIR}) # Set the component's name
G_DO_CLEANUP=`[ "x${LA_FORCECLEAN}" == "x1" ]; echo $?` # Check if cleanup is required

# Ensure the presence of mandatory LAPKG framework
if [ -z "${LA_LAPKG_DIR}" -o ! -d "${LA_LAPKG_DIR}" ]; then
    echo "[${G_COMPONENT_NAME}]: LAPKG directory not found"
    exit 1
fi

# Import LAPKG library
. ${LA_LAPKG_DIR}/lib/compilelib.sh

# -----------------------------------------------------------------------------
# ----------------------- B U I L D  T H E  P A C K A G E ---------------------
# -----------------------------------------------------------------------------

# Initialize the compilation environment
lapkg_doExec lapkg_init "${G_COMPONENT_NAME}" ${G_DO_CLEANUP}

PYTHON_VERSION=2.6

# Build the package
lapkg_doExec lapkg_buildPythonPackage ${PYTHON_VERSION}

# Install the package from BUILD dir
lapkg_doExec lapkg_installPythonPackage ${PYTHON_VERSION}

# Release the compilation environment
lapkg_doExec lapkg_finish
exit ${TRUE}

# vi: et ts=4 sw=4

