#!/bin/bash
# ============================================================================
# This script builds the READLINE package. In order to compile, it needs:
#
# * To be executed in the LaCie SBS build system
#
# * To be able to access the LAPKG framework
#     For this, the project's environment variable LA_LAPKG_DIR must be defined
#     with the LAPKG framework's absolute patch.
# =============================================================================

#
# Define global constants
#
G_COMPONENT_NAME=$(basename ${LA_COMPONENT_DIR}) # Set the component's name
G_DO_CLEANUP=`[ "x${LA_FORCECLEAN}" == "x1" ]; echo $?` # Check if cleanup is required

#
# Ensure the presence of mandatory LAPKG framework
#
if [ -z "${LA_LAPKG_DIR}" -o ! -d "${LA_LAPKG_DIR}" ]; then
    echo "[${G_COMPONENT_NAME}]: LAPKG directory not found"
    exit ${FALSE}
fi

#
# Import LAPKG library
#
. ${LA_LAPKG_DIR}/lib/compilelib.sh

# -----------------------------------------------------------------------------
# ----------------------- B U I L D  T H E  P A C K A G E ---------------------
# -----------------------------------------------------------------------------

# Initialize the compilation environment
lapkg_doExec lapkg_init "${G_COMPONENT_NAME}" ${G_DO_CLEANUP}

# Configure the package in BUILD dir
lapkg_doExec lapkg_gnuConfigure - --enable-gssapi \
                                  --with-gss_impl=mit


# Build the package
lapkg_doExec lapkg_buildPackage -

# Install the package from BUILD dir
lapkg_doExec lapkg_installPackage - "DESTDIR=${G_LAPKG_INSTALL_DIR}"

# Release the compilation environment
lapkg_doExec lapkg_finish
exit ${TRUE}

#
# vi: et ts=4 sw=4
#

