#include "debug.h"

#include <stdio.h>
#include <stdint.h>

void fdump (FILE *f, const void *buffer, int size) {
	uint8_t *buf = (uint8_t *) buffer ;
	int len, i, j, c ;

	for (i = 0 ; i < size ; i += 16) {
		len = size - i ;
		if (len > 16)
			len = 16 ;
		fprintf (f, "%08x ", i) ;
		for (j = 0 ; j < 16 ; j ++) {
			if (j < len)
				fprintf( f, " %02x", buf[i + j]) ;
			else
				fprintf (f, "   ") ;
		}
		fprintf (f, " ") ;
		for (j = 0 ; j < len ; j ++) {
			c = buf[i + j] ;
			if (c < ' ' || c > '~')
				c = '.' ;
			fprintf (f, "%c", c) ;
		}
		fprintf (f, "\n") ;
	}
}

#define STACK_SIZE 32

#ifdef __GLIBC__
#include <execinfo.h>
#endif

void fprint_backtrace (FILE *out) {
#ifdef __GLIBC__
	char ** symbols ;
	void * addresses [STACK_SIZE] ;
	int size, level ;
	size = backtrace (addresses, STACK_SIZE) ;
	if (size == 0)
		goto error ;
	symbols = backtrace_symbols (addresses, size) ;
	if (symbols == NULL)
		goto error ;
	for (level = 1 ; level < size ; level ++)
		fprintf (out, "\t%2d: %s\n", level - 1, symbols [level]) ;
	free (symbols) ;
	return ;
error :
	fprintf (out, "no backtrace\n") ;
#else
	fprintf (out, "backtrace unavailable\n") ;
#endif
}
