
########################################
# fake Kconfig
CONFIG_AUFS = m
# fake nameidata, currently y is recommended
CONFIG_AUFS_FAKE_DM = y
# dba will be removed soon
# disable it if you forbid 'Direct Branch Access'
CONFIG_AUFS_DBA = y
# valid for dynamic module only. enable it if you didn't apply the 'ksize' patch
ifeq (${CONFIG_AUFS}, m)
#CONFIG_AUFS_NO_KSIZE = y
endif
# it will be obsoleted
# CONFIG_AUFS_COMPAT = y
# debugging
# CONFIG_AUFS_DEBUG = y
# debug-able rw_sempahore, much slower
#CONFIG_AUFS_DEBUG_RWSEM = y

define conf
ifdef $(1)
AUFS_DEF_CONFIG += -D$(1)
endif
endef

AUFS_DEF_CONFIG =
$(foreach i, FAKE_DM DBA COMPAT DEBUG DEBUG_RWSEM, $(eval $(call conf,CONFIG_AUFS_$(i))))
ifeq (${CONFIG_AUFS}, m)
AUFS_DEF_CONFIG += -DCONFIG_AUFS_MODULE -UCONFIG_AUFS
#$(eval $(call conf,CONFIG_AUFS_NO_KSIZE))
ifdef CONFIG_AUFS_NO_KSIZE
AUFS_DEF_CONFIG += -DCONFIG_AUFS_NO_KSIZE
endif
endif

EXTRA_CFLAGS += -Werror
EXTRA_CFLAGS += -I ${CURDIR}/include
EXTRA_CFLAGS += ${AUFS_DEF_CONFIG}
EXTRA_CFLAGS += -DLKTRHidePrePath=\"${CURDIR}/fs/aufs\"
export

########################################
# fake top level make

KDIR = /lib/modules/$(shell uname -r)/build
Tgt = aufs.ko aufs.5 aufind.sh mount.aufs
ifdef CONFIG_AUFS_COMPAT
Tgt += unionctl
endif

all: ${Tgt}
FORCE:

aufs.ko: fs/aufs/aufs.ko
	test ! -e $@ && ln -s $< $@ || :
fs/aufs/aufs.ko: FORCE
#	echo ${AUFS_DEF_CONFIG}
	${MAKE} -C ${KDIR} M=${CURDIR}/fs/aufs modules

########################################
clean:
	${MAKE} -C ${KDIR} M=${CURDIR}/fs/aufs $@
	${MAKE} -C util $@
	${RM} ${Tgt} cg TAGS index.html lindent
	${RM} *~ .*~ fs/aufs/*~ fs/aufs/.*~ include/linux/*~ include/linux/.*~

util/%:
	${MAKE} -C util
aufind.sh: util/aufind.sh
	ln -s $< $@
aufs.5: util/aufs.5
	ln -s $< $@
mount.aufs: util/mount.aufs
	test -x $< || chmod a+x $<
	ln -s $< $@
unionctl: util/unionctl
	test -x $< || chmod a+x $<
	ln -s $< $@

-include priv.mk
