/*
 * Copyright (C) 2005-2006 Junjiro Okajima
 *
 * This program, aufs is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/* $Id: wh.h,v 1.12 2006/12/11 02:23:30 sfjro Exp $ */

#ifndef __AUFS_WH_H__
#define __AUFS_WH_H__

#include <linux/fs.h>
#include <linux/aufs_type.h>

#ifdef __KERNEL__

int alloc_whname(const char *name, int len, struct qstr *wh);
void free_whname(struct qstr *wh);

int is_wh(struct dentry *hidden_parent, struct qstr *wh_name, int try_sio,
	  struct vfsmount *h_mnt);
int is_diropq(struct dentry *hidden_dentry, struct vfsmount *h_mnt);

struct dentry *lookup_whtmp(struct dentry *hidden_parent, struct qstr *prefix,
			    struct vfsmount *h_mnt);
int rename_whtmp(struct dentry *dentry, aufs_bindex_t bindex);
int unlink_wh_dentry(struct inode *hidden_dir, struct dentry *wh_dentry,
		     struct dentry *dentry);

struct aufs_branch;
int init_wh(struct dentry *hidden_parent, struct aufs_branch *br,
	    struct vfsmount *h_mnt);

struct dentry *sio_diropq(struct dentry *dentry, aufs_bindex_t bindex,
			  int do_create);
#define create_diropq(dentry, bindex)	sio_diropq(dentry, bindex, 1)
#define remove_diropq(dentry, bindex)	PTR_ERR(sio_diropq(dentry, bindex, 0))

struct dentry *lookup_wh(struct dentry *hidden_parent, struct qstr *base_name,
			 struct vfsmount *h_mnt);
struct dentry *simple_create_wh(struct dentry *dentry, aufs_bindex_t bindex,
				struct dentry *hidden_parent);

struct rmdir_whtmp_arg {
	struct dentry *hidden_dentry;
	struct aufs_nhash whlist;
	aufs_bindex_t bindex;
	struct inode *dir, *inode;
};

struct aufs_nhash;
int rmdir_whtmp(struct dentry *hidden_dentry, struct aufs_nhash *whlist,
		aufs_bindex_t bindex, struct inode *dir, struct inode *inode);
void kick_rmdir_whtmp(struct dentry *hidden_dentry, struct aufs_nhash *whlist,
		      aufs_bindex_t bindex, struct inode *dir,
		      struct inode *inode, struct rmdir_whtmp_arg *arg);

#endif /* __KERNEL__ */
#endif /* __AUFS_WH_H__ */
