
########################################
# fake Kconfig

# tristate
CONFIG_AUFS = m
# bool, fake nameidata, currently y is recommended
CONFIG_AUFS_FAKE_DM = y
# bool, valid only linux-2.6.18 and later.
# enable it and CONFIG_INOTIFY if you use 'udba=inotify'
#CONFIG_AUFS_HINOTIFY = y

ifdef ${CONFIG_NFS_FS}
# bool, valid only linux-2.6.19 and later.
# enable it and apply lhash.patch to your kernel source if you use NFS branch
#CONFIG_AUFS_LHASH_PATCH = y
endif

ifeq (${CONFIG_AUFS}, m)
# bool, valid for dynamic module only.
# enable it if you applied the 'ksize' patch for performance
#CONFIG_AUFS_KSIZE_PATCH = y
endif

# bool, it will be obsoleted
CONFIG_AUFS_COMPAT = y
# bool, debugging
CONFIG_AUFS_DEBUG = y
# bool, debug-able rw_sempahore, much slower
#CONFIG_AUFS_DEBUG_RWSEM = y

AUFS_DEF_CONFIG =
-include priv_def.mk

define conf
ifdef $(1)
AUFS_DEF_CONFIG += -D$(1)
endif
endef

$(foreach i, FAKE_DM HINOTIFY LHASH_PATCH COMPAT DEBUG DEBUG_RWSEM, \
	$(eval $(call conf,CONFIG_AUFS_$(i))))
ifeq (${CONFIG_AUFS}, m)
AUFS_DEF_CONFIG += -DCONFIG_AUFS_MODULE -UCONFIG_AUFS
#$(eval $(call conf,CONFIG_AUFS_KSIZE_PATCH))
ifdef CONFIG_AUFS_KSIZE_PATCH
AUFS_DEF_CONFIG += -DCONFIG_AUFS_KSIZE_PATCH
endif
endif

EXTRA_CFLAGS += -I ${CURDIR}/include
EXTRA_CFLAGS += ${AUFS_DEF_CONFIG}
EXTRA_CFLAGS += -DLKTRHidePrePath=\"${CURDIR}/fs/aufs\"
export

########################################
# fake top level make

KDIR = /lib/modules/$(shell uname -r)/build
Tgt = aufs.ko aufs.5 aufind.sh mount.aufs
ifdef CONFIG_AUFS_COMPAT
Tgt += unionctl
endif

all: ${Tgt}
FORCE:

aufs.ko: fs/aufs/aufs.ko
	test ! -e $@ && ln -s $< $@ || :
fs/aufs/aufs.ko: FORCE
#	@echo ${AUFS_DEF_CONFIG}
	${MAKE} -C ${KDIR} M=${CURDIR}/fs/aufs modules

########################################
clean:
	${MAKE} -C ${KDIR} M=${CURDIR}/fs/aufs $@
	${MAKE} -C util $@
	${RM} ${Tgt} cg TAGS index.html lindent
	find . -type f \( -name '*~' -o -name '.#*[0-9]' \) | xargs -r ${RM}

util/%:
	${MAKE} -C util
aufind.sh: util/aufind.sh
	ln -s $< $@
aufs.5: util/aufs.5
	ln -s $< $@
mount.aufs: util/mount.aufs
	test -x $< || chmod a+x $<
	ln -s $< $@
unionctl: util/unionctl
	test -x $< || chmod a+x $<
	ln -s $< $@

-include priv.mk
