/*
 * Copyright (C) 2005-2006 Junjiro Okajima
 *
 * This program, aufs is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/* $Id: branch.h,v 1.8 2006/08/07 14:50:22 sfjro Exp $ */

#ifndef __AUFS_BRANCH_H__
#define __AUFS_BRANCH_H__

#include <linux/fs.h>
#include <linux/mount.h>
#include <linux/aufs_type.h>
#include "misc.h"

#ifdef __KERNEL__

/* protected by superblock rwsem */
struct aufs_branch {
	struct super_block	*br_sb;
	struct vfsmount		*br_mnt;
	atomic_t		br_count;
	unsigned int		br_perm;
	struct file		*br_xino;

	struct aufs_rwsem	br_wh_rwsem;
	struct dentry		*br_wh;
};

#define br_count(br)		atomic_read(&(br)->br_count)
#define br_get(br)		atomic_inc(&(br)->br_count)
#define br_put(br)		atomic_dec(&(br)->br_count)

/* ---------------------------------------------------------------------- */

struct aufs_sbinfo;
void free_branches(struct aufs_sbinfo *sinfo);
int br_rdonly(struct aufs_branch *br);
int find_rw_br(struct super_block *sb, aufs_bindex_t bend);
int find_rw_parent_br(struct dentry *dentry, aufs_bindex_t bend);
struct opt_add;
int br_add(struct super_block *sb, struct opt_add *add, int remount);
struct opt_del;
int br_del(struct super_block *sb, struct opt_del *del, int remount);
struct opt_mod;
int br_mod(struct super_block *sb, struct opt_mod *mod, int remount);

#endif /* __KERNEL__ */
#endif /* __AUFS_BRANCH_H__ */
