/*
 * Copyright (C) 2005-2006 Junjiro Okajima
 *
 * This program, aufs is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/* $Id: dir.h,v 1.6 2006/07/31 03:46:14 sfjro Exp $ */

#ifndef __AUFS_DIR_H__
#define __AUFS_DIR_H__

#include <linux/fs.h>
#include <linux/aufs_type.h>

#ifdef __KERNEL__

/* need to be faster and smaller */

#define AUFS_DEBLK_SIZE 512
typedef char aufs_deblk_t[AUFS_DEBLK_SIZE];
#if AUFS_DEBLK_SIZE < NAME_MAX || PAGE_SIZE < AUFS_DEBLK_SIZE
#error invalid size DEBLK_SIZE
#endif

#define AUFS_NHASH_SIZE	12
struct aufs_nhash {
	struct hlist_head heads[AUFS_NHASH_SIZE];
};

struct aufs_destr {
	unsigned char	len;
	char		name[0];
} __attribute__ ((packed));

struct aufs_dehstr {
	struct hlist_node hash;
	struct aufs_destr *str;
};

struct aufs_de {
	ino_t			de_ino;
	unsigned char		de_type;
	//caution: packed
	struct aufs_destr	de_str;
} __attribute__ ((packed));

struct aufs_wh {
	struct hlist_node	wh_hash;
	aufs_bindex_t		wh_bindex;
	struct aufs_destr	wh_str;
} __attribute__ ((packed));

union aufs_deblk_p {
	unsigned char	*p;
	aufs_deblk_t	*deblk;
	struct aufs_de	*de;
};

struct aufs_vdir {
	int		vd_nblk;
	aufs_deblk_t	**vd_deblk;
	struct {
		int			i;
		union aufs_deblk_p	p;
	} vd_last;

	unsigned long	vd_version;
	unsigned long	vd_jiffy;
};

/* ---------------------------------------------------------------------- */

static inline int n_hash(char *name, int namelen)
{
	//return namelen%AUFS_NHASH_SIZE;
	return full_name_hash(name, namelen)%AUFS_NHASH_SIZE;
}

/* ---------------------------------------------------------------------- */

//dir.c
extern struct file_operations aufs_dir_fop;
int check_empty_lower(struct dentry *dentry);
int check_empty(struct dentry *dentry, struct aufs_nhash *whlist);

//vdir.c
void init_nhash(struct aufs_nhash *nhash);
void free_whlist(struct aufs_nhash *whlist);
int is_longer_wh(struct aufs_nhash *whlist, aufs_bindex_t btgt, int limit);
int test_known_wh(struct aufs_nhash *whlist, char *name, int namelen);
int append_wh(struct aufs_nhash *whlist, char *name, int namelen,
	      aufs_bindex_t bindex);
void free_vdir(struct aufs_vdir *vdir);
int init_vdir(struct file *file);
int fill_de(struct file *file, void *dirent, filldir_t filldir);

#endif /* __KERNEL__ */
#endif /* __AUFS_DIR_H__ */
