/*
 * Copyright (C) 2005-2006 Junjiro Okajima
 *
 * This program, aufs is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/* $Id: wh.h,v 1.7 2006/08/07 14:50:22 sfjro Exp $ */

#ifndef __AUFS_WH_H__
#define __AUFS_WH_H__

#include <linux/fs.h>
#include <linux/aufs_type.h>

#define WHPFX	".wh."
#define WHLEN	4

#ifdef __KERNEL__

int alloc_whname(const char *name, int len, struct qstr *wh);
void free_whname(struct qstr *wh);

int is_wh(struct dentry *hidden_parent, struct qstr *wh_name);
int is_diropq(struct dentry *hidden_dentry);

struct dentry *lookup_whtmp(struct dentry *hidden_parent, struct qstr *prefix);
int rename_whtmp(struct dentry *hidden_parent, struct dentry *hidden_dentry);
int unlink_wh_dentry(struct inode *hidden_dir, struct dentry *wh_dentry,
		     struct dentry *dentry);

int init_wh(struct dentry *hidden_parent, struct aufs_branch *br);
struct dentry *do_diropq(struct dentry *dentry, aufs_bindex_t bindex,
			 int do_create);
#define create_diropq(dentry, bindex)	do_diropq(dentry, bindex, 1)
#define remove_diropq(dentry, bindex)	PTR_ERR(do_diropq(dentry, bindex, 0))

struct dentry *lookup_wh(struct dentry *hidden_parent, struct qstr *base_name);
struct dentry *simple_create_wh(struct dentry *dentry, aufs_bindex_t bindex,
				struct dentry *hidden_parent);

int do_delete_whiteouts(struct aufs_nhash *whlist, struct dentry *hidden_parent,
			aufs_bindex_t bindex);

struct superio {
	uid_t fsuid;
	struct __user_cap_data_struct cap;
	unsigned long rlim_core;
	//unsigned long flags;
};
int superio_store(struct superio *sio);
void superio_revert(struct superio *sio);
int superio_test(struct inode *hidden_inode, int mask);

struct rmdir_whtmp_arg {
	struct dentry *hidden_dentry;
	struct aufs_nhash whlist;
	aufs_bindex_t bindex;
	struct inode *dir;
	int do_lock;
};
int rmdir_whtmp(struct dentry *hidden_dentry, struct aufs_nhash *whlist,
		aufs_bindex_t bindex, struct inode *dir, int do_lock);
int rmdir_whtmp_start(struct rmdir_whtmp_arg *arg);

#endif /* __KERNEL__ */
#endif /* __AUFS_WH_H__ */
