
########################################
# fake Kconfig
CONFIG_AUFS = m
# CONFIG_AUFS_DEBUG =
CONFIG_AUFS_FAKE_DM = y
CONFIG_AUFS_COMPAT = y
#CONFIG_AUFS_NO_KSIZE = y	# uncomment if you didn't apply the 'ksize' patch

AUFS_DEF_CONFIG =
ifdef CONFIG_AUFS_DEBUG
AUFS_DEF_CONFIG += -DCONFIG_AUFS_DEBUG
endif
ifdef CONFIG_AUFS_FAKE_DM
AUFS_DEF_CONFIG += -DCONFIG_AUFS_FAKE_DM
endif
ifdef CONFIG_AUFS_COMPAT
AUFS_DEF_CONFIG += -DCONFIG_AUFS_COMPAT
endif
ifdef CONFIG_AUFS_NO_KSIZE
AUFS_DEF_CONFIG += -DCONFIG_AUFS_NO_KSIZE
endif

EXTRA_CFLAGS += -Werror
EXTRA_CFLAGS += -I ${CURDIR}/include
EXTRA_CFLAGS += ${AUFS_DEF_CONFIG}
EXTRA_CFLAGS += -DLKTRHidePrePath=\"${CURDIR}/fs/aufs\"
export

########################################
# fake top level make

Tgt = aufs.ko aufs.5 aufind.sh mount.aufs
ifdef CONFIG_AUFS_COMPAT
Tgt += unionctl mount.unionfs
endif

all: ${Tgt}
FORCE:

include ${CURDIR}/fs/aufs/Makefile
KDIR = /lib/modules/$(shell uname -r)/build

aufs.ko: fs/aufs/aufs.ko
	test ! -e $@ && ln -s $< $@ || :
fs/aufs/aufs.ko: FORCE
	${MAKE} -C ${KDIR} SUBDIRS=${CURDIR}/fs/aufs modules

########################################
clean:
	${MAKE} -C ${KDIR} SUBDIRS=${CURDIR}/fs/aufs $@
	${MAKE} -C util $@
	${RM} ${Tgt}
	${RM} cg TAGS *~ .*~ fs/aufs/*~ fs/aufs/.*~ include/linux/*~ include/linux/.*~

util/%:
	${MAKE} -C util
aufind.sh: util/aufind.sh
	ln -s $< $@
aufs.5: util/aufs.5
	ln -s $< $@
mount.aufs: util/mount.aufs
	test -x $< || chmod a+x $<
	ln -s $< $@
unionctl: util/unionctl
	ln -s $< $@
mount.unionfs: ./mount.aufs
	ln -s $< $@

########################################
# sourceforge.net
index.html: README sflogo.html
	{ echo '<html><body>'; \
		cat sflogo.html; \
		echo '<pre>'; \
		cat README; \
		echo '</pre>'; \
	echo '</body></html>'; } > $@
#	scp -p $@ shell.sourceforge.net:/home/groups/a/au/aufs/htdocs/

########################################
export CGOUT=${CURDIR}/cg
nullcgout:
	> ${CGOUT}
callgraph: MAKEFLAGS += C=1 CHECK=callgraph.sh
callgraph: nullcgout all
cg: callgraph

tags: TAGS
TAGS: fs/aufs/*.[ch] include/linux/*.h
	etags $^

spell: README util/aufs.in.5
	spell $< | sort | uniq
