/*
 * Copyright (C) 2005-2006 Junjiro Okajima
 *
 * This program, aufs is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/* $Id: dentry.h,v 1.7 2006/07/17 02:26:33 sfjro Exp $ */

#ifndef __AUFS_DENTRY_H__
#define __AUFS_DENTRY_H__

#include <linux/fs.h>
#include <linux/aufs_type.h>
#include "misc.h"

#ifdef __KERNEL__

struct aufs_dinfo {
	struct aufs_rwsem	di_rwsem;
	struct dentry		**di_dentry;
	aufs_bindex_t		di_bstart, di_bend;
	aufs_bindex_t		di_bwh, di_bdiropq;

	atomic_t		di_generation; //int??
};

#define DiMustReadLock(d)	do{ \
	SiMustAnyLock((d)->d_sb); \
	RwMustReadLock(&dtopd(d)->di_rwsem); \
	}while(0)
#define DiMustWriteLock(d)	do{ \
	SiMustAnyLock((d)->d_sb); \
	RwMustWriteLock(&dtopd(d)->di_rwsem); \
	}while(0)
#define DiMustAnyLock(d)	do{ \
	SiMustAnyLock((d)->d_sb); \
	RwMustAnyLock(&dtopd(d)->di_rwsem); \
	}while(0)

#define digen(d)	atomic_read(&dtopd(d)->di_generation)

/* ---------------------------------------------------------------------- */

extern struct dentry_operations aufs_dop;
int lookup_dentry(struct dentry *dentry, aufs_bindex_t bstart, mode_t type);
int lookup_negative(struct dentry *dentry, aufs_bindex_t bindex);
int refresh_dentry(struct dentry *dentry, mode_t type);
int reval_dpath(struct dentry *dentry, int sgen);

//dinfo.c
int alloc_dinfo(struct dentry *dentry);
struct aufs_dinfo *dtopd(struct dentry *dentry);

void di_read_lock(struct dentry *d, int flags);
void di_read_unlock(struct dentry *d, int flags);
void di_downgrade_lock(struct dentry *d, int flags);
void di_write_lock(struct dentry *d);
void di_write_unlock(struct dentry *d);
void di_write_lock2(struct dentry *d1, struct dentry *d2, int isdir);
void di_write_unlock2(struct dentry *d1, struct dentry *d2);

aufs_bindex_t dbstart(struct dentry *dentry);
aufs_bindex_t dbend(struct dentry *dentry);
aufs_bindex_t dbwh(struct dentry *dentry);
aufs_bindex_t dbdiropq(struct dentry *dentry);
struct dentry *dtohd_index(struct dentry *dentry, aufs_bindex_t bindex);
struct dentry *dtohd(struct dentry *dentry);

aufs_bindex_t dbtail(struct dentry *dentry);
aufs_bindex_t dbtaildir(struct dentry *dentry);
aufs_bindex_t dbtail_generic(struct dentry *dentry);

void set_dbstart(struct dentry *dentry, aufs_bindex_t bindex);
void set_dbend(struct dentry *dentry, aufs_bindex_t bindex);
void set_dbwh(struct dentry *dentry, aufs_bindex_t bindex);
void set_dbdiropq(struct dentry *dentry, aufs_bindex_t bindex);
void set_dtohd_index(struct dentry *dentry, aufs_bindex_t bindex,
		     struct dentry *val);

void update_digen(struct dentry *dentry);
void update_bstart(struct dentry *dentry);
aufs_bindex_t find_dbindex(struct dentry *dentry, struct dentry *hidden_dentry);

#endif /* __KERNEL__ */
#endif /* __AUFS_DENTRY_H__ */
