/*
 * Copyright (C) 2005-2006 Junjiro Okajima
 *
 * This program, aufs is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/* $Id: aufs_type.h,v 1.15 2006/08/07 14:52:32 sfjro Exp $ */

#ifndef __AUFS_TYPE_H__
#define __AUFS_TYPE_H__

#define AUFS_VERSION	"20060807"

/* ---------------------------------------------------------------------- */

typedef char aufs_bindex_t;
//typedef int aufs_bindex_t;
#define AUFS_BRANCH_MAX 127

#define AUFS_NAME	"aufs"
#ifdef CONFIG_AUFS_COMPAT
#define AUFS_FSTYPE	"unionfs"
#define DIROPQ_NAME	"__dir_opaque"
#else
#define AUFS_FSTYPE	AUFS_NAME
#define DIROPQ_NAME	".aufs.dopq" // make it whiteouted doubly
#endif

/* ---------------------------------------------------------------------- */

/* branch permission flags */
/*
 * NFS: handle EACCES from nfs exported as readonly, as EROFS.
 * WH: whiteout may exist on readonly branch.
 */
#define AUFS_BRPERM_BASE	MAY_APPEND /* last defined in linux/fs.h */
#define AUFS_MAY_WH		(AUFS_BRPERM_BASE<<1)

#define AUFS_BRPERM_MASK	(MAY_WRITE|MAY_READ|AUFS_MAY_WH)

#define AUFS_BRPERM_STR_RW	"rw"
#define AUFS_BRPERM_STR_RO	"ro"
#define AUFS_BRPERM_STR_WH	"wh"

#endif /* __AUFS_TYPE_H__ */
