# ********************************************************************
# Include specifics.
# ********************************************************************

include $(PRJ).inc

# ********************************************************************
# Directories specifics.
# ********************************************************************

ENV_DIR			= $(APPS_DIR)/env
IO_DIR			= $(APPS_DIR)/io

ifeq ($(Logo_Source), FLASH)
  LOGO_DISP_DIR	= $(APPS_DIR)/logo_disp
  LOGO_DISP_INC_DIR	= $(LOGO_DISP_DIR)
else
  LOGO_DISP_DIR	= $(NULL_DIR)
  LOGO_DISP_INC_DIR	= $(APPS_DIR)/logo_disp
endif

MAIN_DIR		= $(APPS_DIR)/main

ifeq ($(Board_LAN), NULL)
  NET_DIR		= $(NULL_DIR)
  NET_INC_DIR	= $(APPS_DIR)/net
else
  NET_DIR		= $(APPS_DIR)/net
  NET_INC_DIR	= $(NET_DIR)
endif

SHELL_DIR		= $(APPS_DIR)/shell
SHELL_PROD_DIR	= $(SHELL_DIR)/product/$(Board_Product)
COMMANDS_DIR	= $(SHELL_DIR)/commands
SREC_LOADER_DIR	= $(APPS_DIR)/srec_loader
SYSCON_DIR		= $(APPS_DIR)/syscon
SYSENV_DIR		= $(APPS_DIR)/sysenv

# ********************************************************************
# Modules compile specifics.
# ********************************************************************
ENV:
	cd $(ENV_DIR);\
	make CC=$(CC) CFLAG='$(CFLAG)' AFLAG='$(AFLAG)' CDEF='$(CDEF)' ADEF='$(ADEF)' OBJ_DIR='$(OBJ_DIR)'\
	     INCLUDE='$(INCLUDE) -I$(SYSCON_DIR) -I$(RS232_DIR) -I$(SYSENV_DIR) -I$(SHELL_DIR) -I$(PLATFORM_INCLUDE_DIR)'

IO:
	cd $(IO_DIR);\
	make CC=$(CC) CFLAG='$(CFLAG)' AFLAG='$(AFLAG)' CDEF='$(CDEF)' ADEF='$(ADEF)' OBJ_DIR='$(OBJ_DIR)'\
	     INCLUDE='$(INCLUDE) -I$(SYSCON_DIR) -I$(PLATFORM_INCLUDE_DIR) -I$(RS232_DIR)'

LOGO_DISP:
	cd $(LOGO_DISP_DIR);\
	make CC=$(CC) CFLAG='$(CFLAG)' AFLAG='$(AFLAG)' CDEF='$(CDEF)' ADEF='$(ADEF)' TARGET='LOGO_DISP' OBJ_DIR='$(OBJ_DIR)' Logo_Type='$(Logo_Type)' Board_CPU='$(Board_CPU)' Board_HDMI='$(Board_HDMI)'\
	     INCLUDE='$(INCLUDE) -I$(PLATFORM_INCLUDE_DIR) -I$(RS232_DIR)'

MAIN:
	cd $(MAIN_DIR);\
	make CC=$(CC) CFLAG='$(CFLAG)' AFLAG='$(AFLAG)' CDEF='$(CDEF)' ADEF='$(ADEF)' OBJ_DIR='$(OBJ_DIR)'\
	     INCLUDE='$(INCLUDE) -I$(FLASH_DIR) -I$(IO_DIR) -I$(SYSCON_DIR) -I$(PLATFORM_INCLUDE_DIR) -I$(RS232_DIR) -I$(ENV_DIR) -I$(SHELL_DIR) -I$(PLATFORM_INCLUDE_DIR) -I$(TIMER_DIR) -I$(SYSENV_DIR) -I$(GPIO_DIR) -I$(RTC_INC_DIR) -I$(ETH_INC_DIR) -I$(NET_INC_DIR) -I$(IDE_INC_DIR) -I$(LOGO_DISP_INC_DIR)'

NET:
	cd $(NET_DIR);\
	make CC=$(CC) CFLAG='$(CFLAG)' AFLAG='$(AFLAG)' CDEF='$(CDEF)' ADEF='$(ADEF)' TARGET='NET' OBJ_DIR='$(OBJ_DIR)'\
	     INCLUDE='$(INCLUDE) -I$(ETH_INC_DIR) -I$(FLASH_DIR) -I$(IO_DIR) -I$(SYSCON_DIR) -I$(RS232_DIR) -I$(RTC_INC_DIR) -I$(SHELL_DIR) -I$(PLATFORM_INCLUDE_DIR)'

SHELL:
	cd $(SHELL_DIR);\
	make CC=$(CC) CFLAG='$(CFLAG)' AFLAG='$(AFLAG)' CDEF='$(CDEF)' ADEF='$(ADEF)' OBJ_DIR='$(OBJ_DIR)'\
	     RESCUE_FLAG='$(RESCUE_FLAG)' LINUX_FLAG='$(LINUX_FLAG)' SHELL_FLAG='$(SHELL_FLAG)' Rescue_Source='$(Rescue_Source)' Linux_Source='$(Linux_Source)'\
	     INCLUDE='$(INCLUDE) -I$(IDE_INC_DIR) -I$(SYSENV_DIR) -I$(ENV_DIR) -I$(FLASH_DIR) -I$(IO_DIR) -I$(SYSCON_DIR) -I$(RS232_DIR) -I$(PLATFORM_INCLUDE_DIR) -I$(SHELL_PROD_DIR) -I$(VFD_DIR)'

SHELL_PROD:
	cd $(SHELL_PROD_DIR);\
		make CC=$(CC) CFLAG='$(CFLAG)' AFLAG='$(AFLAG)' CDEF='$(CDEF)' ADEF='$(ADEF)' OBJ_DIR='$(OBJ_DIR)'\
	     RESCUE_FLAG='$(RESCUE_FLAG)' LINUX_FLAG='$(LINUX_FLAG)' SHELL_FLAG='$(SHELL_FLAG)' Rescue_Source='$(Rescue_Source)' Linux_Source='$(Linux_Source)' Config_QC_Test_Prog='$(Config_QC_Test_Prog)'\
	     INCLUDE='$(INCLUDE) -I$(IDE_INC_DIR) -I$(SYSENV_DIR) -I$(ENV_DIR) -I$(FLASH_DIR) -I$(IO_DIR) -I$(SYSCON_DIR) -I$(RS232_DIR) -I$(PLATFORM_INCLUDE_DIR) -I$(SHELL_DIR) -I$(RTC_DIR)'


COMMANDS:
	cd $(COMMANDS_DIR);\
	make CC=$(CC) CFLAG='$(CFLAG)' AFLAG='$(AFLAG)' CDEF='$(CDEF)' ADEF='$(ADEF)' PRJ_INC_FILE='$(PWD)/$(PRJ).inc' OBJ_DIR='$(OBJ_DIR)' \
	     INCLUDE='$(INCLUDE) -I$(SHELL_DIR) -I$(SYSCON_DIR) -I$(ENV_DIR) -I$(SYSENV_DIR) -I$(RS232_DIR) -I$(PLATFORM_INCLUDE_DIR) -I$(NET_INC_DIR) -I$(IO_DIR) -I$(FLASH_DIR) -I$(IDE_INC_DIR) -I$(ISO9660_DIR) -I$(ETH_INC_DIR)' 

SYSCON:
	cd $(SYSCON_DIR);\
	make CC=$(CC) CFLAG='$(CFLAG)' AFLAG='$(AFLAG)' CDEF='$(CDEF)' ADEF='$(ADEF)' OBJ_DIR='$(OBJ_DIR)'\
	     INCLUDE='$(INCLUDE) -I$(RS232_DIR) -I$(ENV_DIR) -I$(SYSENV_DIR) -I$(IO_DIR) -I$(PLATFORM_INCLUDE_DIR) -I$(NET_DIR)'

SYSENV:
	cd $(SYSENV_DIR);\
	make CC=$(CC) CFLAG='$(CFLAG)' AFLAG='$(AFLAG)' CDEF='$(CDEF)' ADEF='$(ADEF)' OBJ_DIR='$(OBJ_DIR)'\
	     INCLUDE='$(INCLUDE) -I$(SYSCON_DIR) -I$(IO_DIR) -I$(FLASH_DIR) -I$(RS232_DIR) -I$(PLATFORM_INCLUDE_DIR)'
