
/************************************************************************
 *
 *  env_platform.c
 *
 *  Platform specific part of ENV module (shell environment variables)
 *
 * ######################################################################
 *
 * mips_start_of_legal_notice
 * 
 * Copyright (c) 2003 MIPS Technologies, Inc. All rights reserved.
 *
 *
 * Unpublished rights (if any) reserved under the copyright laws of the
 * United States of America and other countries.
 *
 * This code is proprietary to MIPS Technologies, Inc. ("MIPS
 * Technologies"). Any copying, reproducing, modifying or use of this code
 * (in whole or in part) that is not expressly permitted in writing by MIPS
 * Technologies or an authorized third party is strictly prohibited. At a
 * minimum, this code is protected under unfair competition and copyright
 * laws. Violations thereof may result in criminal penalties and fines.
 *
 * MIPS Technologies reserves the right to change this code to improve
 * function, design or otherwise. MIPS Technologies does not assume any
 * liability arising out of the application or use of this code, or of any
 * error or omission in such code. Any warranties, whether express,
 * statutory, implied or otherwise, including but not limited to the implied
 * warranties of merchantability or fitness for a particular purpose, are
 * excluded. Except as expressly provided in any written license agreement
 * from MIPS Technologies or an authorized third party, the furnishing of
 * this code does not give recipient any license to any intellectual
 * property rights, including any patent rights, that cover this code.
 *
 * This code shall not be exported or transferred for the purpose of
 * reexporting in violation of any U.S. or non-U.S. regulation, treaty,
 * Executive Order, law, statute, amendment or supplement thereto.
 *
 * This code constitutes one or more of the following: commercial computer
 * software, commercial computer software documentation or other commercial
 * items. If the user of this code, or any related documentation of any
 * kind, including related technical data or manuals, is an agency,
 * department, or other entity of the United States government
 * ("Government"), the use, duplication, reproduction, release,
 * modification, disclosure, or transfer of this code, or any related
 * documentation of any kind, is restricted in accordance with Federal
 * Acquisition Regulation 12.212 for civilian agencies and Defense Federal
 * Acquisition Regulation Supplement 227.7202 for military agencies. The use
 * of this code by the Government is further restricted in accordance with
 * the terms of the license agreement(s) and/or applicable contract terms
 * and conditions covering this code from MIPS Technologies or an authorized
 * third party.
 *
 * 
 * mips_end_of_legal_notice
 * 
 *
 ************************************************************************/


/************************************************************************
 *  Include files
 ************************************************************************/

#include <sysdefs.h>
#include <sys_api.h>
#include <syscon_api.h>
#include <env_api.h>
#include <env.h>
#include <product.h>

#include <syserror.h>
#include <stdio.h>
#include <string.h>

#include <extern_param.h>

/************************************************************************
 *  Definitions
 ************************************************************************/

/************************************************************************
 *  Public variables
 ************************************************************************/
UINT32 env_ethaddr;
UINT32 env_ipaddr;
UINT32 env_subnetmask;
UINT32 env_gateway;

extern t_extern_param *ext_para_ptr;

/************************************************************************
 *  Static variables
 ************************************************************************/

/* Default settings of env. variables */
static char  *default_mac           = "00.ff.ff.ff.ff.ff";  
static char  *default_ip            = "192.168.0.1";
static char  *default_subnetmask    = "255.0.0.0";
static char  *default_gateway       = "192.168.0.254";

static char  *env_mac               = "ethaddr";
static char  *env_sn                = "baseboardserial";

/************************************************************************
 *  Static function prototypes
 ************************************************************************/

/************************************************************************
 *  Implementation : Static functions
 ************************************************************************/




/************************************************************************
 *
 *                          ipaddr_ip_s2num
 *  Description :
 *  -------------
 *
 *  Decode a string of format x.y.z.w to 4 bytes.
 *  In case of success, the result is stored in a global variable.
 *
 *  Return values :
 *  ---------------
 *
 *  TRUE -> OK, FALSE -> Failed
 *
 ************************************************************************/
static bool 
ipaddr_ip_s2num( 
    char   *raw,            /* The string               */
    void   *decoded,        /* Decoded data             */
    UINT32 size )           /* Size of decoded data     */
{
    bool rc;

    if (decoded)
    {
        rc = env_ip_s2num(raw, decoded, size);
        if (rc == TRUE)
        {
            env_ipaddr = *(UINT32*)decoded;
        }
    }
    return env_ip_s2num(raw, &env_ipaddr, sizeof(env_ipaddr));
}


/************************************************************************
 *
 *                          gateway_ip_s2num
 *  Description :
 *  -------------
 *
 *  Decode a string of format x.y.z.w to 4 bytes.
 *  In case of success, the result is stored in a global variable.
 *
 *  Return values :
 *  ---------------
 *
 *  TRUE -> OK, FALSE -> Failed
 *
 ************************************************************************/
static bool 
gateway_ip_s2num( 
    char   *raw,            /* The string               */
    void   *decoded,        /* Decoded data             */
    UINT32 size )           /* Size of decoded data     */
{
    bool rc;

    if (decoded)
    {
        rc = env_ip_s2num(raw, decoded, size);
        if (rc == TRUE)
        {
            env_gateway = *(UINT32*)decoded;
        }
    }
    return env_ip_s2num(raw, &env_gateway, sizeof(env_gateway));
}


/************************************************************************
 *
 *                          subnetmask_ip_s2num
 *  Description :
 *  -------------
 *
 *  Decode a string of format x.y.z.w to 4 bytes.
 *  In case of success, the result is stored in a global variable.
 *
 *  Return values :
 *  ---------------
 *
 *  TRUE -> OK, FALSE -> Failed
 *
 ************************************************************************/
static bool 
subnetmask_ip_s2num( 
    char   *raw,            /* The string               */
    void   *decoded,        /* Decoded data             */
    UINT32 size )           /* Size of decoded data     */
{
    bool rc;

    if (decoded)
    {
        rc = env_ip_s2num(raw, decoded, size);
        if (rc == TRUE)
        {
            env_subnetmask = *(UINT32*)decoded;
        }
        return rc;
    }
    return env_ip_s2num(raw, &env_subnetmask, sizeof(env_subnetmask));
}


/************************************************************************
 *  Implementation : Public functions
 ************************************************************************/


/************************************************************************
 *
 *                          env_setup_env_board
 *  Description :
 *  -------------
 *
 *  Create board specific system environment variables
 *
 *  Return values :
 *  ---------------
 *
 *  TRUE -> OK, else FALSE
 *
 ************************************************************************/
bool env_setup_env_board()
{
    char       msg[40];
    char       *raw;
    t_sn_ascii sn;
    t_mac_addr mac_addr;
    UINT32     rc = TRUE;
    int i;
    unsigned char *p_mac = &(ext_para_ptr->mac_hi);

    default_subnetmask = default_subnetmask;
    default_gateway    = default_gateway;
    sprintf(msg, "%02x.%02x.%02x.%02x.%02x.%02x\0", p_mac[3], p_mac[2], p_mac[1], 
                                            p_mac[0], p_mac[7], p_mac[6]);

	/* MAC address */
	if(!env_get( "ethaddr", &raw, NULL, 0 ) )
	    raw = msg;		  /* Create new */
	
	if( env_set( "ethaddr", raw, ENV_ATTR_RW, 
		             raw, env_mac_s2num ) != OK )
    {
    	rc = FALSE;
	}
	
	/* IP address */
    if(!env_get( "ipaddr", &raw, NULL, 0 ) )
	    raw = default_ip;		  /* Create new */
	    
    if( env_set( "ipaddr", raw, ENV_ATTR_RW, 
		         default_ip, ipaddr_ip_s2num ) != OK )
	{   
	    rc = FALSE;
	}
        
	/* Subnet mask  */
    if(  !env_get( "subnetmask", &raw, NULL, 0 ) )
	    raw = default_subnetmask;	  /* Create new */
	    
    if( env_set( "subnetmask", raw, ENV_ATTR_RW, 
		          default_subnetmask, subnetmask_ip_s2num ) != OK )
	{
	    rc = FALSE;
	}
        
	/* Default gateway */
    if( !env_get( "gateway", &raw, NULL, 0 ) )
	    raw = default_gateway;	  /* Create new */
    if( env_set( "gateway", raw, ENV_ATTR_RW, 
	    	     default_gateway, gateway_ip_s2num ) != OK )
	{
	    rc = FALSE;
	}

    return rc;

}


/************************************************************************
 *
 *                          env_decode_bootprot
 *  Description :
 *  -------------
 *
 *  Decode boot protocol (currently tftp or asc)
 *  (not all protocols legal on all platforms)
 *
 *  Return values :
 *  ---------------
 *
 *  TRUE -> OK, FALSE -> Failed
 *
 ************************************************************************/
bool 
env_decode_bootprot( 
    char   *raw,		/* The string				*/
    void   *decoded,		/* Decoded data				*/
    UINT32 size )		/* Size of decoded data			*/
{
    if( decoded && (size != sizeof(UINT32)) )
        return FALSE;

    if( strcmp( raw, "tftp" ) == 0 )
    {
        
	if( decoded )
            *(UINT32 *)decoded = PROTOCOL_TFTP;
	return TRUE;
       
    }
    else if( strcmp( raw, "asc" ) == 0 )
    {
        if( decoded )
            *(UINT32 *)decoded = PROTOCOL_ASC;
	return TRUE;
    }
  
    else
        return FALSE;
}

