/************************************************************************
 *
 *  logo_disp.c
 *
 *  Belong to logo_disp module
 *
 *  This module implements logo display function for VENUS
 *
 ************************************************************************/

/************************************************************************
 *  Include files
 ************************************************************************/

#include <string.h>
#include <sys_api.h>
#include <stdio.h>
#include <extern_param.h>

#include <logo_disp_api.h>
#include <project_config.h>

/************************************************************************
 *  Public variables
 ************************************************************************/

extern int _f_pattern_img, _e_pattern_img; 
extern int _f_isrvideo_img, _e_isrvideo_img;
extern int _f_rosbootvector_img, _e_rosbootvector_img;

extern t_extern_param *ext_para_ptr;

/************************************************************************
 *  Implementation : Global functions
 ************************************************************************/
#if defined(Logo_Type_ALL)
void  LOGO_DISP_setup(t_extern_param *logo_param_ptr)
{
	if ( logo_param_ptr->logo_type == 0)
	{
	  printf("NTSC logo\n");
	  LOGO_DISP_525p(logo_param_ptr);
	}  
	else
	{
	  printf("PAL logo\n");
	  LOGO_DISP_625p(logo_param_ptr);
	}
}
#endif

INT32 LOGO_DISP_init(void)
{
	unsigned char *a,*b;
    
	a = (unsigned char *)&_e_pattern_img;
	b = (unsigned char *)&_f_pattern_img;
	memcpy((unsigned char *)0xa0000080, b, a-b);
    
	a = (unsigned char *)&_e_isrvideo_img;
	b = (unsigned char *)&_f_isrvideo_img;
	memcpy((unsigned char *)0xa0001800, b, a-b);
    
	a = (unsigned char *)&_e_rosbootvector_img;
	b = (unsigned char *)&_f_rosbootvector_img;
	memcpy((unsigned char *)0xa0001900, b, a-b);

	/* copy logo to a00f0000 , max size is 0x2000 */
	b = (unsigned char *)ext_para_ptr->logo_img_saddr;
	memcpy((unsigned char *)0xa00f0000, b, ext_para_ptr->logo_img_len);
      
	sys_sync();

    LOGO_DISP_setup( ext_para_ptr );
	
	return OK;
}


void LOGO_DISP_change(UINT32 logo_no)
{	
	if (logo_no == 0)
	{
		
		memcpy((unsigned char *)0xa00f0000, 
		       (unsigned char *)ext_para_ptr->logo_img_saddr,
		                        ext_para_ptr->logo_img_len);

		*(volatile unsigned int *)0xb8005370 = ext_para_ptr->logo_reg_5370; //0x6ba53f ;
    	*(volatile unsigned int *)0xb8005374 = ext_para_ptr->logo_reg_5374; //0x6da555 ;
	    *(volatile unsigned int *)0xb8005378 = ext_para_ptr->logo_reg_5378; //0x749889 ;
    	*(volatile unsigned int *)0xb800537c = ext_para_ptr->logo_reg_537c; //0x8080eb ;
    	
    	*(volatile unsigned int *)0xb8005534 = 0xf0000 + ext_para_ptr->logo_offset ;//0xf08dc ;
	}
	else if ((logo_no == 1) && (ext_para_ptr->logo2_img_len != 0))
	{
		memcpy((unsigned char *)0xa00f0000, 
		       (unsigned char *)ext_para_ptr->logo2_img_saddr,
		                        ext_para_ptr->logo2_img_len);
	
		*(volatile unsigned int *)0xb8005370 = ext_para_ptr->logo2_reg_5370; //0x6ba53f ;
	   	*(volatile unsigned int *)0xb8005374 = ext_para_ptr->logo2_reg_5374; //0x6da555 ;
	   	*(volatile unsigned int *)0xb8005378 = ext_para_ptr->logo2_reg_5378; //0x749889 ;
	    *(volatile unsigned int *)0xb800537c = ext_para_ptr->logo2_reg_537c; //0x8080eb ;
	    
	   	*(volatile unsigned int *)0xb8005534 = 0xf0000 + ext_para_ptr->logo2_offset ;//0xf08dc ;
	}
	else if (ext_para_ptr->logo3_img_len != 0)
	{
		memcpy((unsigned char *)0xa00f0000, 
		       (unsigned char *)ext_para_ptr->logo3_img_saddr,
		                        ext_para_ptr->logo3_img_len);

		*(volatile unsigned int *)0xb8005370 = ext_para_ptr->logo3_reg_5370; //0x6ba53f ;
    	*(volatile unsigned int *)0xb8005374 = ext_para_ptr->logo3_reg_5374; //0x6da555 ;
    	*(volatile unsigned int *)0xb8005378 = ext_para_ptr->logo3_reg_5378; //0x749889 ;
	    *(volatile unsigned int *)0xb800537c = ext_para_ptr->logo3_reg_537c; //0x8080eb ;
	    
    	*(volatile unsigned int *)0xb8005534 = 0xf0000 + ext_para_ptr->logo3_offset ;//0xf08dc ;
	}	
	
	sys_sync();
	
}

