/************************************************************************
 *
 *  logo_disp_nep_525i.c
 *
 *  Belong to logo_disp module
 *
 *  This file implements logo display function in NTSC mode
 *
 ************************************************************************/

/************************************************************************
 *  Include files
 ************************************************************************/

#include <string.h>
#include <sys_api.h>
#include <stdio.h>
#include <extern_param.h>

#include <logo_disp_api.h>
#include <project_config.h>

/************************************************************************
 *  Implementation : Private functions
 ************************************************************************/

#if defined(Logo_Type_NTSC)
void  LOGO_DISP_setup(t_extern_param *logo_param_ptr)
{
	printf("NTSC logo\n");
	LOGO_DISP_525p(logo_param_ptr);
}

void  LOGO_DISP_525p(t_extern_param *logo)
{

// set VO registers

    *(volatile unsigned int *)0xb8005350 = 0xfffffffe ;
    *(volatile unsigned int *)0xb8005350 = 0x3 ;
    *(volatile unsigned int *)0xb8005354 = 0x2cf ;
    *(volatile unsigned int *)0xb8005358 = 0x2ef5df ;
    *(volatile unsigned int *)0xb800535c = 0xffff3210 ;
    *(volatile unsigned int *)0xb8005360 = 0x0 ;


//color lookup table of Sub-Picture , index0~index3

    *(volatile unsigned int *)0xb8005370 = logo->logo_reg_5370; //0x6ba53f ;
    *(volatile unsigned int *)0xb8005374 = logo->logo_reg_5374; //0x6da555 ;
    *(volatile unsigned int *)0xb8005378 = logo->logo_reg_5378; //0x749889 ;
    *(volatile unsigned int *)0xb800537c = logo->logo_reg_537c; //0x8080eb ;
    *(volatile unsigned int *)0xb80053b0 = 0xacf800 ;
    *(volatile unsigned int *)0xb80053b4 = 0x9df800 ;

     *(volatile unsigned int *)0xb80056cc = 0x4000 ;          /* m */
    *(volatile unsigned int *)0xb80056d0 = 0x0 ;             /* m */
    
    
    *(volatile unsigned int *)0xb80056c8 = 0x2 ;             /* m */

    *(volatile unsigned int *)0xb80056fc = 0x4000 ;          /* m */
    *(volatile unsigned int *)0xb8005700 = 0x0 ;             /* m */
    
    
    *(volatile unsigned int *)0xb80056f4 = 0x2 ;             /* m */


    *(volatile unsigned int *)0xb80054b0 = 0x9dfacf ;
    *(volatile unsigned int *)0xb80054e8 = 0x2001400 ;
    *(volatile unsigned int *)0xb80054ec = 0x2001000 ;
    *(volatile unsigned int *)0xb80054f0 = 0x2001400 ;
    *(volatile unsigned int *)0xb80054f4 = 0x2001000 ;
    *(volatile unsigned int *)0xb80054f8 = 0x400 ;
    *(volatile unsigned int *)0xb80054fc = 0x20080200 ;
    *(volatile unsigned int *)0xb8005500 = 0xf010eb10 ;
    *(volatile unsigned int *)0xb8005564 = 0x0 ;
    *(volatile unsigned int *)0xb8005568 = 0x1 ;
    *(volatile unsigned int *)0xb800556c = 0x2 ;
    *(volatile unsigned int *)0xb8005570 = 0x3 ;
    *(volatile unsigned int *)0xb8005574 = 0x4 ;
    *(volatile unsigned int *)0xb8005578 = 0x5 ;
    *(volatile unsigned int *)0xb800557c = 0x6 ;
    *(volatile unsigned int *)0xb8005580 = 0x7 ;
    *(volatile unsigned int *)0xb8005584 = 0x8 ;


//Top and Bot address of Sub-Picture 

    *(volatile unsigned int *)0xb8005530 = 0xf0000 ;
    *(volatile unsigned int *)0xb8005534 = 0xf0000 + logo->logo_offset ;//0xf08dc ;


// set TVE registers

    *(volatile unsigned int *)0xb8000084 = 0x101cd800 ;
    *(volatile unsigned int *)0xb800000c = 0x1 ;
    *(volatile unsigned int *)0xB80180C8 = 0x124 ;    
    *(volatile unsigned int *)0xB80180CC = 0x188 ;    
    *(volatile unsigned int *)0xB8018134 = 0x278000 ; 
    *(volatile unsigned int *)0xB80180D0 = 0x3FBBBB ; 
    *(volatile unsigned int *)0xB80180D4 = 0x3FCBBB ; 
    *(volatile unsigned int *)0xB80180E8 = 0x1 ;      
    *(volatile unsigned int *)0xB8018154 = 0x200 ;     
    *(volatile unsigned int *)0xB8018880 = 0x1F ;     
    *(volatile unsigned int *)0xB8018884 = 0x7C ;     
    *(volatile unsigned int *)0xB8018888 = 0xF0 ;     
    *(volatile unsigned int *)0xB801888C = 0x21 ;     
    *(volatile unsigned int *)0xB8018890 = 0x0 ;      
    *(volatile unsigned int *)0xB8018894 = 0x2 ;      
    *(volatile unsigned int *)0xB8018898 = 0x2 ;      
    *(volatile unsigned int *)0xB801889C = 0x3F ;     
    *(volatile unsigned int *)0xB80188A0 = 0x2 ;      
    *(volatile unsigned int *)0xB80188A8 = 0x8D ;     
    *(volatile unsigned int *)0xB80188AC = 0x78 ;     
    *(volatile unsigned int *)0xB80188B0 = 0x10 ;     
    *(volatile unsigned int *)0xB80188B4 = 0x7 ;      
    *(volatile unsigned int *)0xB80188B8 = 0x1C ;     
    *(volatile unsigned int *)0xB80188B8 = 0x1C ;     
    *(volatile unsigned int *)0xB8018984 = 0x20 ;     
    *(volatile unsigned int *)0xB801898C = 0x2 ;      
    *(volatile unsigned int *)0xB80188BC = 0x0 ;      
    *(volatile unsigned int *)0xB80188C8 = 0xC8 ;      
    *(volatile unsigned int *)0xB80188CC = 0x0 ;      
    *(volatile unsigned int *)0xB80188D0 = 0x0 ;      
    *(volatile unsigned int *)0xB80188E0 = 0x8 ;      
    *(volatile unsigned int *)0xB80188E4 = 0x31 ;     
    *(volatile unsigned int *)0xB80188E8 = 0x6 ;      
    *(volatile unsigned int *)0xB80188EC = 0x6 ;      
    *(volatile unsigned int *)0xB80188F0 = 0xB3 ;     
    *(volatile unsigned int *)0xB80188F4 = 0x3 ;      
    *(volatile unsigned int *)0xB80188F8 = 0x59 ;     
    *(volatile unsigned int *)0xB80189C0 = 0x64 ;     
    *(volatile unsigned int *)0xB80189C4 = 0x2D ;     
    *(volatile unsigned int *)0xB80189C8 = 0x7 ;      
    *(volatile unsigned int *)0xB80189CC = 0x18 ;     
    *(volatile unsigned int *)0xB8018920 = 0x0 ;      
    *(volatile unsigned int *)0xB8018924 = 0x3A ;     
    *(volatile unsigned int *)0xB8018928 = 0x11 ;     
    *(volatile unsigned int *)0xB801892C = 0x4B ;     
    *(volatile unsigned int *)0xB8018930 = 0x11 ;     
    *(volatile unsigned int *)0xB8018934 = 0x3C ;     
    *(volatile unsigned int *)0xB8018938 = 0x1B ;     
    *(volatile unsigned int *)0xB801893C = 0x1B ;     
    *(volatile unsigned int *)0xB8018940 = 0x24 ;     
    *(volatile unsigned int *)0xB8018944 = 0x7 ;      
    *(volatile unsigned int *)0xB8018948 = 0xF8 ;     
    *(volatile unsigned int *)0xB801894C = 0x0 ;      
    *(volatile unsigned int *)0xB8018950 = 0x0 ;      
    *(volatile unsigned int *)0xB8018954 = 0xF ;      
    *(volatile unsigned int *)0xB8018958 = 0xF ;      
    *(volatile unsigned int *)0xB801895C = 0x60 ;     
    *(volatile unsigned int *)0xB8018960 = 0xA0 ;     
    *(volatile unsigned int *)0xB8018964 = 0x54 ;     
    *(volatile unsigned int *)0xB8018968 = 0xFF ;     
    *(volatile unsigned int *)0xB801896C = 0x3 ;      
    *(volatile unsigned int *)0xB80180D8 = 0x40 ;     
    *(volatile unsigned int *)0xB8018990 = 0x0 ;      
    *(volatile unsigned int *)0xB80189D0 = 0xC ;      
    *(volatile unsigned int *)0xB80189D4 = 0x4B ;     
    *(volatile unsigned int *)0xB80189D8 = 0x7A ;     
    *(volatile unsigned int *)0xB80189DC = 0x2B ;     
    *(volatile unsigned int *)0xB80189E0 = 0x85 ;     
    *(volatile unsigned int *)0xB80189E4 = 0xAA ;     
    *(volatile unsigned int *)0xB80189E8 = 0x5A ;     
    *(volatile unsigned int *)0xB80189EC = 0x62 ;     
    *(volatile unsigned int *)0xB80189F0 = 0x84 ;     
    *(volatile unsigned int *)0xB8018000 = 0x2A832359 ;
    *(volatile unsigned int *)0xB8018004 = 0x306505 ; 
    *(volatile unsigned int *)0xB80180AC = 0xB16 ;    
    *(volatile unsigned int *)0xB8018048 = 0x8106310 ;
    *(volatile unsigned int *)0xB8018050 = 0x815904 ; 
    *(volatile unsigned int *)0xB8018054 = 0x91CA0B ; 
    *(volatile unsigned int *)0xB801804C = 0x820A352 ;
    *(volatile unsigned int *)0xB8018058 = 0x82AA09 ; 
    *(volatile unsigned int *)0xB80180C4 = 0x7EC00 ;  
    *(volatile unsigned int *)0xB80180EC = 0x19 ;     
    *(volatile unsigned int *)0xB80180EC = 0x6 ;      
    *(volatile unsigned int *)0xB80180EC = 0x1 ;     
    *(volatile unsigned int *)0xB80180F0 = 0x22D43F ; 
    *(volatile unsigned int *)0xB80180F4 = 0x22CC88 ; 
    *(volatile unsigned int *)0xB8018084 = 0x80009404 ;
    *(volatile unsigned int *)0xB8018088 = 0x80008000 ;
    *(volatile unsigned int *)0xB801808C = 0x93929392 ;
    *(volatile unsigned int *)0xB8018090 = 0x8C708D40 ;
    *(volatile unsigned int *)0xB8018110 = 0xC70 ;    
    *(volatile unsigned int *)0xB8018094 = 0x80008000 ;
    *(volatile unsigned int *)0xB80180FC = 0x27E1800 ;
    *(volatile unsigned int *)0xB80180A8 = 0x7F400E0 ;
    *(volatile unsigned int *)0xB80180AC = 0x2359 ;   
    *(volatile unsigned int *)0xB8018098 = 0x6A0817A0 ;
    *(volatile unsigned int *)0xB801809C = 0x28A1BB0 ; 
    *(volatile unsigned int *)0xB8018148 = 0xE56D0D0 ;
    *(volatile unsigned int *)0xB801814C = 0x40 ;     
    *(volatile unsigned int *)0xB8018040 = 0x1 ;      
    *(volatile unsigned int *)0xB8018044 = 0x20E0024E ;
    *(volatile unsigned int *)0xB801805C = 0x804232A  ;
    *(volatile unsigned int *)0xB8018060 = 0x9AB ;    
    *(volatile unsigned int *)0xB80180D8 = 0x7FE ;    
    *(volatile unsigned int *)0xB80180D8 = 0x32B ;    
    *(volatile unsigned int *)0xB80180A4 = 0x81EE34F ;
    *(volatile unsigned int *)0xB8018100 = 0xBE8800 ; 
    *(volatile unsigned int *)0xB8018104 = 0xA0C82C ; 
    *(volatile unsigned int *)0xB8018108 = 0xBE8BE8 ; 
    *(volatile unsigned int *)0xB80180A0 = 0x7E ;     
    *(volatile unsigned int *)0xB8018000 = 0x30000000 ;

/* MV OFF Start. */
    *(volatile unsigned int *)0xB8018920 = 0x0 ;      
    *(volatile unsigned int *)0xB8018924 = 0x0 ;     
    *(volatile unsigned int *)0xB8018928 = 0x0 ;     
    *(volatile unsigned int *)0xB801892C = 0x0 ;     
    *(volatile unsigned int *)0xB8018930 = 0x0 ;     
    *(volatile unsigned int *)0xB8018934 = 0x0 ;     
    *(volatile unsigned int *)0xB8018938 = 0x0 ;     
    *(volatile unsigned int *)0xB801893C = 0x0 ;     
    *(volatile unsigned int *)0xB8018940 = 0x0 ;     
    *(volatile unsigned int *)0xB8018944 = 0x0 ;      
    *(volatile unsigned int *)0xB8018948 = 0x0 ;     
    *(volatile unsigned int *)0xB801894C = 0x0 ;      
    *(volatile unsigned int *)0xB8018950 = 0x0 ;      
    *(volatile unsigned int *)0xB8018954 = 0x0 ;      
    *(volatile unsigned int *)0xB8018958 = 0x0 ;      
    *(volatile unsigned int *)0xB801895C = 0x0 ;     
    *(volatile unsigned int *)0xB8018960 = 0x0 ;     
    *(volatile unsigned int *)0xB8018964 = 0x0 ;     
    *(volatile unsigned int *)0xB8018968 = 0x0 ;     
    *(volatile unsigned int *)0xB801896C = 0x0 ;      
    *(volatile unsigned int *)0xB8018990 = 0x0 ; 
    *(volatile unsigned int *)0xB8018068 = 0x0 ;  
/* MV OFF End. */

                                
// set HDMI registers           
    *(volatile unsigned int *)0xB80000D0 = 0x1 ;       
    *(volatile unsigned int *)0xB8018158 = 0x3A002000 ;
    *(volatile unsigned int *)0xB8018164 = 0x8022046 ; 
    *(volatile unsigned int *)0xB8018168 = 0x201A008 ; 
    *(volatile unsigned int *)0xB801816C = 0x2032008 ; 
    *(volatile unsigned int *)0xB8018170 = 0x2002000 ; 
    *(volatile unsigned int *)0xB8018174 = 0x2002000 ; 
    *(volatile unsigned int *)0xB8018160 = 0x8D4A074 ; 
    *(volatile unsigned int *)0xB800D010 = 0x0 ;       
    *(volatile unsigned int *)0xB800D014 = 0xF9C938 ;  
    *(volatile unsigned int *)0xB800D018 = 0xA05F30 ;  
    *(volatile unsigned int *)0xB800D01C = 0x125499A ; 
    *(volatile unsigned int *)0xB800D150 = 0x37AFCB4 ; 
    *(volatile unsigned int *)0xB800D020 = 0x3B ;      
    *(volatile unsigned int *)0xB800D154 = 0x924 ;     
    *(volatile unsigned int *)0xB800D02C = 0x4630F0 ;  
    *(volatile unsigned int *)0xB800D030 = 0x73 ;      
    *(volatile unsigned int *)0xB800D034 = 0x2AA2AA ;   
    *(volatile unsigned int *)0xB800D038 = 0x3E02AA ;  
    *(volatile unsigned int *)0xB800D03C = 0xFFE11 ;   
    *(volatile unsigned int *)0xB800D040 = 0x2A3503 ;  
    *(volatile unsigned int *)0xB800D044 = 0xFEDCBA98 ;
    *(volatile unsigned int *)0xB800D048 = 0x1501800 ; 
    *(volatile unsigned int *)0xB800D04C = 0x6978 ;    
    *(volatile unsigned int *)0xB800D040 = 0x202003 ;  
    *(volatile unsigned int *)0xB800D048 = 0x501800 ;  
    *(volatile unsigned int *)0xB800D054 = 0xD ;       
    *(volatile unsigned int *)0xB800D058 = 0x0 ;       
    *(volatile unsigned int *)0xB800D05C = 0x0 ;       
    *(volatile unsigned int *)0xB800D060 = 0x0 ;       
    *(volatile unsigned int *)0xB800D064 = 0x0 ;       
    *(volatile unsigned int *)0xB800D068 = 0x0 ;       
    *(volatile unsigned int *)0xB800D06C = 0x0 ;       
    *(volatile unsigned int *)0xB800D070 = 0x0 ;       
    *(volatile unsigned int *)0xB800D074 = 0x0 ;        
    *(volatile unsigned int *)0xB800D078 = 0x0 ;        
    *(volatile unsigned int *)0xB800D07C = 0x21084210 ; 
    *(volatile unsigned int *)0xB800D080 = 0x7E ;       
    *(volatile unsigned int *)0xB800D088 = 0x0 ;        
    *(volatile unsigned int *)0xB800D08C = 0xCA1 ;      
    *(volatile unsigned int *)0xB800D094 = 0x1C000000 ; 
    *(volatile unsigned int *)0xB800D090 = 0x7D04B ;    
    *(volatile unsigned int *)0xB800D094 = 0x1C000000 ; 
    *(volatile unsigned int *)0xB800D098 = 0x0 ;        
    *(volatile unsigned int *)0xB800D100 = 0x2A ;       
    *(volatile unsigned int *)0xB800D104 = 0x25131FB ;  
    *(volatile unsigned int *)0xB800D108 = 0x241F1FF ;  
    *(volatile unsigned int *)0xB800D10C = 0xE8 ;       
    *(volatile unsigned int *)0xB800D110 = 0x0 ;        
    *(volatile unsigned int *)0xB800D118 = 0x0 ;        
    *(volatile unsigned int *)0xB800D11C = 0x0 ;        
    *(volatile unsigned int *)0xB800D120 = 0x0 ;        
    *(volatile unsigned int *)0xB800D124 = 0x0 ;        
    *(volatile unsigned int *)0xB800D128 = 0x0 ;        
    *(volatile unsigned int *)0xB800D12C = 0x0 ;        
    *(volatile unsigned int *)0xB800D134 = 0x0 ;        
    *(volatile unsigned int *)0xB800D13C = 0x0 ;        
    *(volatile unsigned int *)0xB800D140 = 0x0 ;        
    *(volatile unsigned int *)0xB800D144 = 0x0 ;        
    *(volatile unsigned int *)0xB800D148 = 0x0 ;        
    *(volatile unsigned int *)0xB800D14C = 0x0 ;        
    *(volatile unsigned int *)0xB800D000 = 0x6 ;        
   
    *(volatile unsigned int *)0xB800D058 = 0xD0282 ;   
    *(volatile unsigned int *)0xB800D05C = 0x580015 ;  
    *(volatile unsigned int *)0xB800D060 = 0x2 ;       
    *(volatile unsigned int *)0xB800D064 = 0x0 ;       
    *(volatile unsigned int *)0xB800D068 = 0x0 ;       
    *(volatile unsigned int *)0xB800D06C = 0x0 ;       
    *(volatile unsigned int *)0xB800D070 = 0x0 ;      
    *(volatile unsigned int *)0xB800D074 = 0x0 ;      
    *(volatile unsigned int *)0xB800D078 = 0x0 ;      
    *(volatile unsigned int *)0xB800D088 = 0x7762 ;   
    *(volatile unsigned int *)0xB800D07C = 0x21084210 ;
    *(volatile unsigned int *)0xB800D080 = 0x7E ;     
    *(volatile unsigned int *)0xB800D07C = 0x11 ;     
    *(volatile unsigned int *)0xB800D080 = 0x3 ;     

// disable TVE colorbar, enable interrupt
		                            
		*(volatile unsigned int *)0xb80180ec = 0x18 ;               //4
    *(volatile unsigned int *)0xb8005504 = 0xfffffffe ;
    *(volatile unsigned int *)0xb8005504 = 0xf ; //b
    *(volatile unsigned int *)0xb801810c = 0xa00a000 ;
    *(volatile unsigned int *)0xb80180e0 = 0x0 ;
    *(volatile unsigned int *)0xb80055e4 = 0x9 ;
    *(volatile unsigned int *)0xb80180dc = 0x1 ;
}                               
                                
#endif                          
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
