/************************************************************************
 *
 *  logo_disp_nep_625i.c
 *
 *  Belong to logo_disp module
 *
 *  This file implements logo display function in PAL mode
 *
 ************************************************************************/

/************************************************************************
 *  Include files
 ************************************************************************/

#include <string.h>
#include <sys_api.h>
#include <stdio.h>
#include <extern_param.h>

#include <logo_disp_api.h>
#include <project_config.h>

/************************************************************************
 *  Implementation : Private functions
 ************************************************************************/

#if defined(Logo_Type_PAL)
void  LOGO_DISP_setup(t_extern_param *logo_param_ptr)
{
	printf("PAL logo\n");
	LOGO_DISP_625i(logo_param_ptr);
}

void LOGO_DISP_625i(t_extern_param *logo)
{

// set VO registers

    *(volatile unsigned int *)0xb8005350 = 0xfffffffe ;
    *(volatile unsigned int *)0xb8005350 = 0x3 ;
    *(volatile unsigned int *)0xb8005354 = 0x2cf ;
    *(volatile unsigned int *)0xb8005358 = 0x31f63f ;
    *(volatile unsigned int *)0xb800535c = 0xffff3210 ;
    *(volatile unsigned int *)0xb8005360 = 0x0 ;


//color lookup table of Sub-Picture , index0~index3

    *(volatile unsigned int *)0xb8005370 = logo->logo_reg_5370; //0x6ba53f ;
    *(volatile unsigned int *)0xb8005374 = logo->logo_reg_5374; //0x6da555 ;
    *(volatile unsigned int *)0xb8005378 = logo->logo_reg_5378; //0x749889 ;
    *(volatile unsigned int *)0xb800537c = logo->logo_reg_537c; //0x8080eb ;
    *(volatile unsigned int *)0xb80053b0 = 0xacf800 ;
    *(volatile unsigned int *)0xb80053b4 = 0xa3f800 ;
    *(volatile unsigned int *)0xb80056cc = 0x4000 ;          /* m */
    *(volatile unsigned int *)0xb80056d0 = 0x0 ;             /* m */
    
    
    *(volatile unsigned int *)0xb80056c8 = 0x2 ;             /* m */

    *(volatile unsigned int *)0xb80056fc = 0x4000 ;          /* m */
    *(volatile unsigned int *)0xb8005700 = 0x0 ;             /* m */
    
    
    *(volatile unsigned int *)0xb80056f4 = 0x2 ;             /* m */
    
    
    *(volatile unsigned int *)0xb80054b0 = 0xa3facf ;
    *(volatile unsigned int *)0xb80054b4 = 0x16030100 ;
    *(volatile unsigned int *)0xb80054e8 = 0x2001400 ;
    *(volatile unsigned int *)0xb80054ec = 0x2001000 ;
    *(volatile unsigned int *)0xb80054f0 = 0x2001400 ;
    *(volatile unsigned int *)0xb80054f4 = 0x2001000 ;
    *(volatile unsigned int *)0xb80054f8 = 0x400 ;
    *(volatile unsigned int *)0xb80054fc = 0x20080200 ;
    *(volatile unsigned int *)0xb8005500 = 0xf010eb10 ;
    *(volatile unsigned int *)0xb8005564 = 0x0 ;
    *(volatile unsigned int *)0xb8005568 = 0x1 ;
    *(volatile unsigned int *)0xb800556c = 0x2 ;
    *(volatile unsigned int *)0xb8005570 = 0x3 ;
    *(volatile unsigned int *)0xb8005574 = 0x4 ;
    *(volatile unsigned int *)0xb8005578 = 0x5 ;
    *(volatile unsigned int *)0xb800557c = 0x6 ;
    *(volatile unsigned int *)0xb8005580 = 0x7 ;
    *(volatile unsigned int *)0xb8005584 = 0x8 ;


//Top and Bot address of Sub-Picture 

    *(volatile unsigned int *)0xb8005530 = 0xf0000 ;
    *(volatile unsigned int *)0xb8005534 = 0xf0000 + logo->logo_offset ;//0xf0aa4 ;


// set TVE registers

    *(volatile unsigned int *)0xb8000084 = 0x101cd800 ;
    *(volatile unsigned int *)0xb800000c = 0x1 ;
    *(volatile unsigned int *)0xb80180c8 = 0x124 ;
    *(volatile unsigned int *)0xb80180cc = 0x188 ;
    *(volatile unsigned int *)0xb8018134 = 0x3f8000 ;        /* m */
    *(volatile unsigned int *)0xb80180d0 = 0x3fcccc ;        /* m */
    *(volatile unsigned int *)0xb80180d4 = 0x3fcccc ;        /* m */
    *(volatile unsigned int *)0xb80180e8 = 0x1 ;
    *(volatile unsigned int *)0xb8018154 = 0x205 ;
    *(volatile unsigned int *)0xb8018880 = 0xcb ;
    *(volatile unsigned int *)0xb8018884 = 0x8a ;
    *(volatile unsigned int *)0xb8018888 = 0x9 ;
    *(volatile unsigned int *)0xb801888c = 0x2a ;
    *(volatile unsigned int *)0xb8018890 = 0x0 ;
    *(volatile unsigned int *)0xb8018894 = 0x0 ;
    *(volatile unsigned int *)0xb8018898 = 0x0 ;
    *(volatile unsigned int *)0xb801889c = 0x9b ;
    *(volatile unsigned int *)0xb80188a0 = 0x2 ;
    *(volatile unsigned int *)0xb80188a8 = 0x78 ;
    *(volatile unsigned int *)0xb80188ac = 0x78 ;
    *(volatile unsigned int *)0xb80188b0 = 0x10 ;
    *(volatile unsigned int *)0xb80188b4 = 0x3 ;
    *(volatile unsigned int *)0xb80188b8 = 0x1d ;
    *(volatile unsigned int *)0xb80188b8 = 0x1d ;
    *(volatile unsigned int *)0xb8018984 = 0x20 ;
    *(volatile unsigned int *)0xb801898c = 0x2 ;
    *(volatile unsigned int *)0xb80188bc = 0x0 ;
    *(volatile unsigned int *)0xb80188c8 = 0xd7 ;
    *(volatile unsigned int *)0xb80188cc = 0x29 ;
    *(volatile unsigned int *)0xb80188d0 = 0x3 ;
    *(volatile unsigned int *)0xb80188e0 = 0x9 ;
    *(volatile unsigned int *)0xb80188e4 = 0x31 ;
    *(volatile unsigned int *)0xb80188e8 = 0x38 ;
    *(volatile unsigned int *)0xb80188ec = 0x6 ;
    *(volatile unsigned int *)0xb80188f0 = 0xbf ;
    *(volatile unsigned int *)0xb80188f4 = 0x3 ;
    *(volatile unsigned int *)0xb80188f8 = 0x5f ;
    *(volatile unsigned int *)0xb80189c0 = 0x5c ;
    *(volatile unsigned int *)0xb80189c4 = 0x40 ;
    *(volatile unsigned int *)0xb80189c8 = 0x24 ;
    *(volatile unsigned int *)0xb80189cc = 0x1c ;
    *(volatile unsigned int *)0xb8018920 = 0x0 ;
    *(volatile unsigned int *)0xb8018924 = 0x39 ;
    *(volatile unsigned int *)0xb8018928 = 0x22 ;
    *(volatile unsigned int *)0xb801892c = 0x5a ;
    *(volatile unsigned int *)0xb8018930 = 0x22 ;
    *(volatile unsigned int *)0xb8018934 = 0xa8 ;
    *(volatile unsigned int *)0xb8018938 = 0x1c ;
    *(volatile unsigned int *)0xb801893c = 0x34 ;
    *(volatile unsigned int *)0xb8018940 = 0x14 ;
    *(volatile unsigned int *)0xb8018944 = 0x3 ;
    *(volatile unsigned int *)0xb8018948 = 0xfe ;
    *(volatile unsigned int *)0xb801894c = 0x1 ;
    *(volatile unsigned int *)0xb8018950 = 0x54 ;
    *(volatile unsigned int *)0xb8018954 = 0xfe ;
    *(volatile unsigned int *)0xb8018958 = 0x7e ;
    *(volatile unsigned int *)0xb801895c = 0x60 ;
    *(volatile unsigned int *)0xb8018960 = 0x80 ;
    *(volatile unsigned int *)0xb8018964 = 0x47 ;
    *(volatile unsigned int *)0xb8018968 = 0x55 ;
    *(volatile unsigned int *)0xb801896c = 0x1 ;
    *(volatile unsigned int *)0xb80180d8 = 0x40 ;
    *(volatile unsigned int *)0xb8018990 = 0x0 ;
    *(volatile unsigned int *)0xb80189d0 = 0x0 ;
    *(volatile unsigned int *)0xb80189d4 = 0x3f ;
    *(volatile unsigned int *)0xb80189d8 = 0x71 ;
    *(volatile unsigned int *)0xb80189dc = 0x20 ;
    *(volatile unsigned int *)0xb80189e0 = 0x80 ;
    *(volatile unsigned int *)0xb80189e4 = 0xa4 ;
    *(volatile unsigned int *)0xb80189e8 = 0x50 ;
    *(volatile unsigned int *)0xb80189ec = 0x57 ;
    *(volatile unsigned int *)0xb80189f0 = 0x74 ;
    *(volatile unsigned int *)0xb8018000 = 0x2e9c235f ;
    *(volatile unsigned int *)0xb8018004 = 0x29ae6d ;
    *(volatile unsigned int *)0xb80180ac = 0xb1b ;          /* m */
    *(volatile unsigned int *)0xb8018048 = 0x80fa30d ;
    *(volatile unsigned int *)0xb8018050 = 0x816935 ;
    *(volatile unsigned int *)0xb8018054 = 0x94fa6e ;
    *(volatile unsigned int *)0xb801804c = 0x81f234c ;
    *(volatile unsigned int *)0xb8018058 = 0x82ca6b ;
    *(volatile unsigned int *)0xb80180c4 = 0x7ec00 ;
    *(volatile unsigned int *)0xb80180ec = 0x18 ;           /* m */
    *(volatile unsigned int *)0xb80180ec = 0x7 ;            /* m */
    
    *(volatile unsigned int *)0xb80180f0 = 0x22d43c ;
    *(volatile unsigned int *)0xb8018098 = 0x6a081000 ;
    *(volatile unsigned int *)0xb801809c = 0x27e1bb0 ;
    *(volatile unsigned int *)0xb8018148 = 0xa56d0d0 ;
    *(volatile unsigned int *)0xb8018040 = 0x1 ;
    *(volatile unsigned int *)0xb80180d8 = 0x3fe ;
    *(volatile unsigned int *)0xb80180d8 = 0x3ab ;
    *(volatile unsigned int *)0xb8018140 = 0x3fff000 ;
    *(volatile unsigned int *)0xb8018144 = 0x3fff000 ;
    *(volatile unsigned int *)0xb8018150 = 0x5c80 ;
    *(volatile unsigned int *)0xb8018084 = 0x80008807 ;
    *(volatile unsigned int *)0xb8018088 = 0x80008000 ;
    *(volatile unsigned int *)0xb801808c = 0x8d0c9266 ;
    *(volatile unsigned int *)0xb8018090 = 0xa0038110 ;
    *(volatile unsigned int *)0xb8018110 = 0x2003 ;
    *(volatile unsigned int *)0xb8018094 = 0x88008112 ;
    *(volatile unsigned int *)0xb80180fc = 0x27e1800 ;
    *(volatile unsigned int *)0xb80180a4 = 0x80ea30c ;       /* m */
    *(volatile unsigned int *)0xb8018100 = 0x938800 ;
    *(volatile unsigned int *)0xb8018104 = 0xa6f816 ;
    *(volatile unsigned int *)0xb8018108 = 0x93694f ;
    *(volatile unsigned int *)0xb80180a0 = 0x7e ;
    *(volatile unsigned int *)0xb8018000 = 0x30000000 ;

/* MV OFF Start. */
    *(volatile unsigned int *)0xB8018920 = 0x0 ;      
    *(volatile unsigned int *)0xB8018924 = 0x0 ;     
    *(volatile unsigned int *)0xB8018928 = 0x0 ;     
    *(volatile unsigned int *)0xB801892C = 0x0 ;     
    *(volatile unsigned int *)0xB8018930 = 0x0 ;     
    *(volatile unsigned int *)0xB8018934 = 0x0 ;     
    *(volatile unsigned int *)0xB8018938 = 0x0 ;     
    *(volatile unsigned int *)0xB801893C = 0x0 ;     
    *(volatile unsigned int *)0xB8018940 = 0x0 ;     
    *(volatile unsigned int *)0xB8018944 = 0x0 ;      
    *(volatile unsigned int *)0xB8018948 = 0x0 ;     
    *(volatile unsigned int *)0xB801894C = 0x0 ;      
    *(volatile unsigned int *)0xB8018950 = 0x0 ;      
    *(volatile unsigned int *)0xB8018954 = 0x0 ;      
    *(volatile unsigned int *)0xB8018958 = 0x0 ;      
    *(volatile unsigned int *)0xB801895C = 0x0 ;     
    *(volatile unsigned int *)0xB8018960 = 0x0 ;     
    *(volatile unsigned int *)0xB8018964 = 0x0 ;     
    *(volatile unsigned int *)0xB8018968 = 0x0 ;     
    *(volatile unsigned int *)0xB801896C = 0x0 ;      
    *(volatile unsigned int *)0xB8018990 = 0x0 ; 
    *(volatile unsigned int *)0xB8018068 = 0x0 ;  
/* MV OFF End. */

//set HDMI registers

	*(volatile unsigned int *)0xB80000D0 = 0x1 ;
	*(volatile unsigned int *)0xB8018158 = 0x3E002000 ;
	*(volatile unsigned int *)0xB8018164 = 0x8C66358 ;
	*(volatile unsigned int *)0xB8018168 = 0x2002000 ;
	*(volatile unsigned int *)0xB801816C = 0x200E000 ;
	*(volatile unsigned int *)0xB8018170 = 0x24E21B0 ;
	*(volatile unsigned int *)0xB8018174 = 0x24EE1B0 ;
	*(volatile unsigned int *)0xB8018160 = 0x8C36036 ;
	*(volatile unsigned int *)0xB800D010 = 0x1 ;
	*(volatile unsigned int *)0xB800D014 = 0xF9C938 ;
	*(volatile unsigned int *)0xB800D018 = 0xA05F30 ;
	*(volatile unsigned int *)0xB800D01C = 0x125499A ;
	*(volatile unsigned int *)0xB800D150 = 0x37AFCB4 ;
	*(volatile unsigned int *)0xB800D020 = 0x3B ;
	*(volatile unsigned int *)0xB800D154 = 0x925 ;
	*(volatile unsigned int *)0xB800D02C = 0x4630F0 ;
	*(volatile unsigned int *)0xB800D030 = 0x73 ;
	*(volatile unsigned int *)0xB800D034 = 0x2AA2AA ;
	*(volatile unsigned int *)0xB800D038 = 0x3E02AA ;
	*(volatile unsigned int *)0xB800D03C = 0xFFE11 ;
	*(volatile unsigned int *)0xB800D040 = 0x2A3503 ;
	*(volatile unsigned int *)0xB800D044 = 0xFEDCBA98 ;
	*(volatile unsigned int *)0xB800D048 = 0x1D01800 ;
	*(volatile unsigned int *)0xB800D04C = 0x6978 ;
	*(volatile unsigned int *)0xB800D040 = 0x202003 ;
	*(volatile unsigned int *)0xB800D048 = 0x501800 ;
	*(volatile unsigned int *)0xB800D054 = 0xD ;
	*(volatile unsigned int *)0xB800D058 = 0x0 ;
	*(volatile unsigned int *)0xB800D05C = 0x0 ;
	*(volatile unsigned int *)0xB800D060 = 0x0 ;
	*(volatile unsigned int *)0xB800D064 = 0x0 ;
	*(volatile unsigned int *)0xB800D068 = 0x0 ;
	*(volatile unsigned int *)0xB800D06C = 0x0 ;
	*(volatile unsigned int *)0xB800D070 = 0x0 ;
	*(volatile unsigned int *)0xB800D074 = 0x0 ;
	*(volatile unsigned int *)0xB800D078 = 0x0 ;
	*(volatile unsigned int *)0xB800D07C = 0x21084210 ;
	*(volatile unsigned int *)0xB800D080 = 0x7E ;
	*(volatile unsigned int *)0xB800D088 = 0x0 ;
	*(volatile unsigned int *)0xB800D08C = 0xCA3 ;
	*(volatile unsigned int *)0xB800D094 = 0x1C000000 ;
	*(volatile unsigned int *)0xB800D090 = 0x7D04A ;
	*(volatile unsigned int *)0xB800D094 = 0x14000000 ;
	*(volatile unsigned int *)0xB800D098 = 0x0 ;
	*(volatile unsigned int *)0xB800D100 = 0x2A ;
	*(volatile unsigned int *)0xB800D104 = 0x25131FB ;
	*(volatile unsigned int *)0xB800D108 = 0x241F1FF ;
	*(volatile unsigned int *)0xB800D10C = 0xA8 ;
	*(volatile unsigned int *)0xB800D110 = 0x0 ;
	*(volatile unsigned int *)0xB800D118 = 0x0 ;
	*(volatile unsigned int *)0xB800D11C = 0x0 ;
	*(volatile unsigned int *)0xB800D120 = 0x0 ;
	*(volatile unsigned int *)0xB800D124 = 0x0 ;
	*(volatile unsigned int *)0xB800D128 = 0x0 ;
	*(volatile unsigned int *)0xB800D12C = 0x0 ;
	*(volatile unsigned int *)0xB800D134 = 0x0 ;
	*(volatile unsigned int *)0xB800D13C = 0x0 ;
	*(volatile unsigned int *)0xB800D140 = 0x0 ;
	*(volatile unsigned int *)0xB800D144 = 0x0 ;
	*(volatile unsigned int *)0xB800D148 = 0x0 ;
	*(volatile unsigned int *)0xB800D14C = 0x0 ;
	*(volatile unsigned int *)0xB800D000 = 0x6 ;
	*(volatile unsigned int *)0xB800D058 = 0xD0282 ;
	*(volatile unsigned int *)0xB800D05C = 0x580010 ;
	*(volatile unsigned int *)0xB800D060 = 0x106 ;
	*(volatile unsigned int *)0xB800D064 = 0x0 ;
	*(volatile unsigned int *)0xB800D068 = 0x0 ;
	*(volatile unsigned int *)0xB800D06C = 0x0 ;
	*(volatile unsigned int *)0xB800D070 = 0x0 ;
	*(volatile unsigned int *)0xB800D074 = 0x0 ;
	*(volatile unsigned int *)0xB800D078 = 0x0 ;
	*(volatile unsigned int *)0xB800D088 = 0x7762 ;
	*(volatile unsigned int *)0xB800D07C = 0x21084210 ;
	*(volatile unsigned int *)0xB800D080 = 0x7E ;
	*(volatile unsigned int *)0xB800D07C = 0x11 ;
	*(volatile unsigned int *)0xB800D080 = 0x3 ;

// disable TVE colorbar, enable interrupt

    *(volatile unsigned int *)0xb80180ec = 0x4 ;               /* m */
    *(volatile unsigned int *)0xb8005504 = 0xfffffffe ;
    *(volatile unsigned int *)0xb8005504 = 0xb ;
    *(volatile unsigned int *)0xb801810c = 0xa00a000 ;
    *(volatile unsigned int *)0xb80180e0 = 0x0 ;
    *(volatile unsigned int *)0xb80055f0 = 0x9 ;
    *(volatile unsigned int *)0xb80180dc = 0x1 ;
}

#endif
