
/************************************************************************
 *
 *      INITMODULES.C
 *
 *      This module is a generic template for installation and
 *      initialization of modules to be included as blackboxes.
 *
 * ######################################################################
 *
 * mips_start_of_legal_notice
 * 
 * Copyright (c) 2003 MIPS Technologies, Inc. All rights reserved.
 *
 *
 * Unpublished rights (if any) reserved under the copyright laws of the
 * United States of America and other countries.
 *
 * This code is proprietary to MIPS Technologies, Inc. ("MIPS
 * Technologies"). Any copying, reproducing, modifying or use of this code
 * (in whole or in part) that is not expressly permitted in writing by MIPS
 * Technologies or an authorized third party is strictly prohibited. At a
 * minimum, this code is protected under unfair competition and copyright
 * laws. Violations thereof may result in criminal penalties and fines.
 *
 * MIPS Technologies reserves the right to change this code to improve
 * function, design or otherwise. MIPS Technologies does not assume any
 * liability arising out of the application or use of this code, or of any
 * error or omission in such code. Any warranties, whether express,
 * statutory, implied or otherwise, including but not limited to the implied
 * warranties of merchantability or fitness for a particular purpose, are
 * excluded. Except as expressly provided in any written license agreement
 * from MIPS Technologies or an authorized third party, the furnishing of
 * this code does not give recipient any license to any intellectual
 * property rights, including any patent rights, that cover this code.
 *
 * This code shall not be exported or transferred for the purpose of
 * reexporting in violation of any U.S. or non-U.S. regulation, treaty,
 * Executive Order, law, statute, amendment or supplement thereto.
 *
 * This code constitutes one or more of the following: commercial computer
 * software, commercial computer software documentation or other commercial
 * items. If the user of this code, or any related documentation of any
 * kind, including related technical data or manuals, is an agency,
 * department, or other entity of the United States government
 * ("Government"), the use, duplication, reproduction, release,
 * modification, disclosure, or transfer of this code, or any related
 * documentation of any kind, is restricted in accordance with Federal
 * Acquisition Regulation 12.212 for civilian agencies and Defense Federal
 * Acquisition Regulation Supplement 227.7202 for military agencies. The use
 * of this code by the Government is further restricted in accordance with
 * the terms of the license agreement(s) and/or applicable contract terms
 * and conditions covering this code from MIPS Technologies or an authorized
 * third party.
 *
 * 
 * mips_end_of_legal_notice
 * 
 *
 ************************************************************************/

/*****************************************************************************
 *
 * Defines, needed in INITMODULES.C for the modules to be incl. in the system
 *
 ****************************************************************************/

#include <sysdefs.h>
#include <syserror.h>
#include <env_api.h>
#include <excep_api.h>
#include <flash_api.h>
#include <io_api.h>
#include <syscon_api.h>
#include <sysenv_api.h>
#include <serial_dw16550_api.h>
#include <timer_api.h>

#include <project_config.h>

#if !defined(Board_GPIO_NULL)
  #include <gpio_api.h>
#endif

#if defined(Board_RTC_DEFAULT)
  #include <rtc_api.h>
#endif

#if defined(Board_LAN_8139CP)
  #include <lan_rtl8139cplus_api.h>
#endif

#if defined(Board_LAN_8139CP)
  #include <net_api.h>
#endif

#if defined(Board_IDE_DEFAULT)
  #include <ide_api.h>
#endif

#if defined(Logo_Source_FLASH)
  #include <logo_disp_api.h>
#endif

/*********************************************************************
*
*  Complete list of modules to be included in YAMON.
*
*  The file initswitch.h defines whether a specific module is included
*  or not (defines INCLUDE_SYSCON, INCLUDE_IO, INCLUDE_RTC ...).
*
*  The bootstrap sequence of module initialisation is important since 
*  some modules depend on others.
*
*********************************************************************/

/*****************************************************************************
 *
 * Get modules installed and initialized.
 *
 ****************************************************************************/

UINT32 initmodules( void )
{
    /* Must be 1st module */
    /* Initialize SYSCON */
    SYSCON_init() ;

    /* Depends on SYSCON */
    /* make room for 15 device drivers */
    IO_setup( 15 ) ;

	/* Depends on IO */
    EXCEP_init() ;

	/* Depends on IO */
    FLASH_install() ;

	/* Depends on FLASH_PARELLEL */
    SYSENV_init();

	/* Depends on SYSENV */
    env_init();

	/* Depends on ENV */
    SERIAL_DW16550_install();

#if !defined(Board_GPIO_NULL)
    GPIO_init();
#endif

    TIMER_init() ;

#if defined(Board_RTC_DEFAULT)
    RTC_init();
#endif

#if defined(Board_LAN_8139CP)
    /* Depends on ENV */ 
    LAN_8139CPLUS_install();
#endif

#if defined(Board_IDE_DEFAULT)
    ide_install();
#endif
	
#if defined(Board_LAN_8139CP)
	/* Depends on LAN driver */
    NET_init() ;
#endif

#if defined(Logo_Source_FLASH)
	/* Set logo */
    LOGO_DISP_init();
#endif

#if !defined(Board_VFD_NULL)
	/* Set VFD */
    vfd_install();
#endif



    return(OK) ;
}
