
/************************************************************************
 *
 *  usb_command.c
 *
 *  USB command for shell
 *
 *  usb command
 *
 * ######################################################################
 *
 * mips_start_of_legal_notice
 * 
 * Copyright (c) 2003 MIPS Technologies, Inc. All rights reserved.
 *
 *
 * Unpublished rights (if any) reserved under the copyright laws of the
 * United States of America and other countries.
 *
 * This code is proprietary to MIPS Technologies, Inc. ("MIPS
 * Technologies"). Any copying, reproducing, modifying or use of this code
 * (in whole or in part) that is not expressly permitted in writing by MIPS
 * Technologies or an authorized third party is strictly prohibited. At a
 * minimum, this code is protected under unfair competition and copyright
 * laws. Violations thereof may result in criminal penalties and fines.
 *
 * MIPS Technologies reserves the right to change this code to improve
 * function, design or otherwise. MIPS Technologies does not assume any
 * liability arising out of the application or use of this code, or of any
 * error or omission in such code. Any warranties, whether express,
 * statutory, implied or otherwise, including but not limited to the implied
 * warranties of merchantability or fitness for a particular purpose, are
 * excluded. Except as expressly provided in any written license agreement
 * from MIPS Technologies or an authorized third party, the furnishing of
 * this code does not give recipient any license to any intellectual
 * property rights, including any patent rights, that cover this code.
 *
 * This code shall not be exported or transferred for the purpose of
 * reexporting in violation of any U.S. or non-U.S. regulation, treaty,
 * Executive Order, law, statute, amendment or supplement thereto.
 *
 * This code constitutes one or more of the following: commercial computer
 * software, commercial computer software documentation or other commercial
 * items. If the user of this code, or any related documentation of any
 * kind, including related technical data or manuals, is an agency,
 * department, or other entity of the United States government
 * ("Government"), the use, duplication, reproduction, release,
 * modification, disclosure, or transfer of this code, or any related
 * documentation of any kind, is restricted in accordance with Federal
 * Acquisition Regulation 12.212 for civilian agencies and Defense Federal
 * Acquisition Regulation Supplement 227.7202 for military agencies. The use
 * of this code by the Government is further restricted in accordance with
 * the terms of the license agreement(s) and/or applicable contract terms
 * and conditions covering this code from MIPS Technologies or an authorized
 * third party.
 *
 * 
 * mips_end_of_legal_notice
 * 
 *
 ************************************************************************/


/************************************************************************
 *  Include files
 ************************************************************************/

#include <shell_api.h>
#include <shell.h>
#include <sysdefs.h>
#include <string.h>
#include <stdio.h>
#include <usb/part.h>

/************************************************************************
 *  Definitions
 ************************************************************************/

/************************************************************************
 *  Public variables
 ************************************************************************/

/************************************************************************
 *  Static variables
 ************************************************************************/

/************************************************************************
 *  Static function prototypes
 ************************************************************************/

static int usb_driver_init(void);

/************************************************************************
 *  Implementation : Static functions
 ************************************************************************/

//#define CONFIG_BOOT_USB_STORAGE
//#define CONFIG_BOOT_USB
//#define CONFIG_BOOT_FS_FAT

/* cyhuang (2007/12/24) : Add for USB function.  */
#if defined(CONFIG_BOOT_USB_STORAGE)
#include <usb/usb.h>
#endif

/* -------------------------------- USB CMD ---------------------------*/
#if defined(CONFIG_BOOT_USB)

#include <usb/usb.h>

#undef  CMD_USB_DEBUG

#ifdef  CMD_USB_DEBUG
#define CMD_USB_PRINTF(fmt,args...)     printk (fmt ,##args)
#else
#define CMD_USB_PRINTF(fmt,args...)
#endif

#define DRAM_MAP_DLOAD_BUF_ADDR		0xa09ffff4
#define DOWNLOAD_MAGIC_NUM		0x5a5a5a

static int usb_stor_curr_dev=-1; /* current device */
UINT32 download_len = DOWNLOAD_MAGIC_NUM;
UINT32 download_addr = DRAM_MAP_DLOAD_BUF_ADDR;

/* some display routines (info command) */
static char * usb_get_class_desc(unsigned char dclass)
{
        switch(dclass) {
                case USB_CLASS_PER_INTERFACE:
                        return("See Interface");
                case USB_CLASS_AUDIO:
                        return("Audio");
                case USB_CLASS_COMM:
                        return("Communication");
                case USB_CLASS_HID:
                        return("Human Interface");
                case USB_CLASS_PRINTER:
                        return("Printer");
                case USB_CLASS_MASS_STORAGE:
                        return("Mass Storage");
                case USB_CLASS_HUB:
                        return("Hub");
                case USB_CLASS_DATA:
                        return("CDC Data");
                case USB_CLASS_VENDOR_SPEC:
                        return("Vendor specific");
                default :
                        return("");
        }
}

static void usb_display_class_sub(unsigned char dclass,unsigned char subclass,unsigned char proto)
{
        switch(dclass) {
                case USB_CLASS_PER_INTERFACE:
                        printk("See Interface");
                        break;
                case USB_CLASS_HID:
                        printk("Human Interface, Subclass: ");
                        switch(subclass) {
                                case USB_SUB_HID_NONE:
                                        printk("None");
                                        break;
                                case USB_SUB_HID_BOOT:
                                        printk("Boot ");
                                        switch(proto) {
                                                case USB_PROT_HID_NONE:
                                                        printk("None");
                                                        break;
                                                case USB_PROT_HID_KEYBOARD:
                                                        printk("Keyboard");
                                                        break;
                                                case USB_PROT_HID_MOUSE:
                                                        printk("Mouse");
                                                        break;
                                                default:
                                                        printk("reserved");
                                        }
                                        break;
                                default:
                                        printk("reserved");
                        }
                        break;
                case USB_CLASS_MASS_STORAGE:
                        printk("Mass Storage, ");
                        switch(subclass) {
                                case US_SC_RBC:
                                        printk("RBC ");
                                        break;
                                case US_SC_8020:
                                        printk("SFF-8020i (ATAPI)");
                                        break;
                                case US_SC_QIC:
                                        printk("QIC-157 (Tape)");
                                        break;
                                case US_SC_UFI:
                                        printk("UFI");
                                        break;
                                case US_SC_8070:
                                        printk("SFF-8070");
                                        break;
                                case US_SC_SCSI:
                                        printk("Transp. SCSI");
                                        break;
                                default:
                                        printk("reserved");
                                        break;
                        }
                        printk(", ");
                        switch(proto) {
                                case US_PR_CB:
                                        printk("Command/Bulk");
                                        break;
                                case US_PR_CBI:
                                        printk("Command/Bulk/Int");
                                        break;
                                case US_PR_BULK:
                                        printk("Bulk only");
                                        break;
                                default:
                                        printk("reserved");
                        }
                        break;
                default:
                        printk("%s",usb_get_class_desc(dclass));
        }
}

static void usb_display_string(struct usb_device *dev,int index)
{
        char buffer[256];
        if (index!=0) {
                if (usb_string(dev,index,&buffer[0],256)>0);
                        printk("String: \"%s\"",buffer);
        }
}

static void usb_display_desc(struct usb_device *dev)
{
        if (dev->descriptor.bDescriptorType==USB_DT_DEVICE) {
                printk("%d: %s,  USB Revision %x.%x\n",dev->devnum,usb_get_class_desc(dev->config.if_desc[0].bInterfaceClass),
                        (dev->descriptor.bcdUSB>>8) & 0xff,dev->descriptor.bcdUSB & 0xff);
                if (strlen(dev->mf) || strlen(dev->prod) || strlen(dev->serial))
                        printk(" - %s %s %s\n",dev->mf,dev->prod,dev->serial);
                if (dev->descriptor.bDeviceClass) {
                        printk(" - Class: ");
                        usb_display_class_sub(dev->descriptor.bDeviceClass,dev->descriptor.bDeviceSubClass,dev->descriptor.bDeviceProtocol);
                        printk("\n");
                }
                else {
                        printk(" - Class: (from Interface) %s\n",usb_get_class_desc(dev->config.if_desc[0].bInterfaceClass));
                }
                printk(" - PacketSize: %d  Configurations: %d\n",dev->descriptor.bMaxPacketSize0,dev->descriptor.bNumConfigurations);
                printk(" - Vendor: 0x%x  Product 0x%x Version %d.%d\n",dev->descriptor.idVendor,dev->descriptor.idProduct,(dev->descriptor.bcdDevice>>8) & 0xff,dev->descriptor.bcdDevice & 0xff);
        }

}

static void usb_display_conf_desc(struct usb_config_descriptor *config,struct usb_device *dev)
{
        printk("   Configuration: %d\n",config->bConfigurationValue);
        printk("   - Interfaces: %d %s%s%dmA\n",config->bNumInterfaces,(config->bmAttributes & 0x40) ? "Self Powered " : "Bus Powered ",
        (config->bmAttributes & 0x20) ? "Remote Wakeup " : "",config->MaxPower*2);
        if (config->iConfiguration) {
                printk("   - ");
                usb_display_string(dev,config->iConfiguration);
                printk("\n");
        }
}

static void usb_display_if_desc(struct usb_interface_descriptor *ifdesc,struct usb_device *dev)
{
        printk("     Interface: %d\n",ifdesc->bInterfaceNumber);
        printk("     - Alternate Settings %d, Endpoints: %d\n",ifdesc->bAlternateSetting,ifdesc->bNumEndpoints);
        printk("     - Class ");
        usb_display_class_sub(ifdesc->bInterfaceClass,ifdesc->bInterfaceSubClass,ifdesc->bInterfaceProtocol);
        printk("\n");
        if (ifdesc->iInterface) {
                printk("     - ");
                usb_display_string(dev,ifdesc->iInterface);
                printk("\n");
        }
}

static void usb_display_ep_desc(struct usb_endpoint_descriptor *epdesc)
{
        printk("     - Endpoint %d %s ",epdesc->bEndpointAddress & 0xf,(epdesc->bEndpointAddress & 0x80) ? "In" : "Out");
        switch((epdesc->bmAttributes & 0x03))
        {
                case 0: printk("Control"); break;
                case 1: printk("Isochronous"); break;
                case 2: printk("Bulk"); break;
                case 3: printk("Interrupt"); break;
        }
        printk(" MaxPacket %d",epdesc->wMaxPacketSize);
        if ((epdesc->bmAttributes & 0x03)==0x3)
                printk(" Interval %dms",epdesc->bInterval);
        printk("\n");
}

/* main routine to diasplay the configs, interfaces and endpoints */
static void usb_display_config(struct usb_device *dev)
{
        struct usb_config_descriptor *config;
        struct usb_interface_descriptor *ifdesc;
        struct usb_endpoint_descriptor *epdesc;
        int i,ii;

        config= &dev->config;
        usb_display_conf_desc(config,dev);
        for(i=0;i<config->no_of_if;i++) {
                ifdesc= &config->if_desc[i];
                usb_display_if_desc(ifdesc,dev);
                for(ii=0;ii<ifdesc->no_of_ep;ii++) {
                        epdesc= &ifdesc->ep_desc[ii];
                        usb_display_ep_desc(epdesc);
                }
        }
        printk("\n");
}

/* shows the device tree recursively */
static void usb_show_tree_graph(struct usb_device *dev,char *pre)
{
        int i,index;
        int has_child,last_child,port;

        index=strlen(pre);
        printk(" %s",pre);
        /* check if the device has connected children */
        has_child=0;
        for(i=0;i<dev->maxchild;i++) {
                if (dev->children[i]!=NULL)
                        has_child=1;
        }
        /* check if we are the last one */
        last_child=1;
        if (dev->parent!=NULL) {
                for(i=0;i<dev->parent->maxchild;i++) {
                        /* search for children */
                        if (dev->parent->children[i]==dev) {
                                /* found our pointer, see if we have a little sister */
                                port=i;
                                while(i++<dev->parent->maxchild) {
                                        if (dev->parent->children[i]!=NULL) {
                                                /* found a sister */
                                                last_child=0;
                                                break;
                                        } /* if */
                                } /* while */
                        } /* device found */
                } /* for all children of the parent */
                printk("\b+-");
                /* correct last child */
                if (last_child) {
                        pre[index-1]=' ';
                }
        } /* if not root hub */
        else
                printk(" ");
        printk("%d ",dev->devnum);
        pre[index++]=' ';
        pre[index++]= has_child ? '|' : ' ';
        pre[index]=0;
        printk(" %s (%s, %dmA)\n",usb_get_class_desc(dev->config.if_desc[0].bInterfaceClass),
                dev->slow ? "1.5MBit/s" : "12MBit/s",dev->config.MaxPower * 2);
        if (strlen(dev->mf) ||
           strlen(dev->prod) ||
           strlen(dev->serial))
                printk(" %s  %s %s %s\n",pre,dev->mf,dev->prod,dev->serial);
        printk(" %s\n",pre);
        if (dev->maxchild>0) {
                for(i=0;i<dev->maxchild;i++) {
                        if (dev->children[i]!=NULL) {
                                usb_show_tree_graph(dev->children[i],pre);
                                pre[index]=0;
                        }
                }
        }
}

/* main routine for the tree command */
static void usb_show_tree(struct usb_device *dev)
{
        char preamble[32];

        memset(preamble,0,32);
        usb_show_tree_graph(dev,&preamble[0]);
}

#if defined(CONFIG_BOOT_FS_FAT) 
int do_fat_fsload (int argc, char *argv[]);
#endif

//int do_usb (int argc, char *argv[])
static MON_FUNC(do_usb) {
        int i;
        struct usb_device *dev = NULL;
        block_dev_desc_t *stor_dev;

	usb_driver_init();

	argc--;
	argv++;

        if (argc <= 0)
                goto _err_param;
      
               
        if (strncmp(argv[0],"fw",2) == 0) { 
		char *_argv[4], devstr[8];
		int devno, part;
        	
        	if (argc <= 1) 
        		goto _err_param;
        	

        	_argv[0] = "usb";
		_argv[1] = "0";	
		_argv[2] = "0xa0100000";
		_argv[3] = argv[1];
        	        	
        	usb_stop();
        	usb_start();

		/* For USB Set Address failed, we restart usb to work arround this issue. */
        	//usb_stop();
        	//usb_start();

#if defined(CONFIG_BOOT_USB_STORAGE)        	
        	usb_stor_curr_dev=usb_stor_scan(1);
        	
                if (usb_stor_curr_dev==-1) {
                        printk("No device found. Not initialized?\n");
                        return NOT_OK;
                }
#endif                
                
                if (argc == 3) {
                	_argv[2] = argv[2];
                	download_addr = strtoul((const char *) (argv[2]), (char * *) NULL, 16);
        	}	

		for(devno = 0; devno < USB_MAX_STOR_DEV; devno++) {
			stor_dev = usb_stor_get_dev(devno);
			if(stor_dev->type != DEV_TYPE_UNKNOWN) {
				for(part = 0; part < 8; part++) {
					disk_partition_t info;
					if(!get_partition_info(stor_dev, part, &info)) {
#if defined(CONFIG_BOOT_FS_FAT) 
						int ret = 0;
						memset(devstr, 0, sizeof(devstr));
						sprintf(devstr, "%u:%u", devno, part);
						_argv[1] = devstr;
						if((ret = do_fat_fsload(4, _argv)) == TRUE) {
							printk("USB download firmware to addresss 0x%x, len=%d bytes, from device %d:%d\n", download_addr, download_len, devno, part);
							return OK;
						}
#endif
					}
                        	}
			}
                }
		printk("USB download firmware failed! No partitions or file, %s, found!\n",
										argv[1]);
                return NOT_OK;
	}	
	
        	     

        if ((strncmp(argv[0],"reset",5) == 0) ||
                 (strncmp(argv[0],"start",5) == 0)){
                usb_stop();
                printk("(Re)start USB...\n");
                usb_start();
                return OK;
        }
        if (strncmp(argv[0],"stop",4) == 0) {
                printk("stopping USB..\n");
                usb_stop();
                return OK;
        }
        if (strncmp(argv[0],"tree",4) == 0) {
                printk("\nDevice Tree:\n");
                dev=usb_get_dev_index(0);
                if (dev==NULL) {
                       printk("Please execute \"usb start\" first.\n");	
                       return OK;
                }         
                usb_show_tree(dev/*usb_get_dev_index(0)*/);
                return OK;
        }
        if (strncmp(argv[0],"inf",3) == 0) {
                int d;
                if (argc==1) {
                        for(d=0;d<USB_MAX_DEVICE;d++) {
                                dev=usb_get_dev_index(d);
                                if (dev==NULL)
                                        break;
                                usb_display_desc(dev);
                                usb_display_config(dev);
                        }
                        return OK;
                }
                else {
                        int d;

                        // i=simple_strtoul(argv[1], NULL, 16);
                        i = strtoul((const char *) (argv[1]), (char * *) NULL, 16);

                        printk("config for device %d\n",i);
                        for(d=0;d<USB_MAX_DEVICE;d++) {
                                dev=usb_get_dev_index(d);
                                if (dev==NULL)
                                        break;
                                if (dev->devnum==i)
                                        break;
                        }
                        if (dev==NULL) {
                                printk("*** NO Device avaiable ***\n");
                                return OK;
                        }
                        else {
                                usb_display_desc(dev);
                                usb_display_config(dev);
                        }
                }
                return OK;
        }
#if defined(CONFIG_BOOT_USB_STORAGE)
        if (strncmp(argv[0],"scan",4) == 0) {
                printk("Scan for storage device:\n");
                usb_stor_curr_dev=usb_stor_scan(1);
                if (usb_stor_curr_dev==-1) {
                        printk("No device found. Not initialized?\n");
                        return OK;
                }
                return OK;
        }
        if (strncmp(argv[0],"part",4) == 0) {
                int devno, ok;
                for (ok=0, devno=0; devno<USB_MAX_STOR_DEV; ++devno) {
                        stor_dev=usb_stor_get_dev(devno);
                        if (stor_dev->type!=DEV_TYPE_UNKNOWN) {
                                ok++;
                                if (devno)
                                        printk("\n");
                                printk("print_part of %x\n",devno);
                                print_part(stor_dev);
                        }
                }
                if (!ok) {
                        printk("\nno USB devices available\n");
                        return OK;
                }
                return OK;
        }
        if (strcmp(argv[0],"read") == 0) {
                if (usb_stor_curr_dev<0) {
                        printk("no current device selected\n");
                        return OK;
                }
                if (argc==4) {
                        unsigned long addr = strtoul((const char *) (argv[1]), (char * *) NULL, 16);
                        unsigned long blk  = strtoul((const char *) (argv[2]), (char * *) NULL, 16);
                        unsigned long cnt  = strtoul((const char *) (argv[3]), (char * *) NULL, 16);

                        unsigned long n;
                        printk ("\nUSB read: device %d block # %ld, count %ld ... (mem_addr = 0x%lx)",
                                        usb_stor_curr_dev, blk, cnt, addr);
                        stor_dev=usb_stor_get_dev(usb_stor_curr_dev);
                        n = stor_dev->block_read(usb_stor_curr_dev, blk, cnt, (ulong *)addr);

                        printk ("%ld blocks read: %s\n",n,(n==cnt) ? "OK" : "ERROR");
                        if (n==cnt)
                                return OK;
                        return NOT_OK;
                }
        }
        if (strcmp(argv[0],"dev") == 0) {
                if (argc==2) {
                        // int dev = (int)simple_strtoul(argv[1], NULL, 10);
                        int dev = strtoul((const char *) (argv[1]), (char * *) NULL, 16);

                        printk ("\nUSB device %d: ", dev);
                        if (dev >= USB_MAX_STOR_DEV) {
                                printk("unknown device\n");
                                return OK;
                        }
                        printk ("\n    Device %d: ", dev);
                        stor_dev=usb_stor_get_dev(dev);
                        dev_print(stor_dev);
                        if (stor_dev->type == DEV_TYPE_UNKNOWN) {
                                return OK;
                        }
                        usb_stor_curr_dev = dev;
                        printk("... is now current device\n");
                        return OK;
                }
                else {
                        printk ("\nUSB device %d: ", usb_stor_curr_dev);
                        stor_dev=usb_stor_get_dev(usb_stor_curr_dev);
                        dev_print(stor_dev);
                        if (stor_dev->type == DEV_TYPE_UNKNOWN) {
                                return OK;
                        }
                        return OK;
                }
                return OK;
        }
#endif /* CONFIG_BOOT_USB_STORAGE */


_err_param :
        printk("Usage:\n");
        printk("       USB fw <filename> [addr] - Update firmware from USB\n");
        printk("       USB tree  - show USB device tree\n");
        printk("       USB info [dev] - show available USB devices\n");
        printk("       USB scan  - (re-)scan USB bus for storage devices\n");
        printk("       USB device [dev] - show or set current USB storage device\n");
        printk("       USB part [dev] - print partition table of one or all USB storage devices\n");
        printk("       USB read addr blk# cnt - read `cnt' blocks starting at block `blk#'\n");
        printk("                                to memory address `addr'\n");

        return OK;
} // End of do_usb()

#endif /* CONFIG_BOOT_USB */

/* ------------------------------------------------------------------------ */
#if defined(CONFIG_BOOT_FS_FAT)
extern int fat_register_device(block_dev_desc_t *dev_desc, int part_no);
extern long file_fat_read(const char *filename, void *buffer, unsigned long maxsize);
extern int file_fat_ls(const char *dir);
extern int file_fat_detectfs(void);
static block_dev_desc_t *get_dev(char *ifname, int dev)
{
#if defined(CONFIG_BOOT_USB_STORAGE)
        if (strncmp(ifname,"usb",3)==0) {
                extern block_dev_desc_t * usb_stor_get_dev(int dev);
                return(usb_stor_get_dev(dev));
        }
#endif
#if defined(CONFIG_MMC)
        if (strncmp(ifname,"mmc",3)==0) {
                extern block_dev_desc_t *  mmc_get_dev(int dev);
                return(mmc_get_dev(dev));
        }
#endif
        return NULL;
}

int do_fat_fsload (int argc, char *argv[])
{
        long size;
        unsigned long offset;
        unsigned long count;
        // char buf [12];
        block_dev_desc_t *dev_desc=NULL;
        int dev=0;
        int part=1;
        char *ep;

        if (argc < 4) {
                printk ("usage: fat load <interface> <dev[:part]> <addr> <filename> [bytes]\n");
                return FALSE;
        }
        // dev = (int)simple_strtoul (argv[2], &ep, 16);
        dev = strtoul((const char *) (argv[1]), (char * *) &ep, 16);

        dev_desc=get_dev(argv[0],dev);
        if (dev_desc==NULL) {
                printk ("\n** Invalid boot device **\n");
                return FALSE;
        }
        if (*ep) {
                if (*ep != ':') {
                        printk ("\n** Invalid boot device, use `dev[:part]' **\n");
                        return FALSE;
                }
                // part = (int)simple_strtoul(++ep, NULL, 16);
                part = strtoul((const char *) (++ep), (char * *) NULL, 16);

        }
        if (fat_register_device(dev_desc,part)!=0) {
                printk ("\n** Unable to use %s %d:%d for fatload **\n",argv[0],dev,part);
                return FALSE;
        }

        // offset = simple_strtoul (argv[3], NULL, 16);
        offset = strtoul((const char *) argv[2], (char * *) NULL, 16);

        if (argc == 5)
                // count = simple_strtoul (argv[5], NULL, 16);
                count = strtoul((const char *) argv[4], (char * *) NULL, 16);
        else
                count = 0;

        size = file_fat_read (argv[3], (unsigned char *) offset, count);

        if(size==-1) {
                printk("\n** Unable to read \"%s\" from %s %d:%d **\n",argv[3],argv[0],dev,part);
                return FALSE;
        }

	download_len = size;
        printk ("\n%d bytes read\n", size);

//      sprintf(buf, "0x%x", size);
//      setenv("filesize", buf);

        return TRUE;
}

int do_fat_ls (int argc, char *argv[])
{
        char *filename = "/";
        int ret;
        int dev=0;
        int part=1;
        char *ep;
        block_dev_desc_t *dev_desc=NULL;

        if (argc < 2) {
                printk ("usage: fat ls <interface> <dev[:part]> [directory]\n");
                return TRUE;
        }

        // dev = (int)simple_strtoul (argv[2], &ep, 16);
        dev = strtoul((const char *) argv[1], (char * *) &ep, 16);

        dev_desc=get_dev(argv[0],dev);
        if (dev_desc==NULL) {
                printk ("\n** Invalid boot device **\n");
                return FALSE;
        }
        if (*ep) {
                if (*ep != ':') {
                        printk ("\n** Invalid boot device, use `dev[:part]' **\n");
                        return FALSE;
                }
                // part = (int)simple_strtoul(++ep, NULL, 16);
                part = strtoul((const char *) (++ep), (char * *) NULL, 16);
        }
        if (fat_register_device(dev_desc,part)!=0) {
                printk ("\n** Unable to use %s %d:%d for fatls **\n",argv[0],dev,part);
                return FALSE;
        }
        if (argc == 3)
                ret = file_fat_ls (argv[2]);
        else
                ret = file_fat_ls (filename);

        if(ret!=0)
                printk("No Fat FS detected\n");
        return ((ret==0)?TRUE:FALSE);
}

int do_fat_fsinfo (int argc, char *argv[])
{
        int dev=0;
        int part=1;
        char *ep;
        block_dev_desc_t *dev_desc=NULL;

        if (argc < 2) {
                printk ("usage: fat info <interface> <dev[:part]>\n");
                return TRUE;
        }

        // dev = (int)simple_strtoul (argv[2], &ep, 16);
        dev = (int) strtoul((const char *) argv[1], (char * *) &ep, 16);

        dev_desc=get_dev(argv[0],dev);
        if (dev_desc==NULL) {
                printk ("\n** Invalid boot device **\n");
                return FALSE;
        }
        if (*ep) {
                if (*ep != ':') {
                        printk ("\n** Invalid boot device, use `dev[:part]' **\n");
                        return FALSE;
                }
                // part = (int)simple_strtoul(++ep, NULL, 16);
                part = (int) strtoul((const char *) (++ep), (char * *) NULL, 16);
        }
        if (fat_register_device(dev_desc,part)!=0) {
                printk ("\n** Unable to use %s %d:%d for fatinfo **\n",argv[0],dev,part);
                return FALSE;
        }
        return ((0 == file_fat_detectfs())?TRUE:FALSE);
}

#endif // #if defined(CONFIG_BOOT_FS_FAT)

/************************************************************************
 *                          help
 ************************************************************************/
int is_init = 0;
static int usb_driver_init(void) {

	printf("Got usb command from shell...\n");

	if(!is_init) {
		extern void USBPHY_Register_Setting(void);
        	//extern void usb_init(void);
        	USBPHY_Register_Setting();
        	usb_init();
		is_init = 1;
	}

	return TRUE;
}

/* Shell command 'usb_cmd' */

static t_cmd shell_usb_cmd =
{
    "usb_cmd", 
    do_usb,
    "usb_cmd",

    "'usb_cmd' send usb requests to boot code.\n",

    NULL,
    0,
    FALSE
};

/************************************************************************
 *  Implementation : Public functions
 ************************************************************************/

/************************************************************************
 *
 *                          shell_usb_cmd_init
 *  Description :
 *  -------------
 *
 *  Initialise command
 *
 *  Return values :
 *  ---------------
 *
 *  void
 *
 ************************************************************************/
t_cmd *
shell_usb_cmd_init() 
{
    return &shell_usb_cmd;
}





static MON_FUNC(do_fat) {
	int i, ret = TRUE;
	struct usb_device *dev = NULL;
	block_dev_desc_t *stor_dev;

	argc--;
	argv++;

        if (argc <= 0)
                goto _err_param;

	if(strncmp(argv[0], "load", 4) == 0) {
		argc--;
		argv++;
		ret = do_fat_fsload(argc, argv);
		return (ret == TRUE)?OK:NOT_OK;
	}

	if(strncmp(argv[0], "ls", 2) == 0) {
		argc--;
		argv++;
		ret = do_fat_ls(argc, argv);
		return (ret == TRUE)?OK:NOT_OK;
	}

	if(strncmp(argv[0], "info", 4) == 0) {
		argc--;
		argv++;
		ret = do_fat_fsinfo(argc, argv);
		return (ret == TRUE)?OK:NOT_OK;
	}

_err_param :
        printk("Usage:\n");
        printk("	FAT load <interface> <dev[:part]> <addr> <filename> [bytes]\n");
	printf("		- load file from FAT to memory\n");
        printk("	FAT ls <interface> <dev[:part]> [directory]\n");
	printk("		- list FAT directories/files\n");
        printk("	FAT info <interface> <dev[:part]>\n");
	printf("		- show FAT info.\n");

        return OK;
}

/* Shell command 'fat_cmd' */

static t_cmd shell_fat_cmd =
{
    "fat_cmd", 
    do_fat,
    "fat_cmd",

    "'fat_cmd' send fat requests to usb storage devices.\n",

    NULL,
    0,
    FALSE
};

/************************************************************************
 *
 *                          shell_fat_cmd_init
 *  Description :
 *  -------------
 *
 *  Initialise command
 *
 *  Return values :
 *  ---------------
 *
 *  void
 *
 ************************************************************************/
t_cmd *
shell_fat_cmd_init() 
{
    return &shell_fat_cmd;
}
