
/***********************************************************************
 *
 *  shell_rescue_inflash.c
 *
 ************************************************************************/
/************************************************************************
 *  Include files
 ************************************************************************/

#include <shell_api.h>
#include <sysdefs.h>
#include <syserror.h>
#include <shell.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <mips.h>

#include <flash_api.h>

#include <shell_golinux.h>
#include <project_config.h>
#include <extern_param.h>

extern t_extern_param *ext_para_ptr;
extern UINT32 shell_go_rescue;

char *go_rescue  = "go 80100000 ";

/************************************************************************
 *                          run_rescue_from_flash
 ************************************************************************/
char *run_rescue_from_flash()
{
    UINT32      streamfile_size = 0;
    UINT8       *src;   
    char        *rs;
    
    if (ext_para_ptr->rescue_img_size == 0)
    {
        printf("Rescue image size error!!\n");
        return NULL;
    }

    if (ext_para_ptr->rescue_img_part0_saddr == 0)
    {
        printf("Rescue first part address error!!\n");
        return NULL;
    }
    
    if (ext_para_ptr->rescue_img_part0_len == 0)
    {
        printf("Rescue first part length error!!\n");
        return NULL;
    }
    
    streamfile_size = ext_para_ptr->rescue_img_part0_len + 
                      ext_para_ptr->rescue_img_part1_len;
    
    if (streamfile_size != ext_para_ptr->rescue_img_size)
    {
        printf("Rescue total size incompatible error!!\n");
        return NULL;
    }
    
    /********* extract rescue linux kernel  ***********/       
    src = ext_para_ptr->rescue_img_part0_saddr;
	
    printf("Rescue kernel in FLASH, total size = 0x%x\n
            seg.1 addr 0x%x, size = 0x%x\n
            seg.2 addr 0x%x, size = 0x%x\n", 
            streamfile_size,
            (UINT32) ext_para_ptr->rescue_img_part0_saddr,
            ext_para_ptr->rescue_img_part0_len,
            (UINT32) ext_para_ptr->rescue_img_part1_saddr,
            ext_para_ptr->rescue_img_part1_len);

    /* merge rescue part0 and part1 to be a completed rescue image*/
    memcpy((char *)COPY_MERGE_ADDRESS, 
           ext_para_ptr->rescue_img_part0_saddr, 
           ext_para_ptr->rescue_img_part0_len);
    
    printf("copy rescue0: from %x to %x, len = %x\n", 
        (UINT32)ext_para_ptr->rescue_img_part0_saddr, 
        COPY_MERGE_ADDRESS, 
        ext_para_ptr->rescue_img_part0_len);

    if (ext_para_ptr->rescue_img_part1_len != 0)
    {
        memcpy((char *)(COPY_MERGE_ADDRESS + ext_para_ptr->rescue_img_part0_len),
               ext_para_ptr->rescue_img_part1_saddr,
               ext_para_ptr->rescue_img_part1_len);
               
        printf("copy rescue1: from %x to %x, len = %x\n", 
            (UINT32)ext_para_ptr->rescue_img_part1_saddr, 
            COPY_MERGE_ADDRESS + ext_para_ptr->rescue_img_part0_len, 
            ext_para_ptr->rescue_img_part1_len);
    }

    printf("decompressing rescue: from %x to %x: size = %x\n", 
        COPY_MERGE_ADDRESS, 
        UNZIP_ADDRESS, 
        streamfile_size);
        
    sys_dcache_flush_all();
    /* decompressing rescue using lzma */
    if( Lzma_main((char *)COPY_MERGE_ADDRESS, 
                  (char *)UNZIP_ADDRESS     ,streamfile_size, rs) != 0)
    {
        printf("decompess Rescue using LZMA error!!\n");
        return NULL;
    }
    
    shell_go_rescue = TRUE;
    
    printf("decompressing rescue done\n");    
    /* Flush caches */ 
    sys_flush_caches();    
    
    return go_rescue;
}   
