/***********************************************************************
 *  shell_goliux.c
 ************************************************************************/
/************************************************************************
 *  Include files
 ************************************************************************/
#include <shell_api.h>
#include <shell.h>
#include <shell_golinux.h>

#include <sys_api.h>
#include <sysdefs.h>
#include <sysdev.h>
#include <flash_api.h>
#include <io_api.h>

#include <syserror.h>
#include <shell.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <mips.h>

#include <project_config.h>
/************************************************************************
 *  Definitions
 ************************************************************************/
#define  MIS_GP0DATI        0x1801b110
#define  MIS_GP1DIR         0x1801b104
#define  SB2_CHIP_INFO      0x1801A204

/************************************************************************
 *  Public variables
 ************************************************************************/
UINT32 *streamfile_ptrA  = (UINT32 *)0xa00000d8;
UINT32 *streamfile_ptrV  = (UINT32 *)0xa00000dc;
UINT32 *streamfile_flagA = (UINT32 *)0xa00000d0;
UINT32 *streamfile_flagV = (UINT32 *)0xa00000d4;

/************************************************************************
 *  Static variables
 ************************************************************************/
 
/************************************************************************
 *
 *                          shell_golinux
 *  Description :
 *  -------------
 *  Implements the shell
 *
 *  Return values :
 *  ---------------
 *  None, function never returns
 *
 ************************************************************************/
/* pvr-module product judge rule */

#ifdef ENABLE_CONSOLE_SWITCH
/* Default UART input/output. */
UINT32 default_port = PORT_TTY0;
#endif /* ENABLE_CONSOLE_SWITCH */

char *shell_golinux( )
{
    int  idx;
    char ch = 0;
    char *raw;

    //if we don't set these address as '0', the avhdd rescue would crash!!
   	*streamfile_flagA = 0;
    *streamfile_flagV = 0;
    *streamfile_ptrA  = 0;
    *streamfile_ptrV  = 0;
    
    //printf("Press 'ESC' to Monitor mode\n");
    
    
    for (idx = 0; idx < 20; idx++)
    {
        if (GETCHAR(DEFAULT_PORT, &ch ))
        {
            if (ch == ESC)
                return NULL;
        }
            
#ifdef ENABLE_CONSOLE_SWITCH
        if(GETCHAR(PORT_TTY1, &ch))
        {
            if (ch == ESC)
            {
                DEFAULT_PORT = PORT_TTY1;
                return NULL;
            } 
        }
#endif /* ENABLE_CONSOLE_SWITCH */
            
    }
    
    printf("\n");
    
    if ( (idx == 20) && env_get( "bootserport", &raw, NULL, 0 ))
    {    
        return run_kernel_from_flash();
    }
    
    return NULL;
}
