
/***********************************************************************
 *
 *  shell_kernel_inflash.c
 *
 ************************************************************************/
/************************************************************************
 *  Include files
 ************************************************************************/
#include <sysdefs.h>
#include <syserror.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <mips.h>

#include <env_api.h>
#include <sys_api.h>
#include <excep_api.h>
#include <io_api.h>
#include <flash_api.h>
#include <sysdev.h>
#include <ide_api.h>
#include <shell.h>
#include <shell_api.h>
#include <shell_golinux.h>

#include <project_config.h>
#include <extern_param.h>
/************************************************************************
 *  Definitions
 ************************************************************************/

/************************************************************************
 *  Public variables
 ************************************************************************/
extern t_extern_param   *ext_para_ptr;

extern UINT32 *streamfile_ptrA;
extern UINT32 *streamfile_ptrV;
extern UINT32 *streamfile_flagA;
extern UINT32 *streamfile_flagV;

char default_go1[128] = "";

/************************************************************************
 *  this function needed in shell subroutine 
 ************************************************************************/
static char *add2string(UINT32 size) 
{
	 UINT32 size_tmp;
	 char   *go;
	 UINT8  index = 0;
	 bool   pre_zero = FALSE; 
	 t_sys_malloc       mem ;
	 
	 mem.size     = 4 * sizeof(char) ;
         mem.boundary = sizeof(char) ;        
         mem.memory   = (void*) &go ; 
         SYSCON_read( SYSCON_BOARD_MALLOC_ID,
                         &mem,
                         sizeof(mem) ) ;
   
	 
         size_tmp = size /10000 ; 
         if (size_tmp == 0)
            pre_zero = TRUE;
         else          
         {            
	    go[index++] =  (char)(size_tmp+0x30) ;
	    
	 } 
	 
	 size     =  size - size_tmp*10000 ;
	 size_tmp =  size / 1000;
	 
	 if((size_tmp != 0)|| (!pre_zero))
	 { 
	       
	    go[index++] =  (char)(size_tmp+0x30) ;
	    pre_zero = FALSE;
	    
	 }   
	 
	
	 
	 
	 size     =  size - size_tmp*1000 ;
	 size_tmp =  size / 100;
	 
	 if((size_tmp != 0)|| (!pre_zero))
	 { 
	       
	    go[index++] =  (char)(size_tmp+0x30) ;
	    pre_zero = FALSE;
	    
	 }   
	
	
	 size     =  size - size_tmp*100 ;
	 size_tmp =  size / 10 ;
	 if((size_tmp != 0)|| (!pre_zero))
	 {
	    
	    go[index++] =  (char)(size_tmp+0x30) ;
	    pre_zero = FALSE;
	    
	 }   
	 
	 size     =  size - size_tmp*10  ;
	 size_tmp =  size / 1 ;
	
	 go[index++]=  (char)(size_tmp+0x30) ;
	  
	
	
	 go[index]= '\0'  ;
         return go;
       
}



/************************************************************************
 *                          run_kernel_from_flash
 ************************************************************************/
/* pvr-module product judge rule */
char *run_kernel_from_flash()
{
    UINT32		streamfile_addr;
    UINT32		streamfile_size  = 0;
    UINT32		wdata;
    UINT32		rc = OK;
    char  		*rs;
    UINT32		magicN;
    UINT8 		*src;
          		
    int   		err;
    
    rc = SYSCON_read( SYSCON_BOARD_MONITORFLASH_SIZE_ID, &wdata, sizeof(wdata) );
              	    
    if( rc != OK )
    {
    	printf ("read flash size error!!\n");
        return NULL;
    }
    	
    /********* extract linux kernel  ***********/       
    src = (UINT8  *)(0xbfd00000 - wdata+ 0x10 + 0x04);
    streamfile_size = *(UINT32 *) src ;
        
    if (!streamfile_size || (streamfile_size == 0xffffffff))
    {
    	printf("no linux kernel in flash , to Monitor mode  \n");
    	return NULL;
    }

        
	streamfile_addr = 0xbfd00000 - wdata + 128; 
			 
	printf("OS kernel in FLASH 0x%x , to 0x%x, size=0x%x\n", streamfile_addr, 
	                                                UNZIP_ADDRESS, streamfile_size);			  
	sys_dcache_flush_all();
	
    if( Lzma_main((char *)streamfile_addr, 
                  (char *)UNZIP_ADDRESS  , streamfile_size, rs) != 0)
    {
        printf("decompess Linux using LZMA error!!\n");
        return NULL;
    }
    
    /* Flush caches */
    sys_flush_caches();
    
    /** jump to linux kernel **/
jump_kernel:

        {
        char *row;

        const UINT8      bin2char[16] = { 0x30, 0x31, 0x32, 0x33, 
				                          0x34, 0x35, 0x36, 0x37,
					                      0x38, 0x39, 0x41, 0x42,
					                      0x43, 0x44, 0x45, 0x46  };

        UINT32 size1, size2, size3, size4, size5;  
				   	
        if( !env_get( "linuxparameter", &row, NULL, 0 ) )
        {
        	printf("\n\nerror !!! no linuxparameter existed!! return to mointor mode\n");
        	return NULL;
        }
        
        printf("linux param = %s \n", row);
        
        strcpy( default_go1, row);
       
        /* convert linux kernel start address to string */
        src--;
            
        default_go1[3] = bin2char[(*src >> 4 )&0x0f]; 
        default_go1[4] = bin2char[(*src >> 0 )&0x0f]; 
        src-- ;
        default_go1[5] = bin2char[(*src >> 4 )&0x0f]; 
        default_go1[6] = bin2char[(*src >> 0 )&0x0f];    
        src-- ;
        default_go1[7] = bin2char[(*src >> 4 )&0x0f]; 
        default_go1[8] = bin2char[(*src >> 0 )&0x0f];  
        src-- ;
        default_go1[9] = bin2char[(*src >> 4 )&0x0f]; 
        default_go1[10] = bin2char[(*src >> 0 )&0x0f];

        /* check flash type : serial / parallel */
        switch(ext_para_ptr->flash_type)
        {
        	/* parellel flash   */
        	case 0xbe:
        		strcat(default_go1, "phys_mapped_flash:");
        		break;
            /* serial SPI flash */
            case 0xde:
            	strcat(default_go1, "VenusSFC:");
            	break;
        }

        size1 = (wdata - 0x100000) / 0x400 ;
        size2 = (0xbfc40000 - 0xbfc00000) / 0x400;
        size3 = ((*(UINT32 *)(0xbfd00000 - wdata + 0x50 ) + (0x400 - 1))&0xfffffc00 ) / 0x400;
        size4 = 0x100000/0x400 - 0x40000/0x400 - size3 ;
         
        strcat(default_go1, add2string(size1));
        strncat(default_go1, "k,", 2);
         
        strcat(default_go1, add2string(size2));
        strncat(default_go1, "k,", 2);
        
        strcat(default_go1, add2string(size3));
        strncat(default_go1, "k,", 2);
         
        strcat(default_go1, add2string(size4));
        strncat(default_go1, "k ", 2);

        printf("%s \n" , default_go1);//cy test             	
        
        return default_go1;
	}
}
