#ifndef SHELL_GOLINUX_H
#define SHELL_GOLINUX_H


#define UNZIP_ADDRESS       0xa0100000
#define COPY_MERGE_ADDRESS  0xa1000000

#ifdef CONFIG_PVRBOX_PC_V2
typedef struct {
	UINT32		checksum;
	UINT8		platform_signature[16];
	UINT8		inst:1,
			reserved:7;
	UINT32		cmd_addr;
	UINT32		max_cmd_len;
	UINT32		part_info_len;
} __attribute__((packed)) platform_status_info_t;

typedef struct {
	UINT8		cmd_code;
	UINT32		checksum;
	UINT8		cmd_ver;
	UINT8		dis:1,
			upg:1,
			cl:1,
			reserved:5;
	UINT32		installer_params_len;
	UINT32		cmd_params_len;
} __attribute__((packed)) pc_install_cmd_t;

#define PLATFORM_STATUS_INFO_OFFSET		(63+(8*1024*1024/512)) //512 bytes sector address
#define PC_INSTALL_V2_CMD_BUF_OFFSET		(PLATFORM_STATUS_INFO_OFFSET + 1) //512 bytes sector address
#define PC_INSTALL_V2_CMD_BUF_MAX_LEN		(64*1024*1024)  //64 MB
#define PLATFORM_SIGNATURE_STRING_V1		"_PC_INSTALL_V1_"
#define PLATFORM_SIGNATURE_STRING_V2		"_PC_INSTALL_V2_"

#endif /* CONFIG_PVRBOX_PC_V2 */

extern int Lzma_main(char *inAddr, char *outAddr, long length, char *rs);


char *shell_golinux();
UINT32 shell_get_time();

#if defined(Rescue_Source_FLASH)
char *run_rescue_from_flash();
#endif

#if defined(Linux_Source_IDE)
char *run_kernel_from_hdd();
#endif

#if defined(Linux_Source_FLASH)
char *run_kernel_from_flash();
#endif


#endif
