/***********************************************************************
 *
 *  shell_kernel_inhdd.c
 *
 ************************************************************************/
/************************************************************************
 *  Include files
 ************************************************************************/
#include <sysdefs.h>
#include <syserror.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <mips.h>

#include <env_api.h>
#include <sys_api.h>
#include <excep_api.h>
#include <io_api.h>
#include <flash_api.h>
#include <sysdev.h>
#include <ide_api.h>
#include <shell.h>
#include <shell_api.h>
#include <shell_golinux.h>

#include <project_config.h>
#include <extern_param.h>
/************************************************************************
 *  Definitions
 ************************************************************************/
#define LINUX_START_SECTOR		0x3f /* 63rd sector */
#define IMAGE_FILE_HEADER_SIZE  0x80 /* 128 byte for image file header, 
                                        each entry occupies 16 bytes */
/************************************************************************
 *  Public variables
 ************************************************************************/
extern UINT32 ide_minor_hdd;

extern UINT32 *streamfile_ptrA;
extern UINT32 *streamfile_ptrV;
extern UINT32 *streamfile_flagA;
extern UINT32 *streamfile_flagV;

char default_go1[128] = "";

/************************************************************************
 *                          run_kernel_from_hdd
 ************************************************************************/
char *run_kernel_from_hdd()
{
   	UINT32 length, address;
   	UINT32 linux_address = 0, linux_length = 0;
   	UINT32 ros1_address  = 0, ros1_length  = 0;
   	UINT32 ros2_address  = 0, ros2_length  = 0;
   	
   	UINT32 streamfile_addr;
   	UINT32 rc, i = 0, size_count = IMAGE_FILE_HEADER_SIZE;
   	
   	/* this address must be '0x800fff80', since linux is following 
   	   image file header. and image file header has 0x80 length.
   	   so the linux start address would be 
   	   0x800fff80 + 0x80 = 0x80100000 */
   	UINT8  *src = (UINT8 *)0x800fff80;//0xa0a00000;

   	void (*jump2)(void); 
   	char ch;
   	int err;
   	
   	t_ide_ctrl_descriptor  ide_ctrl;
    UINT32                 time_on = shell_get_time(), time_now; 
   	
   	
   	while(ide_minor_hdd == 0xff)  
   	{	
       
       time_now = shell_get_time();
        
       	printf("Try to find HDD or 'ESC' to Monitor mode !\n"); 	
       	if (GETCHAR(DEFAULT_PORT, &ch ))
       		if (ch == ESC)    
       	        return NULL;

       if ((time_now - time_on) >= 15) {
          
            printf("HW Reset IDE !\n");
            IO_init( SYS_MAJOR_IDE, IDE_MINOR_PRIMARY_MASTER, 1);
            IO_init( SYS_MAJOR_IDE, IDE_MINOR_SECONDARY_MASTER, 1);
            time_on = time_now ;
       }     
       else     
            IO_init( SYS_MAJOR_IDE, i++, 0);

       	i= i % 4 ;
   	}

   	sys_dcache_flush_all();
   	
   	/* read header */ 
   	ide_ctrl.command         =  IDE_CMD_READ;	
   	ide_ctrl.u.sector.sector =  LINUX_START_SECTOR;  /* 63rd sector */
   	ide_ctrl.u.sector.count  =  0x1;   /* 1 count would read 512 bytes */
   	ide_ctrl.u.sector.buffer =  src;
 
   	rc = IO_ctrl( SYS_MAJOR_IDE, ide_minor_hdd, &ide_ctrl );
   
   	if( rc != OK )
   	{
   		printf("read ide sector error!!\n");
	    return NULL;
	}
	
	/* Flush caches */
   	sys_flush_caches();
   	
   	for (i = 0 ;i < 128 ;i+=16)
   	{
     	switch (*(UINT8 *)(src+i))
     	{
      		case 1: /* bootloader image */
        		break;
      		case 2: /* linux kernel image */                         	   	             
	     		*(UINT8 *) (&address)    =  *(UINT8 *)(src+i+1);
	     		*((UINT8 *)(&address)+1) =  *(UINT8 *)(src+i+2);
	     		*((UINT8 *)(&address)+2) =  *(UINT8 *)(src+i+3);
	     		*((UINT8 *)(&address)+3) =  *(UINT8 *)(src+i+4);
	     		
	     		*(UINT8 *) (&length)    =  *(UINT8 *)(src+i+5);
	     		*((UINT8 *)(&length)+1) =  *(UINT8 *)(src+i+6);
	     		*((UINT8 *)(&length)+2) =  *(UINT8 *)(src+i+7);
	     		*((UINT8 *)(&length)+3) =  *(UINT8 *)(src+i+8);
	     		
	     		size_count +=  length;
	     		linux_length = length;
	     		
	     		jump2 =(void *) address;   
         		
         		break;
      		case 3: /* ROS kernel image */
            	*(UINT8 *) (&address)    =  *(UINT8 *)(src+i+1);	    
	     		*((UINT8 *)(&address)+1) =  *(UINT8 *)(src+i+2);	     
	     		*((UINT8 *)(&address)+2) =  *(UINT8 *)(src+i+3);	       
	     		*((UINT8 *)(&address)+3) =  *(UINT8 *)(src+i+4);
           
             	*(UINT8 *)(&length)     =  *(UINT8 *)(src+i+5);
	     	 	*((UINT8 *)(&length)+1) =  *(UINT8 *)(src+i+6);
	     		*((UINT8 *)(&length)+2) =  *(UINT8 *)(src+i+7);
	     		*((UINT8 *)(&length)+3) =  *(UINT8 *)(src+i+8);
             	
	     		size_count +=  length ;
	     		if (ros1_length == 0)
	     		{
	     		  	ros1_length  =  length ; 
	     		  	ros1_address =  address; /* RAM location */
#if 0	     		  	
	     		  	printf("ros1_len = %d, addr = %x\n", ros1_length, ros1_address);
#endif
	     		}
	     		else
	     		{
	     		  	ros2_length  =  length ; 
	     		  	ros2_address =  address; /* RAM location */
#if 0	     		  	
	     		  	printf("ros2_len = %d, addr = %x\n", ros2_length, ros2_address);
#endif
	     		}
	     		
             	break;
      		case 4: /* jffs2 file system */
      		case 5: /* squash file system */
      		case 6: /* ext3 file system */     
      		case 0 :

             	break;
      		default :
             	printf("header in HDD error \n");
             	return NULL;   
     	}
	
   	}    
	    
   	/* compute partition 1 size (16 heads , 63 sectors) */
   	sys_dcache_flush_all();
   	/* read partition 1 */ 
   	ide_ctrl.command         = IDE_CMD_READ;	
   	ide_ctrl.u.sector.sector =  LINUX_START_SECTOR;
   	ide_ctrl.u.sector.count  =  size_count/512 +1;             
   	ide_ctrl.u.sector.buffer =  src;
   	
   	rc = IO_ctrl( SYS_MAJOR_IDE, ide_minor_hdd, &ide_ctrl );
   	
   	if( rc != OK )
   	{
   		printf("compute partition 1 size error!!\n");
	    return NULL;
	}
   
   	/* Flush caches */
   	sys_flush_caches();
   	
   	/********* extract linux kernel  ***********/       
   	          
   	if (!linux_length)
   	{
   	   	printf("no linux kernel in HDD , to Monitor mode  \n");
   	   	return NULL;
   	}                 
  
   	streamfile_addr = (UINT32)src + IMAGE_FILE_HEADER_SIZE; 
	
   	printf("OS kernel in HDD , size=0x%x\n", linux_length);		
    
  	/* Flush caches */
   	sys_flush_caches();
 	
 	/********* extract audio ROS kernel  ***********/       
	
   	if (!ros1_length)
   	{
   	   	printf("no audio ROS kernel in HDD \n");
   	   	goto video_extract;
   	}
  
   	streamfile_addr = (UINT32)src + IMAGE_FILE_HEADER_SIZE + linux_length; 
			 
   	printf("OS kernel in HDD , size=0x%x\n", ros1_length);
    
   	memcpy((void *)ros1_address, (const void *)streamfile_addr, ros1_length) ;           
#if 0   	
  	printf("ros_address = %x, mem_addr = %x\n", ros1_address, streamfile_addr);
#endif
     
   	/* Flush caches */ 
   	sys_flush_caches();	   
   *streamfile_ptrA = SWAPEND32(ros1_address) ;

video_extract:

  /********* extract video ROS kernel  ***********/       
	
   	if (!ros2_length)
   	{
   	   	printf("no video ROS kernel in HDD \n");
   	   	goto jump_kernel;
   	}
   	
   	streamfile_addr = (UINT32)src + IMAGE_FILE_HEADER_SIZE + linux_length + ros1_length; 
   	
   	printf("OS kernel in HDD , size=0x%x\n", ros2_length);
	
   	memcpy((void *)ros2_address, (const void *)streamfile_addr, ros2_length);
#if 0   	
   	printf("ros_address = %x, mem_addr = %x\n", ros2_address, streamfile_addr);
#endif
   	/* Flush caches */ 
   	sys_flush_caches();
   *streamfile_ptrV = SWAPEND32(ros2_address) ;     
    
    /********* Release hardware semaphore **/
    /*other CPUs has been waiting for this  cy test */
   	REG32(KSEG1(HW_SEMAPHORE_ADDRESS))= 0x0;
    
    /** jump to linux kernel **/
jump_kernel:
   	
   	{	
        char *row;
        
    	const UINT8      bin2char[16] = { 0x30, 0x31, 0x32, 0x33, 
					   					  0x34, 0x35, 0x36, 0x37,
					   					  0x38, 0x39, 0x41, 0x42,
					   					  0x43, 0x44, 0x45, 0x46  };
        
        if( !env_get( "linuxparameter", &row, NULL, 0 ) )
        {
        	printf("\n\nerror !!! no linuxparameter existed!! return to mointor mode\n");
        	return NULL;
        }
        
        strcpy( default_go1, row);
        
        /* convert linux kernel start address to string */
		src = (UINT8 *)(&jump2);
        
        
        default_go1[9]  = bin2char[(*src >> 4 )&0x0f];
        default_go1[10] = bin2char[(*src >> 0 )&0x0f];
        src++ ;
        default_go1[7] = bin2char[(*src >> 4 )&0x0f];
        default_go1[8] = bin2char[(*src >> 0 )&0x0f];
        src++ ;
        default_go1[5] = bin2char[(*src >> 4 )&0x0f];
        default_go1[6] = bin2char[(*src >> 0 )&0x0f];
        src++ ;
        default_go1[3] = bin2char[(*src >> 4 )&0x0f];
        default_go1[4] = bin2char[(*src >> 0 )&0x0f];
        
        default_go1[27] = 'a' +ide_minor_hdd;
        
        printf("%s \n" , default_go1);//cy test             	
        
        return default_go1;
   	}
}
