
/***********************************************************************
 *
 *  shell_rescue_inflash.c
 *
 ************************************************************************/
/************************************************************************
 *  Include files
 ************************************************************************/

#include <shell_api.h>
#include <sysdefs.h>
#include <sysdev.h>
#include <syserror.h>
#include <shell.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <mips.h>

#include <flash_api.h>
#include <ide_api.h>

#include <shell_golinux.h>
#include <project_config.h>
#include <extern_param.h>

#define  LINUX_START_SECTOR 0x3f /* 63rd sector */

extern t_extern_param *ext_para_ptr;
extern UINT32 ide_minor_hdd;
extern UINT32 shell_go_rescue;

char *go_rescue  = "go 80100000 ";

/************************************************************************
 *                          run_rescue_from_flash
 ************************************************************************/
char *run_rescue_from_flash()
{
    UINT32      streamfile_size = 0, i=0, rc=0;
    UINT8       *src;   
    char        *rs, ch;
    t_ide_ctrl_descriptor  ide_ctrl;
    
    UINT32                 time_on = shell_get_time(), time_now; 
    
    
    while(ide_minor_hdd == 0xff)  
    {   
       
       time_now = shell_get_time();
        
        printf("Before run rescue, try to find HDD.  Press 'ESC' to Monitor mode !\n");
        if (GETCHAR(DEFAULT_PORT, &ch ))
            if (ch == ESC)    
                return NULL;

       if ((time_now - time_on) >= 15) {
          
            printf("HW Reset IDE !\n");
            IO_init( SYS_MAJOR_IDE, IDE_MINOR_PRIMARY_MASTER, 1);
            IO_init( SYS_MAJOR_IDE, IDE_MINOR_SECONDARY_MASTER, 1);
            time_on = time_now ;
       }     
       else     
            IO_init( SYS_MAJOR_IDE, i++, 0);

        i= i % 4 ;
    }

    sys_dcache_flush_all();


    if (ext_para_ptr->rescue_img_size == 0)
    {
        printf("Rescue image size error!!\n");
        return NULL;
    }

    if (ext_para_ptr->rescue_img_part0_saddr == 0)
    {
        printf("Rescue first part address error!!\n");
        return NULL;
    }
    
    if (ext_para_ptr->rescue_img_part0_len == 0)
    {
        printf("Rescue first part length error!!\n");
        return NULL;
    }
    
    streamfile_size = ext_para_ptr->rescue_img_part0_len + 
                      ext_para_ptr->rescue_img_part1_len;
    
    if (streamfile_size != ext_para_ptr->rescue_img_size)
    {
        printf("Rescue total size incompatible error!!\n");
        return NULL;
    }
    
    /********* extract rescue linux kernel  ***********/       
    src = ext_para_ptr->rescue_img_part0_saddr;
    
    printf("Rescue kernel in FLASH, total size = 0x%x\n
            seg.1 addr 0x%x, size = 0x%x\n
            seg.2 addr 0x%x, size = 0x%x\n", 
            streamfile_size,
            (UINT32) ext_para_ptr->rescue_img_part0_saddr,
            ext_para_ptr->rescue_img_part0_len,
            (UINT32) ext_para_ptr->rescue_img_part1_saddr,
            ext_para_ptr->rescue_img_part1_len);

    /* merge rescue part0 and part1 to be a completed rescue image*/
    memcpy((char *)COPY_MERGE_ADDRESS, 
           ext_para_ptr->rescue_img_part0_saddr, 
           ext_para_ptr->rescue_img_part0_len);
    
    printf("copy rescue0: from %x to %x, len = %x\n", 
        (UINT32)ext_para_ptr->rescue_img_part0_saddr, 
        COPY_MERGE_ADDRESS, 
        ext_para_ptr->rescue_img_part0_len);

    if (ext_para_ptr->rescue_img_part1_len != 0)
    {
        memcpy((char *)(COPY_MERGE_ADDRESS + ext_para_ptr->rescue_img_part0_len),
               ext_para_ptr->rescue_img_part1_saddr,
               ext_para_ptr->rescue_img_part1_len);
               
        printf("copy rescue1: from %x to %x, len = %x\n", 
            (UINT32)ext_para_ptr->rescue_img_part1_saddr, 
            COPY_MERGE_ADDRESS + ext_para_ptr->rescue_img_part0_len, 
            ext_para_ptr->rescue_img_part1_len);
    }

    printf("decompressing rescue: from %x to %x: size = %x\n", 
        COPY_MERGE_ADDRESS, 
        UNZIP_ADDRESS, 
        streamfile_size);
        
    sys_dcache_flush_all();
    /* decompressing rescue using lzma */
    if( Lzma_main((char *)COPY_MERGE_ADDRESS, 
                  (char *)UNZIP_ADDRESS     ,streamfile_size, rs) != 0)
    {
        printf("decompess Rescue using LZMA error!!\n");
        return NULL;
    }
    
    shell_go_rescue = TRUE;
    
    printf("decompressing rescue done\n");    
    /* Flush caches */ 
    sys_flush_caches();    
    
    return go_rescue;
}   
