#ifndef SHELL_GOLINUX_H
#define SHELL_GOLINUX_H


#define UNZIP_ADDRESS       0xa0100000
#define COPY_MERGE_ADDRESS  0xa1000000

#define FIRMWARE_DESCRIPTION_TABLE_SIGNATURE	"VERONA__" /* 8 bytes signature. */

typedef struct {
	UINT8	signature[8];
	UINT32	checksum;
	UINT8	version;
	UINT8	reserved[15];
	UINT32	length;
} __attribute__((packed)) fw_desc_table_t;

typedef struct {
	UINT8	type;
#ifdef EL
	UINT8	reserved:7,
		ro:1;
#else
	UINT8	ro:1,
		reserved:7;
#endif
	UINT32	version;
	UINT32	target_addr;
	UINT32	offset;
	UINT32	length;
	UINT32	paddings;
	UINT32	checksum;
	UINT32	offset_1;
	UINT8	reserved_1[2];
} __attribute__((packed)) fw_desc_entry_t;

typedef enum {
	FW_IDX_LINUX_KERNEL = 0,
	FW_IDX_AUDIO,
	FW_IDX_VIDEO,
	FW_IDX_SQUASH,
	FW_IDX_JFFS2,
	FW_IDX_BOOTCODE,
} fw_desc_index_t;

typedef enum {
	FW_TYPE_RESERVED = 0,
	FW_TYPE_BOOTCODE,
	FW_TYPE_KERNEL,
	FW_TYPE_AUDIO,
	FW_TYPE_VIDEO,
	FW_TYPE_JFFS2,
	FW_TYPE_SQUASH,
	FW_TYPE_EXT3,
	FW_TYPE_ODD,
} fw_type_code_t;


/* Verona Simple Command Information Table. (SCIT) */
#define VERONA_SCIT_SIGNATURE_STRING	"SCIT____"
typedef struct {
	UINT8	signature[8];
	UINT8	reserved1[8];
	UINT8	fw_pkg_file_name_len;
	UINT8	*fw_pkg_file_name;
} __attribute__((packed)) verona_scit_t;


extern int Lzma_main(char *inAddr, char *outAddr, long length, char *rs);


char *shell_golinux();
UINT32 shell_get_time();

#if defined(Rescue_Source_FLASH)
char *run_rescue_from_flash();
#endif

#if defined(Linux_Source_IDE)
char *run_kernel_from_hdd();
#endif

#if defined(Linux_Source_FLASH)
char *run_kernel_from_flash(UINT32 flash_start_addr, UINT32 flash_size,
			fw_desc_entry_t *fw_desc_entry, int entry_count);
#endif


#endif
