
/***********************************************************************
 *
 *  shell_kernel_inflash.c
 *
 ************************************************************************/
/************************************************************************
 *  Include files
 ************************************************************************/
#include <sysdefs.h>
#include <syserror.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <mips.h>

#include <env_api.h>
#include <sys_api.h>
#include <excep_api.h>
#include <io_api.h>
#include <flash_api.h>
#include <sysdev.h>
#include <ide_api.h>
#include <shell.h>
#include <shell_api.h>
#include <shell_golinux.h>

#include <project_config.h>
#include <extern_param.h>
/************************************************************************
 *  Definitions
 ************************************************************************/

/************************************************************************
 *  Public variables
 ************************************************************************/
extern t_extern_param   *ext_para_ptr;

//neil
#ifdef Config_QC_Test_Prog_TRUE
extern UINT32 QC_test_enabled;
#endif /* Config_QC_Test_Prog_TRUE */
extern UINT32 MP_test_enabled;
//neil

extern UINT32 *streamfile_ptrA;
extern UINT32 *streamfile_ptrV;
extern UINT32 *streamfile_flagA;
extern UINT32 *streamfile_flagV;

extern UINT32 ide_minor_hdd;
extern UINT32 is_sata;

char default_go1[128] = "";

/************************************************************************
 *  this function needed in shell subroutine 
 ************************************************************************/
static char *add2string(UINT32 size) 
{
	 UINT32 size_tmp;
	 char   *go;
	 UINT8  index = 0;
	 bool   pre_zero = FALSE; 
	 t_sys_malloc       mem ;
	 
	 mem.size     = 4 * sizeof(char) ;
         mem.boundary = sizeof(char) ;        
         mem.memory   = (void*) &go ; 
         SYSCON_read( SYSCON_BOARD_MALLOC_ID,
                         &mem,
                         sizeof(mem) ) ;
   
	 
         size_tmp = size /10000 ; 
         if (size_tmp == 0)
            pre_zero = TRUE;
         else          
         {            
	    go[index++] =  (char)(size_tmp+0x30) ;
	    
	 } 
	 
	 size     =  size - size_tmp*10000 ;
	 size_tmp =  size / 1000;
	 
	 if((size_tmp != 0)|| (!pre_zero))
	 { 
	       
	    go[index++] =  (char)(size_tmp+0x30) ;
	    pre_zero = FALSE;
	    
	 }   
	 
	
	 
	 
	 size     =  size - size_tmp*1000 ;
	 size_tmp =  size / 100;
	 
	 if((size_tmp != 0)|| (!pre_zero))
	 { 
	       
	    go[index++] =  (char)(size_tmp+0x30) ;
	    pre_zero = FALSE;
	    
	 }   
	
	
	 size     =  size - size_tmp*100 ;
	 size_tmp =  size / 10 ;
	 if((size_tmp != 0)|| (!pre_zero))
	 {
	    
	    go[index++] =  (char)(size_tmp+0x30) ;
	    pre_zero = FALSE;
	    
	 }   
	 
	 size     =  size - size_tmp*10  ;
	 size_tmp =  size / 1 ;
	
	 go[index++]=  (char)(size_tmp+0x30) ;
	  
	
	
	 go[index]= '\0'  ;
         return go;
       
}

fw_desc_entry_t *get_fw_desc_entry(fw_desc_entry_t *fw_desc_entry,
				int entry_count, fw_type_code_t type) {
	fw_desc_entry_t *entry;
	int i;

	for(i = 0; i < entry_count; i++) {
		entry = &fw_desc_entry[i];
		if(fw_desc_entry[i].type == type) {
			return entry;
		}
	}

	return NULL;
}


extern void		error_led_blinking(void); //neil flash/memory error blinking (shell.c)

/************************************************************************
 *                          run_kernel_from_flash
 ************************************************************************/
/* avhdd product judge rule */
char *run_kernel_from_flash(UINT32 flash_start_addr, UINT32 flash_size,
		fw_desc_entry_t *fw_desc_entry, int entry_count) {
	UINT32 streamfile_addr;
	UINT32 streamfile_size  = 0;
	UINT32 rc = OK;
	char *rs;
	UINT8 *src;
	UINT32 addr;
	int err;
	fw_desc_entry_t *kernel_entry, *audio_entry, *video_entry;
   	
    
	/********* extract linux kernel  ***********/
	if((kernel_entry = get_fw_desc_entry(fw_desc_entry,
			entry_count, FW_TYPE_KERNEL)) == NULL || 
			(streamfile_size = kernel_entry->length) == 0) {
		printf("no linux kernel in flash , to Monitor mode  \n");
		error_led_blinking(); //neil
		return NULL;
	}
        
	streamfile_addr = flash_start_addr + kernel_entry->offset;
	if(streamfile_addr == (UINT32)ext_para_ptr->rescue_img_part0_saddr) {
		streamfile_size = kernel_entry->length - kernel_entry->paddings;
		printf("Copy OS kernel from FLASH 0x%x, to 0x%x, size=0x%x\n",
				streamfile_addr, COPY_MERGE_ADDRESS, streamfile_size);
		memcpy((void*)COPY_MERGE_ADDRESS, (void*)streamfile_addr,
								streamfile_size);

		streamfile_addr = flash_start_addr + kernel_entry->offset_1;
		printf("Copy OS kernel from FLASH 0x%x, to 0x%x, size=0x%x\n",
				streamfile_addr, COPY_MERGE_ADDRESS + streamfile_size,
				kernel_entry->paddings);
		memcpy((void*)(COPY_MERGE_ADDRESS + streamfile_size),
				(void*)streamfile_addr,
				kernel_entry->paddings);
		printf("OS kernel in memory 0x%x, to 0x%x, size=0x%x\n",
				COPY_MERGE_ADDRESS, UNZIP_ADDRESS, streamfile_size);
		src = (char*)COPY_MERGE_ADDRESS;
	} else {
		streamfile_addr = flash_start_addr + kernel_entry->offset;
		printf("OS kernel in FLASH 0x%x , to 0x%x, size=0x%x\n",
				streamfile_addr, UNZIP_ADDRESS, streamfile_size);
		src = (char*)streamfile_addr;
	}


	streamfile_size = kernel_entry->length;
	sys_dcache_flush_all();

	if(Lzma_main((char*)src,
			(char*)UNZIP_ADDRESS, streamfile_size, rs) != 0) {
		printf("decompess Linux using LZMA error!!\n");
		error_led_blinking(); //neil
		return NULL;
	}

	/* Flush caches */
	sys_flush_caches();
    

	/********* extract audio ros kernel  ***********/
	if((audio_entry = get_fw_desc_entry(fw_desc_entry,
			entry_count, FW_TYPE_AUDIO)) == NULL || 
			(streamfile_size = audio_entry->length) == 0) {
		printf("no audio ros kernel in flash \n");
		error_led_blinking(); //neil
		goto extract_video;
	}

	streamfile_addr = flash_start_addr + audio_entry->offset;

	printf("OS kernel in FLASH 0x%x to 0x%x, size=0x%x\n",
				streamfile_addr, audio_entry->target_addr, streamfile_size);

	sys_dcache_flush_all();
    
	if(Lzma_main((char*)streamfile_addr,
			(char *)audio_entry->target_addr, streamfile_size, rs) != 0) {
		printf("decompess Audio using LZMA error!!\n");
		error_led_blinking(); //neil
		return NULL;
	}

	/* Flush caches */
	sys_flush_caches();

	*streamfile_ptrA = CPU_TO_BE32(audio_entry->target_addr);

	/********* extract video ros kernel  ***********/
extract_video:
	if((video_entry = get_fw_desc_entry(fw_desc_entry,
			entry_count, FW_TYPE_VIDEO)) == NULL || 
			(streamfile_size = video_entry->length) == 0) {
		printf("no video ros kernel in flash \n");
		error_led_blinking(); //neil
		goto jump_kernel;
	}

	streamfile_addr = flash_start_addr + video_entry->offset;

	printf("OS kernel in FLASH 0x%x to 0x%x, size=0x%x\n",
				streamfile_addr, video_entry->target_addr, streamfile_size);

	sys_dcache_flush_all();

	if(Lzma_main((char*)streamfile_addr,
			(char *)video_entry->target_addr, streamfile_size, rs) != 0) {
		printf("decompess Video using LZMA error!!\n");
		error_led_blinking(); //neil
		return NULL;
	}

	/* Flush caches */
	sys_flush_caches();

	*streamfile_ptrV = CPU_TO_BE32(video_entry->target_addr);

	/********* Release hardware semaphore **/
	/*other CPUs has been waiting for this  cy test */
	REG32(KSEG1(HW_SEMAPHORE_ADDRESS)) = 0;

	/** jump to linux kernel **/
jump_kernel:
	
	{ //neil clear log memory
		UINT32	log_endaddr;
		UINT32	log_len;
		int		i;
		char *p = (char *)0xa00f0000;
		
		log_len = ext_para_ptr->logo_img_len > ext_para_ptr->logo2_img_len ? ext_para_ptr->logo_img_len : ext_para_ptr->logo2_img_len;
		log_len = log_len > ext_para_ptr->logo3_img_len ? log_endaddr : ext_para_ptr->logo3_img_len;

		for(i=0;i<log_len;i++) *p++ = 0;
	}

    {
	char *row;
	const UINT8 bin2char[16] = { 0x30, 0x31, 0x32, 0x33,
					0x34, 0x35, 0x36, 0x37,
					0x38, 0x39, 0x41, 0x42,
					0x43, 0x44, 0x45, 0x46};

	UINT32 size;
	int i;

	if(!env_get("linuxparameter", &row, NULL, 0)) {
		printf("\n\nerror !!! no linuxparameter existed!! return to mointor mode\n");
		return NULL;
	}


	printf("linux param = %s \n", row);

	strcpy( default_go1, row);

	/* convert linux kernel start address to string */
	addr = CPU_TO_BE32(kernel_entry->target_addr);
	src = (UINT8*)&addr;

	default_go1[3] = bin2char[(*src >> 4 )&0x0f]; 
	default_go1[4] = bin2char[(*src >> 0 )&0x0f]; 
	src++ ;
	default_go1[5] = bin2char[(*src >> 4 )&0x0f]; 
	default_go1[6] = bin2char[(*src >> 0 )&0x0f];    
	src++ ;
	default_go1[7] = bin2char[(*src >> 4 )&0x0f]; 
	default_go1[8] = bin2char[(*src >> 0 )&0x0f];  
	src++ ;
	default_go1[9] = bin2char[(*src >> 4 )&0x0f]; 
	default_go1[10] = bin2char[(*src >> 0 )&0x0f];

	/* check flash type : serial / parallel */
	switch(ext_para_ptr->flash_type) {
	/* parellel flash   */
	case 0xbe:
		strcat(default_go1, "phys_mapped_flash:");
		break;
	/* serial SPI flash */
	case 0xde:
		strcat(default_go1, "VenusSFC:");
		break;
	}

	size = fw_desc_entry[FW_IDX_SQUASH].offset / 0x400;
	strcat(default_go1, add2string(size));
	strncat(default_go1, "k,", 2);

	for(i = 3; i < entry_count; i++) {
		if(fw_desc_entry[i].type == FW_TYPE_RESERVED) {
			break;
		}
		size = fw_desc_entry[i].paddings / 0x400;
	       	strcat(default_go1, add2string(size));
		if(i == (entry_count - 1) ||
			fw_desc_entry[i+1].type == FW_TYPE_RESERVED) {
	       		strncat(default_go1, "k ", 2);
		} else {
	       		strncat(default_go1, "k,", 2);
		}
	}

//neil MP Test
#ifdef Config_QC_Test_Prog_TRUE
	if (QC_test_enabled == 1 || MP_test_enabled == 1) 
		strcat(default_go1, " mptest");
#endif /* Config_QC_Test_Prog_TRUE */

	printf("%s \n" , default_go1);//cy test             	

	if(is_sata) {
		t_ide_ctrl_descriptor  ide_ctrl;
		char ch;
		UINT32 time_on = shell_get_time(), time_now, time_round; 
		UINT32 i = 0;

		time_round = time_on;
		time_now = time_on;
		while((ide_minor_hdd == 0xff) && ((time_now - time_on) <= 30)) {
			time_now = shell_get_time();

			printf("Try to find HDD or 'ESC' to Monitor mode !\n"); 	
			if(GETCHAR(DEFAULT_PORT, &ch)) {
				if(ch == ESC)
					return NULL;
			}

			if((time_now - time_round) >= 15) {
				printf("HW Reset IDE !\n");
				IO_init( SYS_MAJOR_IDE, IDE_MINOR_PRIMARY_MASTER, 1);
				IO_init( SYS_MAJOR_IDE, IDE_MINOR_SECONDARY_MASTER, 1);
				time_round = time_now;
			} else {
				IO_init( SYS_MAJOR_IDE, i++, 0);
			}

			i = i % 4;
		}
		sys_dcache_flush_all();
	}
		
        return default_go1;
    }
}
