
/************************************************************************
 *
 *  atlas_malta_platform.S
 *
 *  Atlas and Malta specific initialisation
 *
 * ######################################################################
 *
 * mips_start_of_legal_notice
 * 
 * Copyright (c) 2003 MIPS Technologies, Inc. All rights reserved.
 *
 *
 * Unpublished rights (if any) reserved under the copyright laws of the
 * United States of America and other countries.
 *
 * This code is proprietary to MIPS Technologies, Inc. ("MIPS
 * Technologies"). Any copying, reproducing, modifying or use of this code
 * (in whole or in part) that is not expressly permitted in writing by MIPS
 * Technologies or an authorized third party is strictly prohibited. At a
 * minimum, this code is protected under unfair competition and copyright
 * laws. Violations thereof may result in criminal penalties and fines.
 *
 * MIPS Technologies reserves the right to change this code to improve
 * function, design or otherwise. MIPS Technologies does not assume any
 * liability arising out of the application or use of this code, or of any
 * error or omission in such code. Any warranties, whether express,
 * statutory, implied or otherwise, including but not limited to the implied
 * warranties of merchantability or fitness for a particular purpose, are
 * excluded. Except as expressly provided in any written license agreement
 * from MIPS Technologies or an authorized third party, the furnishing of
 * this code does not give recipient any license to any intellectual
 * property rights, including any patent rights, that cover this code.
 *
 * This code shall not be exported or transferred for the purpose of
 * reexporting in violation of any U.S. or non-U.S. regulation, treaty,
 * Executive Order, law, statute, amendment or supplement thereto.
 *
 * This code constitutes one or more of the following: commercial computer
 * software, commercial computer software documentation or other commercial
 * items. If the user of this code, or any related documentation of any
 * kind, including related technical data or manuals, is an agency,
 * department, or other entity of the United States government
 * ("Government"), the use, duplication, reproduction, release,
 * modification, disclosure, or transfer of this code, or any related
 * documentation of any kind, is restricted in accordance with Federal
 * Acquisition Regulation 12.212 for civilian agencies and Defense Federal
 * Acquisition Regulation Supplement 227.7202 for military agencies. The use
 * of this code by the Government is further restricted in accordance with
 * the terms of the license agreement(s) and/or applicable contract terms
 * and conditions covering this code from MIPS Technologies or an authorized
 * third party.
 *
 * 
 * mips_end_of_legal_notice
 * 
 *
 ************************************************************************/


/************************************************************************
 *  Include files
 ************************************************************************/

#include <sysdefs.h>
#include <mips.h>


#include <init.h>
#include <product.h>

#include <malta.h>


/************************************************************************
 *  Definitions
 ************************************************************************/

/******** Definitions for I2C controller on Malta ********/

#define SCL_TX		MALTA_I2COE_I2CSCL_BIT
#define SCL_RX		0
#define SDA_TX		MALTA_I2COE_I2CSDA_BIT
#define SDA_RX		0

#define SCL_HI		MALTA_I2COUT_I2CSCL_BIT
#define SCL_LO		0
#define SDA_HI		MALTA_I2COUT_I2CSDA_BIT
#define SDA_LO		0

/*  Loop counter for PAUSE loop :
 *
 *  Each iteration of loop consists of two instructions, i.e. two
 *  processor clock cycles (assuming cached operation).
 *
 *  A pause loop should delay the processor half an I2C clock cycle.
 *
 *  We assume a max. processor frequency of 1000MHz.
 */


/************************************************************************
 *  Public variables
 ************************************************************************/

/************************************************************************
 *  Static variables
 ************************************************************************/

/************************************************************************
 *  Implementation : Public functions
 ************************************************************************/


/************************************************************************
 *
 *                          sys_init_atlas_malta
 *  Description :
 *  -------------
 *
 *  Determine SDRAM parameters and configure North Bridge.
 *
 *  SDRAM configuration is conservative since we do not know the bus
 *  frequency yet. However, after this function has been called,
 *  a memory test can be performed. Later, when we know the bus
 *  frequency, the SDRAM configuration may be optimised.
 *
 *  Parameters :
 *  ------------
 *
 *  k0 = Platform ID
 *
 *  Return values :
 *  ---------------
 *
 *  v0 = error code (0 = no error)
 *  v1 = RAM size in bytes
 *
 ************************************************************************/
LEAF(sys_init_atlas_malta)

	.set noreorder


#define RA		    gp

	move		    RA, ra

setup_sdram:

	jal	sys_core_configure_sdram  
	nop



        jr      RA
	nop

#undef RA


END(sys_init_atlas_malta)



/************************************************************************
 *  Implementation : Static functions
 ************************************************************************/


