
/************************************************************************
 *
 *  realtek_recovery.S
 *
 *  Rescue from fatal setting causes bootcode broken
 ************************************************************************/

/************************************************************************
 *  Include files
 ************************************************************************/

#include <sysdefs.h>
#include <mips.h>

/************************************************************************
 *  Definitions
 ************************************************************************/

/************************************************************************
 *  Public variables
 ************************************************************************/

/************************************************************************
 *  Static variables
 ************************************************************************/

/************************************************************************
 *  Implementation : Public functions
 ************************************************************************/

    .set noreorder
    
/************************************************************************
 *
 *                          realtek_recovery
 *  Description :
 *  -------------
 *
 *  input :
 *  
 *  Return values :
 *  ---------------
 *
 ************************************************************************/
LEAF(realtek_recovery)
#define RA          t9

    /* preserved return address to RA */
    move    RA, ra

    /* De-assert MISC reset */
    lw      t7, 0xb8000000;
    lw      t0, 0xb8000000;
    or      t0, 0x2;
    sw      t0, 0xb8000000;


     /* delay nops */
    li      t0, 1000   
    li      t1, 0
1:
    nop
    bne     t0, t1, 1b
    addiu   t1, t1, 1


    /* Turn on MISC clock */
    lw      t8, 0xb8000004;
    lw      t0, 0xb8000004;
    or      t0, 0x2;
    sw      t0, 0xb8000004;


    /* delay nops */
    li      t0, 1000   
    li      t1, 0
1:
    nop
    bne     t0, t1, 1b
    addiu   t1, t1, 1
    

    /*************************
    ** Initialize UART port
    *************************/
    
    li      t0, 0x80;
    sw      t0, 0xb801b20c; 
    
    li      t0, 0xe;
    sw      t0, 0xb801b200; 
    
    li      t0, 0x0;
    sw      t0, 0xb801b204; 
    
    li      t0, 0x3;
    sw      t0, 0xb801b20c; 
    
    li      t0, 0x0;
    sw      t0, 0xb801b204; 
    
    li      t0, 0x4f;
    sw      t0, 0xb801b208; 
    
    li      t0, 0x02;
    sw      t0, 0xb801b210;

    /* delay nops */
    li      t0, 1000   
    li      t1, 0
1:
    nop
    bne     t0, t1, 1b
    addiu   t1, t1, 1
    
    
    /*************************
    ** Get Input Key
    *************************/
    li      t0, 100000
    li      t1, 0
1:
    
    /* check if input valid */
    lw      t2, 0xb801b214
    and     t2, 0x1
    
    /* input is not valid, go to add counter */
    beqz	t2, 9f;
    nop
    
    /* input is valid, get input value */
    lw      t3, 0xb801b200
    and     t3, 0xff
    
    /* if input 0x80, perform update register and image */
    li      t4, 0x80
    beq     t3, t4, 1f
    nop
    
    /* if input 'R' perform update register and return */
    li      t4, 0x81
    beq     t3, t4, 2f
    nop 

9:    
    /* adding loop count for routine checking */ 
    bne     t0, t1, 1b
    addiu   t1, t1, 1
    
    
    /* no input, return to normal executing flow */
    b       3f;
    nop
    
    
    /* update register and image, then restart execute bootcode */
1:  
    li      t0, 0x55		/*U*/
    sw      t0, 0xb801b200
    li      t0, 0x70		/*p*/
    sw      t0, 0xb801b200
    li      t0, 0x64		/*d*/
    sw      t0, 0xb801b200
    li      t0, 0x61		/*a*/
    sw      t0, 0xb801b200
    li      t0, 0x74		/*t*/
    sw      t0, 0xb801b200
    li      t0, 0x65		/*e*/
    sw      t0, 0xb801b200
    li      t0, 0x20		/* */
    sw      t0, 0xb801b200
    li      t0, 0x52		/*R*/
    sw      t0, 0xb801b200
    li      t0, 0x65		/*e*/
    sw      t0, 0xb801b200
    li      t0, 0x67		/*g*/
    sw      t0, 0xb801b200
    li      t0, 0x73		/*s*/
    sw      t0, 0xb801b200
    li      t0, 0x2b		/*+*/
    sw      t0, 0xb801b200
    li      t0, 0x49		/*I*/
    sw      t0, 0xb801b200
    li      t0, 0x6d		/*m*/
    sw      t0, 0xb801b200
    li      t0, 0x61		/*a*/
    sw      t0, 0xb801b200
    li      t0, 0x67		/*g*/
    sw      t0, 0xb801b200
    li      t0, 0x65		/*e*/
    sw      t0, 0xb801b200

    jal     realtek_recovery_set_regs;
    nop

	/*s8 is not used by anyone, we just put rescue selction in s8 */
	li		s8, 0x1
    
    li      t0, 0x00000010;
    sw      t0, 0xb800880c
    
    /********************************************
     ** Check if SDRAM is ready
     ********************************************/
1:
    lw      t0, 0xb800880c
    and     t0, 0x00000010;
    bnez    t0, 1b 
    nop
    
    
    b       return;
    nop;

    /* update register then return to msc01_core.S */
2:

    li      t0, 0x55		/*U*/
    sw      t0, 0xb801b200
    li      t0, 0x70		/*p*/
    sw      t0, 0xb801b200
    li      t0, 0x64		/*d*/
    sw      t0, 0xb801b200
    li      t0, 0x61		/*a*/
    sw      t0, 0xb801b200
    li      t0, 0x74		/*t*/
    sw      t0, 0xb801b200
    li      t0, 0x65		/*e*/
    sw      t0, 0xb801b200
    li      t0, 0x20		/* */
    sw      t0, 0xb801b200
    li      t0, 0x52		/*R*/
    sw      t0, 0xb801b200
    li      t0, 0x65		/*e*/
    sw      t0, 0xb801b200
    li      t0, 0x67		/*g*/
    sw      t0, 0xb801b200
    li      t0, 0x73		/*s*/
    sw      t0, 0xb801b200

    jal     realtek_recovery_set_regs;
    nop
    
	/*s8 is not used by anyone, we just put rescue selction in s8 */
	li		s8, 0x2
	
    
    li      t0, 0x00000010;
    sw      t0, 0xb800880c
    
    /********************************************
     ** Check if SDRAM is ready
     ********************************************/
1:
    lw      t0, 0xb800880c
    and     t0, 0x00000010;
    bnez    t0, 1b 
    nop

    b       return;
    nop
    
    
3:
    sw      t7, 0xb8000000;
    sw      t8, 0xb8000004;
    
    /*s8 is not used by anyone, we just put rescue selction in s8 */
	li		s8, 0x0
    
    
    /* return to configure_sdram */ 
return:
    jr      RA;
    nop

#undef RA

END(realtek_recovery)



/************************************************************************
 *
 *                          realtek_recovery_set_regs
 *  Note :
 *  ------
 *
 *  Description :
 *  -------------
 *  This routine repeatedly received data from UART input buffer,
 *  separates contents, and sets to specific registers until receiving
 *  terminate tag
 *
 *  input :
 *  
 *  Return values :
 *  ---------------
 *
 ************************************************************************/

LEAF(realtek_recovery_set_regs)   
#define		RA		t7

    move    RA, ra
    
    li		t8, 0xff;
    /* idle state */
idle:
    lw      t0, 0xb801b214;
    and     t0, 0x1;
    
    /* check if data input */
    beqz    t0, idle;
    nop
    
    
    /* hunt state */
hunt:
    lw      t0, 0xb801b200;
    and     t0, 0xff;
    
//cylee test start
	sw		t0, 0xb801b200;
//cylee test end

    /* if start tag, jump to save state */
    beqz    t0, save;
    nop
    
    /* if eof tag, jump to terminate state */   
    beq     t0, t8, back_to_main;
    nop;

    /* error!! return to idle state */
    b       idle;
    nop
    
    
save:

    /* save state */
    move    t0, zero;   // t0 as address
    move    t1, zero;   // t1 as value
    move    t2, zero;   // t2 as address shift variable
    move    t3, zero;   // t3 as value shift variable
    li      t4, 24;
get_char:
    lw      t5, 0xb801b214;
    and     t5, 0x1;
    
    /* check if data input */
    beqz    t5, get_char;
    nop
    
    lw      t5, 0xb801b200;
    and     t5, 0xff;

//cylee test start
	sw		t5, 0xb801b200;
//cylee test end

check_reg:
    /* if t2(address shift varuable) > 24, then jump to shift value */
    bgt     t2, t4, check_value;
    nop
    
    sll     t0, 8;
    nop
    or      t0, t5;
    
    /* 'address' shift value += 8 */
    add     t2, 8;
    
    b       get_char;
    nop;
    
check_value:
    /* if t3(address shift varuable) > 24, then jump to check end tag */
    bgt     t3, t4, check_end_tag;
    nop
    
    sll     t1, 8;
    nop
    or      t1, t5;
    
    /* 'value' shift value += 8 */
    add     t3, 8;
    
    b       get_char;
    nop;

check_end_tag:
    /* if not 'end tag', just drop all value and return idle state */
    bnez    t5, jump_to_idle;
    nop
    
    /* save 'register' with 'value' */
    li		k1, 0x38;
    sw		k1, 0xb801b200
    sw      t1, 0(t0);
    li		k1, 0x39;
    sw		k1, 0xb801b200
    
    
jump_to_idle:
    b       idle;
    nop


back_to_main:
	li	t2, 0x45;
	sw		t2, 0xb801b200 /* show 'E' in console */

    jr  RA;
    nop

#undef RA

END(realtek_recovery_set_regs)
