
/************************************************************************
 *
 *  reset.S
 *
 *  Startup code for bootprom
 *
 * ######################################################################
 *
 * mips_start_of_legal_notice
 * 
 * Copyright (c) 2003 MIPS Technologies, Inc. All rights reserved.
 *
 *
 * Unpublished rights (if any) reserved under the copyright laws of the
 * United States of America and other countries.
 *
 * This code is proprietary to MIPS Technologies, Inc. ("MIPS
 * Technologies"). Any copying, reproducing, modifying or use of this code
 * (in whole or in part) that is not expressly permitted in writing by MIPS
 * Technologies or an authorized third party is strictly prohibited. At a
 * minimum, this code is protected under unfair competition and copyright
 * laws. Violations thereof may result in criminal penalties and fines.
 *
 * MIPS Technologies reserves the right to change this code to improve
 * function, design or otherwise. MIPS Technologies does not assume any
 * liability arising out of the application or use of this code, or of any
 * error or omission in such code. Any warranties, whether express,
 * statutory, implied or otherwise, including but not limited to the implied
 * warranties of merchantability or fitness for a particular purpose, are
 * excluded. Except as expressly provided in any written license agreement
 * from MIPS Technologies or an authorized third party, the furnishing of
 * this code does not give recipient any license to any intellectual
 * property rights, including any patent rights, that cover this code.
 *
 * This code shall not be exported or transferred for the purpose of
 * reexporting in violation of any U.S. or non-U.S. regulation, treaty,
 * Executive Order, law, statute, amendment or supplement thereto.
 *
 * This code constitutes one or more of the following: commercial computer
 * software, commercial computer software documentation or other commercial
 * items. If the user of this code, or any related documentation of any
 * kind, including related technical data or manuals, is an agency,
 * department, or other entity of the United States government
 * ("Government"), the use, duplication, reproduction, release,
 * modification, disclosure, or transfer of this code, or any related
 * documentation of any kind, is restricted in accordance with Federal
 * Acquisition Regulation 12.212 for civilian agencies and Defense Federal
 * Acquisition Regulation Supplement 227.7202 for military agencies. The use
 * of this code by the Government is further restricted in accordance with
 * the terms of the license agreement(s) and/or applicable contract terms
 * and conditions covering this code from MIPS Technologies or an authorized
 * third party.
 *
 * 
 * mips_end_of_legal_notice
 * 
 *
 ************************************************************************/

/************************************************************************
 *  Include files
 ************************************************************************/

#include <sysdefs.h>
#include <mips.h>
#include <product.h>
#include <malta.h>
#include <sys_api.h>
#include <cpu.h>
            
/************************************************************************
 *  Definitions
 ************************************************************************/

/************************************************************************
 *  Public variables
 ************************************************************************/

/************************************************************************
 *  Static variables
 ************************************************************************/

/************************************************************************
 *  Implementation : Public functions
 ************************************************************************/

/************************************************************************
 *
 *                          __reset_vector
 *  Description :
 *  -------------
 *
 *  Exception handler entry points for bootprom.
 *  including reset vector (0xbfc00000).
 *
 *  Return values :
 *  ---------------
 *
 *  For interrupts, function simply returns
 *  For exceptions, function never returns
 *
 *  In case of the reset exception (or NMI), function jumps to the
 *  entry point for code corresponding to the endianness of the CPU.
 *
 ************************************************************************/

LEAF(__reset_vector)

    .set noreorder
    
    /* Determine processor */
    MFC0( t0, C0_PRId)
    li      t1, M_PRIdImp | M_PRIdCoID
    and     t0, t1
    li      t1, PRID_IMP_4Kec | PRID_COMP_MIPS      /* t1 would be 0x019000*/
    beq     t1, t0, is_4Kec
    nop
    
    /* The cpu is not system cpu */
    /* Wait for DCU is ok */
    li      t1, 0x1000;
    
1:  
    addiu   t1, -1
    bne     t1, zero, 1b
    nop
    
    
    /*5280 will auto flush cache after reset */
    la      t0, av_entry
    jalr    t0
    nop
    
    
    
    
is_4Kec:    
    /**** linked cached (start address 0x9fc00000)
     **** Processor is running code uncached (i.e. 0xbfc00000)
     ****/
        
    /* set EJ_TDO to 4mA , for ICE help*/
    lw      t0, 0xb801a150 ;   
    or      t0, 0x4;
    sw      t0, 0xb801a150;
    
    
    /* Clear watch registers */
    MTC0(   zero, C0_WatchLo)
    MTC0(   zero, C0_WatchHi)
    
    
    /* Disable interrupts and KSU field (power up issue) */
    MFC0(   k0, C0_Status)
    li      k1, ~(M_StatusIE | M_StatusKSU)
    and     k0, k1
    MTC0(   k0, C0_Status)
    
1:
    li      k1, KSEG1BASE
    la      k0, _reset_handler_le   /* Defined in linker script */
    or      k0, k1                  /* Make sure it is uncached */
    jr      k0
    nop
/*cy test */     
error:

1:
    b       1b
            nop


.org 0x200
    /* 0xBFC00200 TLB refill, 32 bit task                    */
    /*********************************************************/
1:  b       1b  /* Stay here */
    nop
    

.org 0x280
    /* 0xBFC00280 XTLB refill, 64 bit task                   */
    /*********************************************************/
1:  b       1b  /* Stay here */
    nop
    

.org 0x300
    /* 0xBFC00300 Cache error exception                      */
    /*********************************************************/
1:  b       1b  /* Stay here */
    nop
    

.org 0x380
    /* 0xBFC00380 General exception                          */
    /*********************************************************/

  li       t1, 0x49;
  sw       t1, 0xb801b200;
1:      /* Stay here */  
  b        1b
    nop


.org 0x400
    /* 0xBFC00400 Catch interrupt exceptions, some QEDs only */
    /*********************************************************/
1:  b       1b  /* Stay here */
    nop
    

.org 0x480
       /* 0xBFC00480 EJTAG debug exception -- don't touch ANY GPR */
       /******************************************************************
    * This exception cannot be moved from here, so below code
    * transfers it to RAM entry 0x80000300. The RAM entry will look
    * similar, which may give this sequence of machine instructions:
    *   bfc0049c:  jr    v0
    *   bfc004a0:  mfc0  v0, C0_DESAVE
    *       (v0):  mtc0  xx, CO-DESAVE
    * Notes on hazard:
    * On CPUs without GPR interlocking, xx must be different from v0.
    * The mfc0 and mtc0 placed back to back should not be a problem,
    * as the read in CP0 takes place at an earlier stage than write,
    * and DESAVE is a scratchpad register with no operational effects.
    * Below: Two instructions between mtc0 and mfc0 is sufficient.
    */
       mtc0     v0, C0_DESAVE
       li       v0, KSEG0(SYS_EJTAG_RAM_VECTOR_OFS)
       jr   v0
       mfc0     v0, C0_DESAVE


.org 0x500
       /* 0xBFC00500 Vector table for shell functions */


END(__reset_vector)



/************************************************************************
 *  Implementation : Static functions
 ************************************************************************/

