/************************************************************************
 *  Include Header File
 ************************************************************************/

#include <sysdefs.h>
#include <sys_api.h>
#include <excep_api.h>

#include <gpio_api.h>
#include <project_config.h>

/************************************************************************
 *  Global variables
 ************************************************************************/

#ifdef PVRBOX_From_PC
extern   char DeadBeef_Flg;
#endif	

#ifdef Config_QC_Test_Prog_TRUE
extern UINT32 QC_test_enabled;
#endif /* Config_QC_Test_Prog_TRUE */

/************************************************************************
 *  Global variables
 ************************************************************************/
 
static void      
gpio_int_handler(void);

/************************************************************************
 *
 *                          GPIO_init
 *  Description :
 *  -------------
 *  Initialize the GPIO;
 *
 *
 *  Parameters :
 *  ------------
 *  -
 *
 *
 *  Return values :
 *  ---------------
 *  'OK'(=0) 
 *
 ************************************************************************/
UINT32 GPIO_init( void )
{

    /* most GPIO configuration are in msc01_core.S */
    
#ifdef Config_QC_Test_Prog_TRUE
    /* We do not enable mini USB GPIO detection for QC Test. */
    if(QC_test_enabled) {
        return 0;
    }
#endif /* Config_QC_Test_Prog_TRUE */

    /* register IM3 interrupt of CPU */
    EXCEP_register_cpu_isr( 3, (t_EXCEP_isr)gpio_int_handler, NULL, NULL );
    
    //enable GPIO40 interrupt
    REG32(KSEG1(MIS_GP1IE)) = 0x00000100;
    
    //enable GPIO[47:38] debounce in 10us
    REG32(KSEG1(MIS_GPDEB)) = 0xa0000;
    
    return 0;
}


static void gpio_int_handler(void)
{   
	//if gpio interrupt flag assert, Check GPIO40
    if ((REG32(KSEG1(MIS_ISR_REG))&0x80000))
    {
    	/* check GPIO40 assert flag */
	    if ((REG32(KSEG1(0x1801b038)) & 0x400))
    	{
        	printf("Detecting Device connect to PC!!!\n");
        	printf("Release HD control from Device to PC!!!\n");

        	//	1. set primary ATA as input
        	REG32 (KSEG1( ATA_PRIMARY_DIR)) = 0x2a;
        	//  2. set GPIO34 direction as input, and show notificatino message
        	REG32 (KSEG1( MIS_GP1DATO)) = REG32 (KSEG1( MIS_GP1DATO)) | 0x00000004;

    		//close interrupt flag
    		REG32(KSEG1(0x1801b038)) = 0x400;
    	}

       	//clear gpio interrupt flag assert
       	REG32(KSEG1(MIS_ISR_REG)) = 0x80000;    	
    }

	//if gpio dis-interrupt flag assert, Check GPIO40
    if ((REG32(KSEG1(MIS_ISR_REG))&0x100000))
    {
    	
       	//clear gpio interrupt flag assert
    	REG32(KSEG1(MIS_ISR_REG)) = 0x100000;
    	
    	/* check GPIO40 dis-assert flag */
	    if ((REG32(KSEG1(0x1801b03c)) & 0x400))
    	{
        	printf("Detecting Device remove to PC!!!\n");
        	printf("Perform Software Reset!!!\n");
    		
			//  1. restore GPIO34 direction to output
        	REG32 (KSEG1( MIS_GP1DATO)) = REG32 (KSEG1( MIS_GP1DATO)) & (~0x00000004);
        	//	2. restore primary ATA as output
        	REG32 (KSEG1( ATA_PRIMARY_DIR)) = REG32 (KSEG1( ATA_PRIMARY_DIR)) & 0xf;
    		
    		//  3. close interrupt flag
    		REG32(KSEG1(0x1801b038)) = 0x400;
        	
        	//  4. perform reset
	
	        printf("Software-reset device\n");
    	    REG32(0xb8000004) = Config_Reset_Assert;
        	REG32(0xb8000000) = Config_Enable_Assert;

	        REG32(0xb8000000) = Config_Reset_Deassert;
    	    REG32(0xb8000004) = Config_Enable_Deassert;
	
            //Reset timer.
            REG32(0xb801b530) = 0x0;
	
    	    asm("li $8, 0xbfc00000");
        	asm("j  $8");

	        while (1) ;
	    }
	    
    }
    
    return;
}
