/************************************************************************
 *  Include Header File
 ************************************************************************/

#include <sysdefs.h>
#include <sys_api.h>
#include <excep_api.h>

#include <gpio_api.h>
#include <project_config.h>

/************************************************************************
 *  Global variables
 ************************************************************************/

#ifdef PVRBOX_From_PC
extern   char DeadBeef_Flg;
#endif	

#ifdef Config_QC_Test_Prog_TRUE
extern UINT32 QC_test_enabled;
#endif /* Config_QC_Test_Prog_TRUE */

/************************************************************************
 *  Global variables
 ************************************************************************/
 
static void      
gpio_int_handler(void);

/************************************************************************
 *
 *                          GPIO_init
 *  Description :
 *  -------------
 *  Initialize the GPIO;
 *
 *
 *  Parameters :
 *  ------------
 *  -
 *
 *
 *  Return values :
 *  ---------------
 *  'OK'(=0) 
 *
 ************************************************************************/
UINT32 GPIO_init( void )
{
    /* most GPIO configuration are in msc01_core.S */
    
#ifdef Config_QC_Test_Prog_TRUE
    /* We do not enable mini USB GPIO detection for QC Test. */
    if(QC_test_enabled) {
        return;
    }
#endif /* Config_QC_Test_Prog_TRUE */

    /* register IM3 interrupt of CPU */
    EXCEP_register_cpu_isr( 3, (t_EXCEP_isr)gpio_int_handler, NULL, NULL );
    
    /* enable interrupt */
    //REG32(KSEG1(MIS_GP0IE)) = 0x10000000;
    #ifdef Config_USB_DET_GPIO
    REG32(KSEG1(MIS_GP0IE)) = (0x1 << Config_USB_DET_GPIO);
    #endif
    
    return;
}

static void gpio_int_handler(void)
{
#ifdef PVRBOX_From_PC
    if (DeadBeef_Flg == 0)
       return ;
#endif	

    //if gpio interrupt flag not assert, return
    if (!(REG32(KSEG1(MIS_ISR_REG))&0x80000))
       return;
   
    /* check USB DET GPIO */
    #ifdef Config_USB_DET_GPIO
    if (!(REG32(KSEG1(MIS_UMSK_ISR_GP0A))&(0x1 << (Config_USB_DET_GPIO + 1))))
       return;
    #endif

#if GPIO_DEBUG       
    printf("I will go to die !!\n");//cy test 
#endif
    
    printf("USB GPIO detected!\n");

    sys_wait_ms(20);
    
    #ifdef Config_USB_DET_GPIO
    REG32(KSEG1(MIS_UMSK_ISR_GP0A)) = (0x1 << (Config_USB_DET_GPIO + 1));
    #endif
    
    REG32(KSEG1(MIS_ISR_REG)) = 0x80000;
    
    /* suicide */
//    REG32(KSEG1(MIS_GP1DATO)) = 0x00;
    
    REG32(KSEG1(MIS_GP1DIR))  = 0x08;
    
    return;
}
