/*****************************************************************************
**
**  Name: MT_ErrorDef.h
**
**  Description:    Definition of bits in status/error word used by various
**                  MicroTuner control programs.
**
**  References:     None
**
**  Exports:        None
**
**  CVS ID:         $Id: mt_errordef.h,v 1.2 2005/02/09 23:32:57 software Exp $
**  CVS Source:     $Source: /export/home/cvsroot/web05/html/software/tuners/MT2060/mt_errordef.h,v $
**	               
**  Revision History:
**
**   SCR      Date      Author  Description
**  -------------------------------------------------------------------------
**   N/A   09-09-2004    JWS    Original
**   088   01-26-2005    DAD    Added MT_TUNER_INIT_ERR.
**
*****************************************************************************/

/*
** Note to users:  DO NOT EDIT THIS FILE  
**
** If you wish to rename any of the "user defined" bits,
** it should be done in the user file that includes this
** source file (e.g. MT_Userdef.h)
**
*/



/*
**  3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 
**  1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
**  M U <- Info Codes --> <# Spurs> < User> <----- Err Codes ----->
**
**  31 = MT_ERROR - Master Error Flag.  If set, check Err Codes for reason.
**  30 = MT_USER_ERROR - User-declared error flag.
**  29 = Unused
**  28 = Unused
**  27 = MT_DNC_RANGE
**  26 = MT_UPC_RANGE
**  25 = MT_FOUT_RANGE
**  24 = MT_FIN_OUT_OF_RANGE
**  23 = MT_SPUR_PRESENT - Unavoidable spur in output
**  22 = Unused
**  21 = Unused
**  20 = Unused
**  19 = MT_SPUR_CNT_MASK (MSB) - Count of avoided spurs
**  18 = MT_SPUR_CNT_MASK
**  17 = MT_SPUR_CNT_MASK
**  16 = MT_SPUR_CNT_MASK
**  15 = MT_SPUR_CNT_MASK (LSB)
**  14 = MT_USER_DEFINED4 - User-definable bit (see MT_Userdef.h)
**  13 = MT_USER_DEFINED3 - User-definable bit (see MT_Userdef.h)
**  12 = MT_USER_DEFINED2 - User-definable bit (see MT_Userdef.h)
**  11 = MT_USER_DEFINED1 - User-definable bit (see MT_Userdef.h)
**  10 = Unused
**   9 = MT_TUNER_INIT_ERR - Tuner initialization error
**   8 = MT_TUNER_ID_ERR - Tuner Part Code / Rev Code mismatches expected value
**   7 = MT_TUNER_CNT_ERR - Attempt to open more than MT_TUNER_CNT tuners
**   6 = MT_ARG_NULL - Null pointer passed as argument
**   5 = MT_ARG_RANGE - Argument value out of range
**   4 = MT_INV_HANDLE - Tuner handle is invalid
**   3 = MT_COMM_ERR - Serial bus communications error
**   2 = MT_DNC_UNLOCK - Downconverter PLL is unlocked
**   1 = MT_UPC_UNLOCK - Upconverter PLL is unlocked
**   0 = MT_UNKNOWN - Unknown error
*/
#define MT_ERROR (1 << 31)
#define MT_USER_ERROR (1 << 30)

/*  Macro to be used to check for errors  */
#define MT_IS_ERROR(s) (((s) >> 30) != 0)
#define MT_NO_ERROR(s) (((s) >> 30) == 0)


#define MT_OK                           (0x00000000)

/*  Unknown error  */
#define MT_UNKNOWN                      (0x80000001)

/*  Error:  Upconverter PLL is not locked  */
#define MT_UPC_UNLOCK                   (0x80000002)

/*  Error:  Downconverter PLL is not locked  */
#define MT_DNC_UNLOCK                   (0x80000004)

/*  Error:  Two-wire serial bus communications error  */
#define MT_COMM_ERR                     (0x80000008)

/*  Error:  Tuner handle passed to function was invalid  */
#define MT_INV_HANDLE                   (0x80000010)

/*  Error:  Function argument is invalid (out of range)  */
#define MT_ARG_RANGE                    (0x80000020)

/*  Error:  Function argument (ptr to return value) was NULL  */
#define MT_ARG_NULL                     (0x80000040)

/*  Error: Attempt to open more than MT_TUNER_CNT tuners  */
#define MT_TUNER_CNT_ERR                (0x80000080)

/*  Error: Tuner Part Code / Rev Code mismatches expected value  */
#define MT_TUNER_ID_ERR                 (0x80000100)

/*  Error: Tuner Initialization failure  */
#define MT_TUNER_INIT_ERR               (0x80000200)

/*  User-definable fields (see MT_Userdef.h)  */
#define MT_USER_DEFINED1                (0x00001000)
#define MT_USER_DEFINED2                (0x00002000)
#define MT_USER_DEFINED3                (0x00004000)
#define MT_USER_DEFINED4                (0x00008000)
#define MT_USER_MASK                    (0x4000f000)
#define MT_USER_SHIFT                   (12)

/*  Info: Mask of bits used for # of LO-related spurs that were avoided during tuning  */
#define MT_SPUR_CNT_MASK                (0x001f0000)
#define MT_SPUR_SHIFT                   (16)

/*  Info: Unavoidable LO-related spur may be present in the output  */
#define MT_SPUR_PRESENT                 (0x00800000)

/*  Info: Tuner input frequency is out of range */
#define MT_FIN_RANGE                    (0x01000000)

/*  Info: Tuner output frequency is out of range */
#define MT_FOUT_RANGE                   (0x02000000)

/*  Info: Upconverter frequency is out of range (may be reason for MT_UPC_UNLOCK) */
#define MT_UPC_RANGE                    (0x04000000)

/*  Info: Downconverter frequency is out of range (may be reason for MT_DPC_UNLOCK) */
#define MT_DNC_RANGE                    (0x08000000)

