#ifndef __DEMOD_RTD2820_DATA_H__
#define __DEMOD_RTD2820_DATA_H__


enum  rtd2820_reg_map_index {    
    /*-------------- GENERAL REGISTERS -------------*/
    RTD2820_PAGE_CTRL = 0,
    RTD2820_OPT_ATSC_ON,            
    RTD2820_SYSTEM_VERSION,
    RTD2820_OPT_I2C_RELAY,
    RTD2820_OPT_SOFT_RESET_ATSC,
    
    /*-------------- MISC -------------*/    
    RTD2820_RO_STROBE,
    
    /*-------------- AAGC -------------*/    
    RTD2820_OPT_RF_AGC_DRIVING,
    RTD2820_OPT_IF_AGC_DRIVING,
    RTD2820_OPT_RF_AAGC_OE,
    RTD2820_OPT_IF_AAGC_OE,
    RTD2820_OPT_PAR_RF_SD_IB,
    RTD2820_OPT_PAR_IF_SD_IB,
    RTD2820_AAGC_TARGET,
    RTD2820_RF_AGC_MIN,
    RTD2820_RF_AGC_MAX,
    RTD2820_IF_AGC_MIN,
    RTD2820_IF_AGC_MAX,
    RTD2820_VTOP,
    RTD2820_KRF,
    RTD2820_AFC_MODE,    
    RTD2820_AAGC_LOCK,
    
    /*-------------- AD7 -------------*/    
    RTD2820_AD7_RO,
    RTD2820_OPT_AD7_CLK_RATIO,
    RTD2820_OPT_AD7_CLK_SEL,
    RTD2820_OPT_AD7_RO_STROBE,
    
    /*-------------- DDC -------------*/    
    RTD2820_DDC_PHASE_INC,
    RTD2820_SPEC_INV_ON,
    
    /*-------------- CARRIER RECOVERY -------------*/    
    RTD2820_RO_CR_LOCK_IND,
    RTD2820_RO_CARRIER_OFFSET_D_Q,
    RTD2820_RO_IF_OFFSET,
    
    /*-------------- TIMING RECOVERY -------------*/    
    RTD2820_RO_TIMING_OFFSET_D_Q,
    
    /*-------------- EQUALIZER -------------*/    
    RTD2820_INNER_LOCK_IND,
    RTD2820_RO_MSE_FIELD,
    
    /*-------------- OUTER -------------*/    
    RTD2820_OUTER_LOCK_IND,    
    RTD2820_BER_RST,
    RTD2820_BER_HOLD,
    RTD2820_DIS_AUTO_MODE,
    RTD2820_TEST_VOLUME,
    RTD2820_AO_BER,
    RTD2820_AO_PKT_CNT,
    RTD2820_AO_CORR_CNT,
    RTD2820_AO_UN_CORR_CNT,
    
    /*-------------- MPEG TRANSPROT STREAM OUTPUT INTERFACE -------------*/    
    RTD2820_OPT_M_OEN,
    RTD2820_FIX_TEI,
    RTD2820_CKOUTPAR,
    RTD2820_CKOUT_PWR,
    RTD2820_SERIAL,
    RTD2820_CDIV_PH0,
    RTD2820_CDIV_PH1,
    
    /*-------------- ANTENNA CONTROL -------------*/    
    RTD2820_OPT_ANT_IO_MODE,
    RTD2820_OPT_ANT_PAD_OE,
    RTD2820_OPT_ANT_PAD_DRIVING,
    RTD2820_OPT_ANT_SLEW,
    RTD2820_OPT_ANT_RESET_N,
    RTD2820_OPT_ANT_ENABLE,
    RTD2820_REG_COUNT,
};              



rtd2820_reg_t rtd2820_reg[RTD2820_REG_COUNT]= 
{
    /* Register Name                */      /* PAGE*/   /* ADDR*/ /* LSB*/ /* MSB*/
    /*------------------------------------------------------------------------------------*/
    
    /*-------------- GENERAL REGISTERS -------------*/
    /* RTD2820_PAGE_CTRL            */      { RTD2820_PAGE_NONE , 0x00, 0, 7 },
    /* RTD2820_OPT_ATSC_ON          */      { RTD2820_PAGE_0 , 0x04, 1, 1 },            
    /* RTD2820_SYSTEM_VERSION       */      { RTD2820_PAGE_0 , 0x01, 0, 7 },
    /* RTD2820_OPT_I2C_RELAY        */      { RTD2820_PAGE_0 , 0x06, 7, 7 },            
    /* RTD2820_OPT_SOFT_RESET_ATSC  */      { RTD2820_PAGE_0 , 0x05, 1, 1 },
    
    /*-------------- MISC -------------*/
    
    /* RTD2820_RO_STROBE            */      { RTD2820_PAGE_2F, 0x01, 0, 0 },
    
    /*-------------- AAGC -------------*/
    
    /* RTD2820_OPT_RF_AGC_DRIVING   */      { RTD2820_PAGE_2,  0x16, 3, 3 },
    /* RTD2820_OPT_IF_AGC_DRIVING   */      { RTD2820_PAGE_2,  0x16, 2, 2 },
    /* RTD2820_OPT_RF_AAGC_OE       */      { RTD2820_PAGE_1,  0x08, 3, 3 },
    /* RTD2820_OPT_IF_AAGC_OE       */      { RTD2820_PAGE_1,  0x08, 7, 7 },
    /* RTD2820_OPT_PAR_RF_SD_IB     */      { RTD2820_PAGE_1,  0x08, 2, 2 },
    /* RTD2820_OPT_PAR_IF_SD_IB     */      { RTD2820_PAGE_1,  0x08, 6, 6 },
    /* RTD2820_AAGC_TARGET          */      { RTD2820_PAGE_21, 0x03, 0, 7 },
    /* RTD2820_RF_AGC_MIN           */      { RTD2820_PAGE_21, 0x0C, 0, 7 },
    /* RTD2820_RF_AGC_MAX           */      { RTD2820_PAGE_21, 0x0D, 0, 7 },
    /* RTD2820_IF_AGC_MIN           */      { RTD2820_PAGE_21, 0x0A, 0, 7 },
    /* RTD2820_IF_AGC_MAX           */      { RTD2820_PAGE_21, 0x0B, 0, 7 },
    /* RTD2820_VTOP                 */      { RTD2820_PAGE_21, 0x08, 0, 6 },
    /* RTD2820_KRF                  */      { RTD2820_PAGE_21, 0x09, 0, 5 },
    /* RTD2820_AFC_MODE             */      { RTD2820_PAGE_21, 0x04, 5, 5 },    
    /* RTD2820_AAGC_LOCK            */      { RTD2820_PAGE_2F, 0x0A, 7, 7 },
    
    /*-------------- AD7 -------------*/
    
    /* RTD2820_AD7_RO               */      { RTD2820_PAGE_0,  20  , 0, 6 },  //*******
    /* RTD2820_OPT_AD7_CLK_RATIO    */      { RTD2820_PAGE_0,  13  , 0, 7 },
    /* RTD2820_OPT_AD7_CLK_SEL      */      { RTD2820_PAGE_0,  14  , 0, 0 },
    /* RTD2820_OPT_AD7_RO_STROBE    */      { RTD2820_PAGE_0,  14  , 1, 1 },
    
    /*-------------- DDC -------------*/
    
    /* RTD2820_DDC_PHASE_INC        */      { RTD2820_PAGE_21, 0x11, 0, 18},
    /* RTD2820_SPEC_INV_ON          */      { RTD2820_PAGE_21, 0x11, 3, 3 },
    
    /*-------------- CARRIER RECOVERY -------------*/
    
    /* RTD2820_RO_CR_LOCK_IND       */      { RTD2820_PAGE_2F, 0x0A, 4, 4 },
    /* RTD2820_RO_CARRIER_OFFSET_D_Q*/      { RTD2820_PAGE_2F, 0x10, 0, 15},
    /* RTD2820_RO_IF_OFFSET         */      { RTD2820_PAGE_2F, 0x36, 0, 8 },
    
    /*-------------- TIMING RECOVERY -------------*/
    
    /* RTD2820_RO_TIMING_OFFSET_D_Q*/      { RTD2820_PAGE_2F,  0x12, 0, 15},
    
    /*-------------- EQUALIZER -------------*/
    
    /* RTD2820_INNER_LOCK_IND       */      { RTD2820_PAGE_2F, 0x5D, 4, 4 },
    /* RTD2820_RO_MSE_FIELD         */      { RTD2820_PAGE_2F, 0x2C, 0, 31},
    
    /*-------------- OUTER -------------*/
    
    /* RTD2820_OUTER_LOCK_IND       */      { RTD2820_PAGE_2F, 0x5D, 2, 2 },    
    /* RTD2820_BER_RST              */      { RTD2820_PAGE_29, 0x03, 0, 0 },
    /* RTD2820_BER_HOLD             */      { RTD2820_PAGE_29, 0x03, 1, 1 },
    /* RTD2820_DIS_AUTO_MODE        */      { RTD2820_PAGE_29, 0x03, 2, 2 },
    /* RTD2820_TEST_VOLUME          */      { RTD2820_PAGE_29, 0x03, 3, 5 },
    /* RTD2820_AO_BER               */      { RTD2820_PAGE_29, 0x04, 0, 23},
    /* RTD2820_AO_PKT_CNT           */      { RTD2820_PAGE_29, 0x07, 0, 23},
    /* RTD2820_AO_CORR_CNT          */      { RTD2820_PAGE_29, 0x0A, 0, 15},
    /* RTD2820_AO_UN_CORR_CNT       */      { RTD2820_PAGE_29, 0x0C, 0, 15},
    
    /*-------------- MPEG TRANSPROT STREAM OUTPUT INTERFACE -------------*/    

    /* RTD2820_OPT_M_OEN            */      { RTD2820_PAGE_0 , 0x06, 6, 6},
    /* RTD2820_FIX_TEI              */      { RTD2820_PAGE_29, 0x30, 0, 0},
    /* RTD2820_CKOUTPAR             */      { RTD2820_PAGE_29, 0x30, 1, 1},
    /* RTD2820_CKOUT_PWR            */      { RTD2820_PAGE_29, 0x30, 2, 2},
    /* RTD2820_SERIAL               */      { RTD2820_PAGE_29, 0x30, 7, 7},
    /* RTD2820_CDIV_PH0             */      { RTD2820_PAGE_29, 0x32, 0, 3},
    /* RTD2820_CDIV_PH1             */      { RTD2820_PAGE_29, 0x32, 4, 7},
    
    /*-------------- ANTENNA CONTROL -------------*/
    
    /* RTD2820_OPT_ANT_IO_MODE      */      { RTD2820_PAGE_0 , 0x15, 0, 2},
    /* RTD2820_OPT_ANT_PAD_OE       */      { RTD2820_PAGE_0 , 0x15, 3, 3},
    /* RTD2820_OPT_ANT_PAD_DRIVING  */      { RTD2820_PAGE_0 , 0x15, 4, 4},
    /* RTD2820_OPT_ANT_SLEW         */      { RTD2820_PAGE_0 , 0x15, 5, 5},
    /* RTD2820_OPT_ANT_RESET_N      */      { RTD2820_PAGE_22, 0x04, 0, 0},
    /* RTD2820_OPT_ANT_ENABLE       */      { RTD2820_PAGE_22, 0x04, 1, 1},        
};                                          

static int rtd2820_reg_mask[32]= 
{
    0x00000001,
    0x00000003,
    0x00000007,
    0x0000000f,
    0x0000001f,
    0x0000003f,
    0x0000007f,
    0x000000ff,
    0x000001ff,
    0x000003ff,
    0x000007ff,
    0x00000fff,
    0x00001fff,
    0x00003fff,
    0x00007fff,
    0x0000ffff,
    0x0001ffff,
    0x0003ffff,
    0x0007ffff,
    0x000fffff,
    0x001fffff,
    0x003fffff,
    0x007fffff,
    0x00ffffff,
    0x01ffffff,
    0x03ffffff,
    0x07ffffff,
    0x0fffffff,
    0x1fffffff,
    0x3fffffff,
    0x7fffffff,
    0xffffffff
};



//this file is for RTD2820 initial setting
//there are too many data array, so we create a new file for those.
//this is integrated with V12


unsigned char addr_array_1[] ={
	0x1c, 0x1d, 0x1e, 0x1f, 0x20, 0x21, 0x22, 0x23, 
	0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 
	0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x32, 0x33, 
	0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b}; 
unsigned char data_array_1[] ={
	0x04, 0x12, 0x18, 0x12, 0x02, 0xee, 0xe0, 0xe0, 
	0xf1, 0x0d, 0x26, 0x30, 0x23, 0x01, 0xd8, 0xbd, 
	0xc0, 0xe4, 0x1e, 0x55, 0x6b, 0x4e, 0x00, 0x9c, 
	0x4f, 0x49, 0xa9, 0x6f, 0x76, 0x7f, 0x43, 0x8c}; 
unsigned char addr_array_2[] ={
	0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 
	0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef, 
	0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 
	0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff}; 
unsigned char data_array_2[] ={
	0x18, 0x20, 0x10, 0xf8, 0xe8, 0xe7, 0xef, 0x07, 
	0x1f, 0x20, 0x18, 0x00, 0xe8, 0xe0, 0xef, 0x07, 
	0x27, 0x2f, 0x20, 0x00, 0xd8, 0xc0, 0xd0, 0xff, 
	0x37, 0x5f, 0x57, 0x18, 0xd1, 0x8a, 0x83, 0xbb}; 

unsigned char addr_array_3[]={
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 
	0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 
	0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a};
unsigned char data_array_3_0[]={
	0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xe7, 0x1c, 0x05, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0xf9, 0x1a, 0x40, 
	0x81, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00};
unsigned char data_array_3_1[]={
	0x31, 0x41, 0x10, 0x04, 0x41, 0x10, 0x0c, 0xe7, 0x1c, 0x05, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0xf9, 0x1a, 0x40, 
	0x8a, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00};
unsigned char data_array_3_2[]={
	0x32, 0x82, 0x20, 0x08, 0x45, 0x51, 0x14, 0x4a, 0x29, 0x05, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x3f, 0xf9, 0x1a, 0xc7, 
	0x81, 0x51, 0x02, 0x00, 0x00, 0x00, 0x00};
unsigned char data_array_3_3[]={
	0x33, 0xc3, 0x30, 0x0c, 0xc3, 0x30, 0x10, 0xe7, 0x1c, 0x90, 
	0xd0, 0x03, 0x00, 0x00, 0x00, 0xd0, 0x17, 0xfd, 0x1a, 0xc7, 
	0x83, 0x51, 0x02, 0x00, 0x00, 0x00, 0x00};
unsigned char data_array_3_4[]={
	0x34, 0x04, 0x41, 0x10, 0x04, 0x41, 0x14, 0xe7, 0x1c, 0x40, 
	0x0d, 0x03, 0x00, 0x00, 0x00, 0xf0, 0x1f, 0xfd, 0x1a, 0xc7, 
	0x81, 0x51, 0x02, 0x00, 0x00, 0x00, 0x00};
unsigned char data_array_3_5[]={
	0x35, 0x45, 0x51, 0x14, 0x45, 0x51, 0x18, 0xe7, 0x1c, 0x90, 
	0xd0, 0x03, 0x00, 0x00, 0x00, 0xf0, 0x3f, 0x7f, 0x9a, 0xc7, 
	0x81, 0x51, 0x02, 0x00, 0x00, 0x00, 0x00};
unsigned char data_array_3_6[]={
	0x36, 0x86, 0x61, 0x18, 0x86, 0x61, 0x1c, 0xe7, 0x1c, 0x50, 
	0xc3, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x3f, 0x7e, 0xd6, 0xcf, 
	0x81, 0x51, 0x02, 0x00, 0x00, 0x00, 0x00};
unsigned char data_array_3_7[]={
	0x37, 0xc7, 0x71, 0x1c, 0xc7, 0x71, 0x38, 0xe7, 0x1c, 0x50, 
	0xc3, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x3f, 0x3e, 0xd2, 0xcf, 
	0x81, 0x51, 0x02, 0x00, 0x00, 0x00, 0x00};
unsigned char data_array_3_8[]={
	0x38, 0x08, 0x82, 0x20, 0x08, 0x32, 0x52, 0xec, 0x1c, 0x20, 
	0xa1, 0x07, 0x00, 0x00, 0x00, 0xf0, 0x7f, 0x3e, 0xc9, 0xcc, 
	0xf1, 0x70, 0x02, 0x00, 0x00, 0x00, 0x00};
unsigned char data_array_3_9[]={
	0x39, 0x49, 0x92, 0x24, 0x49, 0x92, 0x90, 0xe7, 0x1c, 0x20, 
	0xa1, 0x07, 0x00, 0x00, 0x00, 0xf0, 0x9f, 0x3e, 0xc9, 0xcb, 
	0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00};
unsigned char data_array_3_10[]={
	0x3a, 0x8a, 0xa2, 0x28, 0x8a, 0xa2, 0x2c, 0xe7, 0x1c, 0x20, 
	0xa1, 0x07, 0x00, 0x00, 0x00, 0xf0, 0x7f, 0x3e, 0xc9, 0xcc, 
	0xf1, 0x70, 0x02, 0x00, 0x00, 0x00, 0x00};
unsigned char data_array_3_11[]={
	0x3b, 0xcb, 0xb2, 0x2c, 0xcb, 0xb2, 0x30, 0xe7, 0x1c, 0x20, 
	0xa1, 0x07, 0x00, 0x00, 0x00, 0xf0, 0x7f, 0x3e, 0xc9, 0xcc, 
	0xf1, 0x70, 0x02, 0x00, 0x00, 0x00, 0x00};
unsigned char data_array_3_12[]={
	0x3c, 0x0c, 0xc3, 0x30, 0x0c, 0x23, 0x51, 0xec, 0x1c, 0x20, 
	0xa1, 0x07, 0x00, 0x00, 0x00, 0xf0, 0x7f, 0x3e, 0xc9, 0xcc, 
	0xf1, 0x70, 0x02, 0x00, 0x00, 0x00, 0x00};
unsigned char data_array_3_13[]={
	0x3d, 0x4d, 0xd3, 0x34, 0x4d, 0xd3, 0x20, 0xe7, 0x1c, 0x20, 
	0xa1, 0x07, 0x00, 0x00, 0x00, 0xf0, 0x7f, 0x3e, 0xc9, 0xcc, 
	0xf1, 0x70, 0x02, 0x00, 0x00, 0x00, 0x00};
unsigned char data_array_3_14[]={
	0x3e, 0x8e, 0xe3, 0x38, 0x8e, 0xe3, 0x3c, 0xe7, 0x1c, 0x05, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x5f, 0x3e, 0xc9, 0xcb, 
	0xc1, 0x30, 0x02, 0x00, 0x00, 0x00, 0x00};
unsigned char data_array_3_15[]={
	0x3f, 0x8f, 0x00, 0x41, 0x8f, 0xa0, 0x28, 0x47, 0x0e, 0xe0, 
	0x93, 0x04, 0x00, 0x00, 0x00, 0xf0, 0x5f, 0x3e, 0xc9, 0xcb, 
	0xe1, 0x70, 0x03, 0x00, 0x00, 0x00, 0x00};
unsigned char data_array_3_16[]={
	0x40, 0x10, 0x04, 0x41, 0x82, 0x20, 0x08, 0x63, 0x0c, 0x50, 
	0xc3, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x5f, 0x3e, 0xc9, 0xcb, 
	0xe1, 0x70, 0x02, 0x00, 0x00, 0x00, 0x00};
unsigned char data_array_3_17[]={
	0x41, 0x51, 0x14, 0x45, 0x51, 0x14, 0x35, 0xe7, 0x1c, 0x05, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x7f, 0x3e, 0xc9, 0xcc, 
	0xc1, 0x70, 0x02, 0x00, 0x00, 0x00, 0x00};
unsigned char data_array_3_18[]={
	0x42, 0x92, 0x24, 0x49, 0x92, 0x24, 0x4d, 0xe7, 0x1c, 0x05, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x7f, 0x3e, 0xc9, 0xcc, 
	0xc1, 0x70, 0x02, 0x00, 0x00, 0x00, 0x00};
unsigned char data_array_3_19[]={
	0x43, 0xd3, 0x34, 0x4d, 0xd3, 0x14, 0x51, 0xec, 0x1c, 0x20, 
	0xa1, 0x07, 0x00, 0x00, 0x00, 0xf0, 0x7f, 0x3e, 0xc9, 0xcc, 
	0xf1, 0x70, 0x02, 0x00, 0x00, 0x00, 0x00};
unsigned char data_array_3_20[]={
	0x44, 0x14, 0x45, 0x51, 0x14, 0x45, 0x55, 0xe7, 0x1c, 0xfc, 
	0x02, 0x00, 0x00, 0x00, 0x01, 0xf0, 0x9f, 0x3e, 0xc9, 0xcb, 
	0x71, 0xec, 0x04, 0x00, 0xf0, 0x00, 0x00};
unsigned char data_array_3_21[]={
	0x45, 0x55, 0x55, 0x55, 0x55, 0x55, 0x59, 0xe7, 0x9c, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x01, 0xf0, 0x9f, 0x3e, 0xc9, 0xcb, 
	0x71, 0xec, 0x04, 0x00, 0xf0, 0x00, 0x00};
unsigned char data_array_3_22[]={
	0x46, 0x96, 0x63, 0x59, 0x96, 0x75, 0x5d, 0xa7, 0x14, 0xe0, 
	0x93, 0x0c, 0x40, 0x00, 0x01, 0xf0, 0x9f, 0x3e, 0xc9, 0xcb, 
	0x71, 0xac, 0x04, 0x00, 0xf0, 0x00, 0x00};
unsigned char data_array_3_23[]={
	0x47, 0xd7, 0x75, 0x5d, 0xd7, 0x75, 0x61, 0xe7, 0x1c, 0xa0, 
	0x01, 0xe8, 0x55, 0x00, 0x01, 0xf0, 0x9f, 0x3e, 0xc9, 0xca, 
	0x71, 0x2c, 0x05, 0x00, 0xf0, 0x00, 0x00};
unsigned char data_array_3_24[]={
	0x48, 0x58, 0xd6, 0x75, 0x5d, 0xd7, 0x75, 0x07, 0xa1, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x9f, 0x3e, 0xc9, 0xca, 
	0x71, 0x6c, 0x06, 0x41, 0xf0, 0x50, 0x00};
unsigned char data_array_3_25[]={
	0x49, 0x99, 0xd6, 0x75, 0x5d, 0xd7, 0x75, 0x07, 0x21, 0x60, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x9f, 0x3e, 0xc9, 0xca, 
	0x71, 0x6c, 0x02, 0xc4, 0xf0, 0x50, 0x00};
unsigned char data_array_3_26[]={
	0x4a, 0xda, 0xd6, 0x75, 0x5d, 0xd7, 0x75, 0x07, 0x21, 0xf0, 
	0x00, 0x00, 0x00, 0x00, 0x01, 0xf0, 0xbf, 0x3e, 0xc9, 0xca, 
	0x71, 0x6c, 0x02, 0x04, 0xf1, 0x20, 0x00};
unsigned char data_array_3_27[]={
	0x4b, 0xdb, 0x86, 0x71, 0x5d, 0xd7, 0x75, 0xef, 0x20, 0x70, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xbf, 0x3e, 0xc9, 0xca, 
	0x71, 0x6c, 0x02, 0xa2, 0xf8, 0xa0, 0x00};
unsigned char data_array_3_28[]={
	0x4c, 0x1c, 0xd6, 0x75, 0x5d, 0xd7, 0x75, 0x07, 0x21, 0x3a, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xbf, 0x3e, 0xc9, 0xca, 
	0x71, 0x6c, 0x02, 0xa2, 0xf8, 0xa0, 0x00};
unsigned char data_array_3_29[]={
	0x4d, 0x5d, 0xd7, 0x75, 0x5d, 0xd7, 0x79, 0xe7, 0x1c, 0xf0, 
	0x00, 0x00, 0x00, 0x00, 0x03, 0xf0, 0xbf, 0x3e, 0xc9, 0xca, 
	0x71, 0x6c, 0x42, 0x04, 0xf1, 0x20, 0x00};
unsigned char data_array_3_30[]={
	0x4e, 0x9e, 0xe7, 0x79, 0x9e, 0x57, 0x7e, 0xef, 0x9c, 0x6a, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xbf, 0x3e, 0xc9, 0xca, 
	0x71, 0x6c, 0x42, 0xa2, 0xf8, 0xa0, 0x00};
unsigned char data_array_3_31[]={
	0x4f, 0xdf, 0xf7, 0x7d, 0xdf, 0xf7, 0x95, 0xe7, 0x1c, 0x3a, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xbf, 0x3e, 0xc9, 0xca, 
	0x71, 0x6c, 0x42, 0xa2, 0xf8, 0xa0, 0x00};
unsigned char data_array_3_32[]={
	0x50, 0x60, 0x08, 0x86, 0x60, 0x18, 0x86, 0x27, 0x42, 0xf0, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x2e, 0xcc, 0xca, 
	0x71, 0x6c, 0x5a, 0xb2, 0xfc, 0xaf, 0x03};
unsigned char data_array_3_33[]={
	0x51, 0x61, 0x18, 0x86, 0xa0, 0x48, 0x10, 0xaf, 0x1e, 0x60, 
	0x01, 0x00, 0x00, 0x00, 0x01, 0xf0, 0xff, 0x2e, 0xcc, 0xca, 
	0x71, 0x6c, 0x42, 0xb2, 0xfc, 0xaf, 0x03};
unsigned char data_array_3_34[]={
	0x52, 0xa2, 0x08, 0x82, 0x20, 0x08, 0x82, 0xe7, 0x1c, 0x3a, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x2e, 0xcc, 0xca, 
	0x71, 0x6c, 0x42, 0xb2, 0xfc, 0xaf, 0x03};
unsigned char data_array_3_35[]={
	0x53, 0xe3, 0x38, 0x8e, 0xe3, 0x38, 0x26, 0xe7, 0x1c, 0x05, 
	0x00, 0x00, 0x00, 0x00, 0x01, 0xf0, 0x9f, 0x3e, 0xc9, 0xcb, 
	0x41, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00};
unsigned char data_array_3_36[]={
	0x54, 0x24, 0x45, 0x51, 0x04, 0x41, 0x10, 0xad, 0x59, 0x20, 
	0xa1, 0x07, 0x00, 0x00, 0x00, 0xf0, 0x9f, 0x3e, 0xc9, 0xcb, 
	0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x1c};
unsigned char data_array_3_37[]={
	0x55, 0xa5, 0x59, 0x9a, 0xa5, 0x69, 0x9a, 0x27, 0x42, 0xf0, 
	0x49, 0x02, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x3e, 0xc8, 0xca, 
	0x71, 0x6c, 0x5a, 0xb2, 0xfc, 0xaf, 0x03};
unsigned char data_array_3_38[]={
	0x56, 0xa6, 0x69, 0x9a, 0xe5, 0x09, 0x8a, 0xcf, 0x1c, 0x60, 
	0x01, 0x00, 0x00, 0x00, 0x01, 0xf0, 0xff, 0x3e, 0xc8, 0xca, 
	0x71, 0x6c, 0x42, 0xb2, 0xfc, 0xaf, 0x03};
unsigned char data_array_3_39[]={
	0x57, 0xe7, 0x59, 0x96, 0x65, 0x59, 0x96, 0xe7, 0x1c, 0x3a, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x3e, 0xc8, 0xca, 
	0x71, 0x6c, 0x42, 0xb2, 0xfc, 0xaf, 0x03};

#endif 
