#ifndef _EHCI_REG_H_
#define _EHCI_REG_H_

#define  EHCI_BASE                                    0xb8013000
#define  EHCI_OPBASE                                  (EHCI_BASE + 0x10)

#define  EHCI_USBCMD                                  (EHCI_OPBASE + 0x00)
#define  EHCI_USBCMD_bit_IntThreshold                 (0x00ff0000)
#define  EHCI_USBCMD_set_IntThreshold(data)           (0x00ff0000&((data)<<16))
#define  EHCI_USBCMD_get_IntThreshold(data)           ((0x00ff0000&(data))>>16)
#define  EHCI_USBCMD_set_AsyncParkEnable(data)        (0x00000800&((data)<<11))
#define  EHCI_USBCMD_get_AsyncParkEnable(data)        ((0x00000800&(data))>>11)
#define  EHCI_USBCMD_set_AsyncParkCount(data)         (0x00000300&((data)<<8))
#define  EHCI_USBCMD_get_AsyncParkCount(data)         ((0x00000300&(data))>>8)
#define  EHCI_USBCMD_set_LightHCReset(data)           (0x00000080&((data)<<7))
#define  EHCI_USBCMD_get_LightHCReset(data)           ((0x00000080&(data))>>7)
#define  EHCI_USBCMD_set_IntAsyncAdvDoorbell(data)    (0x00000040&((data)<<6))
#define  EHCI_USBCMD_get_IntAsyncAdvDoorbell(data)    ((0x00000040&(data))>>6)
#define  EHCI_USBCMD_set_AsyncSchedEnable(data)       (0x00000020&((data)<<5))
#define  EHCI_USBCMD_get_AsyncSchedEnable(data)       ((0x00000020&(data))>>5)
#define  EHCI_USBCMD_set_PerioSchedEnable(data)       (0x00000010&((data)<<4))
#define  EHCI_USBCMD_get_PerioSchedEnable(data)       ((0x00000010&(data))>>4)
#define  EHCI_USBCMD_bit_FrameListSize                (0x0000000c)
#define  EHCI_USBCMD_set_FrameListSize(data)          (0x0000000c&((data)<<2))
#define  EHCI_USBCMD_get_FrameListSize(data)          ((0x0000000c&(data))>>2)
#define  EHCI_USBCMD_set_HCRESET(data)                (0x00000002&((data)<<1))
#define  EHCI_USBCMD_get_HCRESET(data)                ((0x00000002&(data))>>1)
#define  EHCI_USBCMD_set_RunStop(data)                (0x00000001&(data))
#define  EHCI_USBCMD_get_RunStop(data)                (0x00000001&(data))

#define  EHCI_USBSTS                                  (EHCI_OPBASE + 0x04)
#define  EHCI_USBSTS_get_AsyncSchedStat(data)         ((0x00008000&(data))>>15)
#define  EHCI_USBSTS_get_PerioSchedStat(data)         ((0x00004000&(data))>>14)
#define  EHCI_USBSTS_get_Reclamation(data)            ((0x00002000&(data))>>13)
#define  EHCI_USBSTS_get_HCHalted(data)               ((0x00001000&(data))>>12)
#define  EHCI_USBSTS_bit_IntAsyncAdv                  (0x00000020)
#define  EHCI_USBSTS_set_IntAsyncAdv(data)            (0x00000020&((data)<<5))
#define  EHCI_USBSTS_get_IntAsyncAdv(data)            ((0x00000020&(data))>>5)
#define  EHCI_USBSTS_bit_HostSysError                 (0x00000010)
#define  EHCI_USBSTS_set_HostSysError(data)           (0x00000010&((data)<<4))
#define  EHCI_USBSTS_get_HostSysError(data)           ((0x00000010&(data))>>4)
#define  EHCI_USBSTS_bit_FrameListRoll                (0x00000008)
#define  EHCI_USBSTS_set_FrameListRoll(data)          (0x00000008&((data)<<3))
#define  EHCI_USBSTS_get_FrameListRoll(data)          ((0x00000008&(data))>>3)
#define  EHCI_USBSTS_bit_PortChgDetect                (0x00000004)
#define  EHCI_USBSTS_set_PortChgDetect(data)          (0x00000004&((data)<<2))
#define  EHCI_USBSTS_get_PortChgDetect(data)          ((0x00000004&(data))>>2)
#define  EHCI_USBSTS_bit_USBErrorInt                  (0x00000002)
#define  EHCI_USBSTS_set_USBErrorInt(data)            (0x00000002&((data)<<1))
#define  EHCI_USBSTS_get_USBErrorInt(data)            ((0x00000002&(data))>>1)
#define  EHCI_USBSTS_bit_USBInterrupt                 (0x00000001)
#define  EHCI_USBSTS_set_USBInterrupt(data)           (0x00000001&(data))
#define  EHCI_USBSTS_get_USBInterrupt(data)           (0x00000001&(data))

#define  EHCI_USBINTR                                 (EHCI_OPBASE + 0x08)
#define  EHCI_USBINTR_set_IntOnAsyncAdvEnable(data)   (0x00000020&((data)<<5))
#define  EHCI_USBINTR_get_IntOnAsyncAdvEnable(data)   ((0x00000020&(data))>>5)
#define  EHCI_USBINTR_set_HostSysErrorEnable(data)    (0x00000010&((data)<<4))
#define  EHCI_USBINTR_get_HostSysErrorEnable(data)    ((0x00000010&(data))>>4)
#define  EHCI_USBINTR_set_FrameListRollEnable(data)   (0x00000008&((data)<<3))
#define  EHCI_USBINTR_get_FrameListRollEnable(data)   ((0x00000008&(data))>>3)
#define  EHCI_USBINTR_set_PortChgIntEnable(data)      (0x00000004&((data)<<2))
#define  EHCI_USBINTR_get_PortChgIntEnable(data)      ((0x00000004&(data))>>2)
#define  EHCI_USBINTR_set_USBErrorIntEnable(data)     (0x00000002&((data)<<1))
#define  EHCI_USBINTR_get_USBErrorIntEnable(data)     ((0x00000002&(data))>>1)
#define  EHCI_USBINTR_set_USBInterruptEnable(data)    (0x00000001&(data))
#define  EHCI_USBINTR_get_USBInterruptEnable(data)    (0x00000001&(data))

#define  EHCI_FRINDEX                                 (EHCI_OPBASE + 0x0c)

#define  EHCI_PERIODICLISTBASE                        (EHCI_OPBASE + 0x14)

#define  EHCI_CONFIGFLAG                              (EHCI_OPBASE + 0x40)
#define  EHCI_CONFIGFLAG_set_CONFIGFLAG(data)         (0x00000001&(data))
#define  EHCI_CONFIGFLAG_get_CONFIGFLAG(data)         (0x00000001&(data))

#define  EHCI_PORTSC                                  (EHCI_OPBASE + 0x44)
#define  EHCI_PORTSC_set_WKOC_E(data)                 (0x00400000&((data)<<22))
#define  EHCI_PORTSC_get_WKOC_E(data)                 ((0x00400000&(data))>>22)
#define  EHCI_PORTSC_set_WKDSCNNT_E(data)             (0x00200000&((data)<<21))
#define  EHCI_PORTSC_get_WKDSCNNT_E(data)             ((0x00200000&(data))>>21)
#define  EHCI_PORTSC_set_WKCNNT_E(data)               (0x00100000&((data)<<20))
#define  EHCI_PORTSC_get_WKCNNT_E(data)               ((0x00100000&(data))>>20)
#define  EHCI_PORTSC_set_PortTestCtrl(data)           (0x000f0000&((data)<<16))
#define  EHCI_PORTSC_get_PortTestCtrl(data)           ((0x000f0000&(data))>>16)
#define  EHCI_PORTSC_set_PortOwner(data)              (0x00002000&((data)<<13))
#define  EHCI_PORTSC_get_PortOwner(data)              ((0x00002000&(data))>>13)
#define  EHCI_PORTSC_set_PortPower(data)              (0x00001000&((data)<<12))
#define  EHCI_PORTSC_get_PortPower(data)              ((0x00001000&(data))>>12)
#define  EHCI_PORTSC_set_LineStatus(data)             (0x00000c00&((data)<<10))
#define  EHCI_PORTSC_get_LineStatus(data)             ((0x00000c00&(data))>>10)
#define  EHCI_PORTSC_bit_PortReset                    (0x00000100)
#define  EHCI_PORTSC_set_PortReset(data)              (0x00000100&((data)<<8))
#define  EHCI_PORTSC_get_PortReset(data)              ((0x00000100&(data))>>8)
#define  EHCI_PORTSC_set_Suspend(data)                (0x00000080&((data)<<7))
#define  EHCI_PORTSC_get_Suspend(data)                ((0x00000080&(data))>>7)
#define  EHCI_PORTSC_set_ForcePortResume(data)        (0x00000040&((data)<<6))
#define  EHCI_PORTSC_get_ForcePortResume(data)        ((0x00000040&(data))>>6)
#define  EHCI_PORTSC_set_OverCurrentChange(data)      (0x00000020&((data)<<5))
#define  EHCI_PORTSC_get_OverCurrentChange(data)      ((0x00000020&(data))>>5)
#define  EHCI_PORTSC_get_OverCurrentActive(data)      ((0x00000010&(data))>>4)
#define  EHCI_PORTSC_set_PortEnableDisableChg(data)   (0x00000008&((data)<<3))
#define  EHCI_PORTSC_get_PortEnableDisableChg(data)   ((0x00000008&(data))>>3)
#define  EHCI_PORTSC_bit_PortEnabledDisabled          (0x00000004)
#define  EHCI_PORTSC_set_PortEnabledDisabled(data)    (0x00000004&((data)<<2))
#define  EHCI_PORTSC_get_PortEnabledDisabled(data)    ((0x00000004&(data))>>2)
#define  EHCI_PORTSC_set_ConnectStatusChg(data)       (0x00000002&((data)<<1))
#define  EHCI_PORTSC_get_ConnectStatusChg(data)       ((0x00000002&(data))>>1)
#define  EHCI_PORTSC_get_CurrentConnectStatus(data)   (0x00000001&(data))


#define  EHCI_INSNREG05                               (EHCI_OPBASE + 0x94)
#define  EHCI_INSNREG05_bit_VPort                     (0x0001E000)
#define  EHCI_INSNREG05_set_VPort(data)               (0x0001E000&((data)<<13))
#define  EHCI_INSNREG05_bit_VLoadM                    (0x00001000)
#define  EHCI_INSNREG05_set_VLoadM(data)              (0x00001000&((data)<<12))
#define  EHCI_INSNREG05_bit_VCtrl                     (0x00000F00)
#define  EHCI_INSNREG05_set_VCtrl(data)               (0x00000F00&((data)<<8))
#define  EHCI_INSNREG05_get_VBusy(data)               ((0x00020000&(data))>>17)
#define  EHCI_INSNREG05_get_VStatus(data)             (0x000000FF&(data))

#endif   // _EHCI_REG_H_
